/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigurationUtil {
    public static void doSetSafeValue(@Nullable CredentialAttributes credentialAttributes, @Nullable String credentialUser, @Nullable String secretValue) {
        CloudConfigurationUtil.doSetSafeValue(credentialAttributes, credentialUser, secretValue, value2 -> {});
    }

    public static void doSetSafeValue(@Nullable CredentialAttributes credentialAttributes, @Nullable String credentialUser, @Nullable String secretValue, @NotNull Consumer<? super String> unsafeSetter) {
        if (unsafeSetter == null) {
            CloudConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (credentialAttributes != null) {
            PasswordSafe.getInstance().set(credentialAttributes, new Credentials(credentialUser, secretValue), false);
            unsafeSetter.accept(null);
        } else {
            unsafeSetter.accept(secretValue);
        }
    }

    public static Optional<String> doGetSafeValue(@Nullable CredentialAttributes credentialAttributes) {
        return Optional.ofNullable(credentialAttributes).map(attributes -> PasswordSafe.getInstance().get((CredentialAttributes)attributes)).map(Credentials::getPasswordAsString);
    }

    public static String doGetSafeValue(@Nullable CredentialAttributes credentialAttributes, @NotNull Supplier<String> unsafeGetter) {
        if (unsafeGetter == null) {
            CloudConfigurationUtil.$$$reportNull$$$0(1);
        }
        return CloudConfigurationUtil.doGetSafeValue(credentialAttributes).orElseGet(unsafeGetter);
    }

    public static boolean hasSafeCredentials(@Nullable CredentialAttributes credentialAttributes) {
        return credentialAttributes != null && PasswordSafe.getInstance().get(credentialAttributes) != null;
    }

    @Nullable
    public static CredentialAttributes createCredentialAttributes(String serviceName, String credentialsUser) {
        return StringUtil.isEmpty(serviceName) || StringUtil.isEmpty(credentialsUser) ? null : new CredentialAttributes(serviceName, credentialsUser);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsafeSetter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsafeGetter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remoteServer/util/CloudConfigurationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doSetSafeValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetSafeValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

