/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceImpl;
import org.jetbrains.annotations.NotNull;

public class CloudRunConfigurationUtil {
    public static <SC extends ServerConfiguration, DC extends DeploymentConfiguration> DeployToServerRunConfiguration<SC, DC> createRunConfiguration(RemoteServer<SC> account, Module module2, DC deploymentConfiguration) {
        ModulePointer modulePointer = ModulePointerManager.getInstance(module2.getProject()).create(module2);
        ModuleDeploymentSourceImpl deploymentSource = new ModuleDeploymentSourceImpl(modulePointer);
        return CloudRunConfigurationUtil.createRunConfiguration(account, module2, deploymentSource, deploymentConfiguration);
    }

    public static <SC extends ServerConfiguration, DC extends DeploymentConfiguration> DeployToServerRunConfiguration<SC, DC> createRunConfiguration(@NotNull RemoteServer<SC> account, @NotNull Module module2, @NotNull DeploymentSource deploymentSource, DC deploymentConfiguration) {
        if (account == null) {
            CloudRunConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            CloudRunConfigurationUtil.$$$reportNull$$$0(1);
        }
        if (deploymentSource == null) {
            CloudRunConfigurationUtil.$$$reportNull$$$0(2);
        }
        RunManager runManager = RunManager.getInstance(module2.getProject());
        String name = CloudRunConfigurationUtil.generateRunConfigurationName(account, module2);
        ConfigurationFactory configurationFactory = DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType(account.getType()).getFactoryForType(deploymentSource.getType());
        RunnerAndConfigurationSettings runSettings = runManager.createConfiguration(name, configurationFactory);
        DeployToServerRunConfiguration result2 = (DeployToServerRunConfiguration)runSettings.getConfiguration();
        result2.setServerName(account.getName());
        result2.setDeploymentSource(deploymentSource);
        result2.setDeploymentConfiguration(deploymentConfiguration);
        RunManagerImplKt.callNewConfigurationCreated(configurationFactory, runSettings.getConfiguration());
        runManager.addConfiguration(runSettings);
        runManager.setSelectedConfiguration(runSettings);
        return result2;
    }

    private static String generateRunConfigurationName(@NotNull RemoteServer<?> account, Module module2) {
        if (account == null) {
            CloudRunConfigurationUtil.$$$reportNull$$$0(3);
        }
        String accountName = account.getName();
        String moduleName = module2.getName();
        return CloudBundle.message("run.configuration.name", accountName, moduleName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "account";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentSource";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remoteServer/util/CloudRunConfigurationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateRunConfigurationName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

