/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import javax.swing.JComponent;

public abstract class DelayedRunner
implements Disposable {
    private static final int CHANGES_CHECK_TIME = 500;
    private static final int RUN_DELAY_TIME = 2000;
    private static final int NO_CHANGES = -1;
    private final Alarm myAlarm;
    private int myChangesPastTime = -1;

    public DelayedRunner(JComponent activationComponent) {
        this.myAlarm = new Alarm().setActivationComponent(activationComponent);
        this.queueChangesCheck();
    }

    private void queueChangesCheck() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.addRequest(() -> {
            this.checkChanges();
            this.queueChangesCheck();
        }, 500, ModalityState.any());
    }

    private void checkChanges() {
        if (this.wasChanged()) {
            this.myChangesPastTime = 0;
        } else if (this.myChangesPastTime != -1) {
            this.myChangesPastTime += 500;
            if (this.myChangesPastTime >= 2000) {
                this.myChangesPastTime = -1;
                this.run();
            }
        }
    }

    @Override
    public void dispose() {
        Disposer.dispose(this.myAlarm);
    }

    protected abstract boolean wasChanged();

    protected abstract void run();
}

