/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.remoteServer.util.Column;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class JTableWrapper<T, C extends Column<T>> {
    private static final int COLUMN_HEADER_MARGIN_WIDTH = 2;
    private final C[] myColumns;
    private final JTableWrapperModel myTableModel;
    private final JBTable myTable;
    private List<T> myInputRows;

    public JTableWrapper(JBTable table, C[] columns) {
        this.myTable = table;
        this.myColumns = columns;
        this.myTableModel = this.createTableModel();
        for (C column : this.myColumns) {
            this.myTableModel.addColumn(((Column)column).getName());
        }
        this.myTable.setModel(this.myTableModel);
        this.packColumns();
        this.myTable.getSelectionModel().setSelectionMode(0);
    }

    private void packColumns() {
        TableColumn col;
        int iColumn;
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.myTable.getColumnModel();
        int[] colMinWidths = new int[this.myColumns.length];
        for (iColumn = 0; iColumn < this.myColumns.length; ++iColumn) {
            col = colModel.getColumn(iColumn);
            colMinWidths[iColumn] = col.getMinWidth();
            if (!((Column)this.myColumns[iColumn]).needPack()) {
                col.setWidth(col.getMinWidth());
                continue;
            }
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.myTable.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.myTable, col.getHeaderValue(), false, false, 0, 0);
            int colWidth = comp.getPreferredSize().width;
            for (int iRow = 0; iRow < this.myTable.getRowCount(); ++iRow) {
                renderer = this.myTable.getCellRenderer(iRow, iColumn);
                comp = renderer.getTableCellRendererComponent(this.myTable, this.myTable.getValueAt(iRow, iColumn), false, false, iRow, iColumn);
                colWidth = Math.max(colWidth, comp.getPreferredSize().width);
            }
            col.setMaxWidth(colWidth += 4);
            col.setMinWidth(colWidth);
        }
        for (iColumn = 0; iColumn < this.myColumns.length; ++iColumn) {
            col = colModel.getColumn(iColumn);
            col.setMinWidth(colMinWidths[iColumn]);
        }
    }

    public C[] getColumns() {
        return this.myColumns;
    }

    private DefaultTableModel getTableModel() {
        return this.myTableModel;
    }

    private void setInput(Iterable<Collection<Object>> input) {
        this.getTableModel().setRowCount(0);
        for (Collection<Object> row : input) {
            this.getTableModel().addRow(row.toArray());
        }
        this.packColumns();
    }

    public void setInputRows(List<T> rows) {
        this.myInputRows = rows;
        ArrayList<Collection<Object>> input = new ArrayList<Collection<Object>>();
        for (T row : rows) {
            ArrayList<Object> rowCellValues = new ArrayList<Object>();
            for (Column column : this.getColumns()) {
                rowCellValues.add(column.getColumnValue(row));
            }
            input.add(rowCellValues);
        }
        this.setInput(input);
    }

    public JBTable getTable() {
        return this.myTable;
    }

    protected JTableWrapperModel createTableModel() {
        return new JTableWrapperModel();
    }

    protected class JTableWrapperModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        protected JTableWrapperModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return JTableWrapper.this.myColumns[column].isEditable();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return JTableWrapper.this.myColumns[columnIndex].getValueClass();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            JTableWrapper.this.myColumns[column].setColumnValue(JTableWrapper.this.myInputRows.get(row), aValue);
            super.setValueAt(aValue, row, column);
        }
    }
}

