/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reporting;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.reporting.FreezeLogger;
import com.intellij.reporting.ReporterKt;
import com.intellij.reporting.StatsSender;
import com.intellij.reporting.ThreadDumpInfo;
import com.intellij.util.Alarm;
import java.lang.management.ThreadInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FreezeLoggerImpl
extends FreezeLogger {
    private static final Logger LOG = Logger.getInstance(FreezeLoggerImpl.class);
    private static final Alarm ALARM = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, ApplicationManager.getApplication());
    private static final int MAX_ALLOWED_TIME = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runUnderPerformanceMonitor(@Nullable Project project2, @NotNull Runnable action2) {
        if (action2 == null) {
            FreezeLoggerImpl.$$$reportNull$$$0(0);
        }
        if (!FreezeLoggerImpl.shouldReport() || DebugAttachDetector.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            action2.run();
            return;
        }
        ModalityState initial = ModalityState.current();
        ALARM.cancelAllRequests();
        ALARM.addRequest(() -> FreezeLoggerImpl.dumpThreads(project2, initial), 500);
        try {
            action2.run();
        }
        finally {
            ALARM.cancelAllRequests();
        }
    }

    private static boolean shouldReport() {
        return Registry.is("typing.freeze.report.dumps");
    }

    private static void dumpThreads(@Nullable Project project2, @NotNull ModalityState initialState) {
        ThreadInfo[] infos;
        String edtTrace;
        if (initialState == null) {
            FreezeLoggerImpl.$$$reportNull$$$0(1);
        }
        if ((edtTrace = ThreadDumper.dumpEdtStackTrace(infos = ThreadDumper.getThreadInfos())).contains("java.lang.ClassLoader.loadClass")) {
            return;
        }
        boolean isInDumbMode = project2 != null && !project2.isDisposed() && DumbService.isDumb(project2);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!initialState.equals(ModalityState.current())) {
                return;
            }
            FreezeLoggerImpl.sendDumpsInBackground(infos, isInDumbMode);
        }, ModalityState.any());
    }

    private static void sendDumpsInBackground(ThreadInfo[] infos, boolean isInDumbMode) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ThreadDumpInfo info = new ThreadDumpInfo(infos, isInDumbMode);
            String report = ReporterKt.createReportLine("typing-freeze-dumps", "random_session_id", info);
            if (!StatsSender.INSTANCE.send(report, true)) {
                LOG.debug("Error while reporting thread dump");
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/reporting/FreezeLoggerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runUnderPerformanceMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpThreads";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

