/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemContributorEP;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SemServiceImpl
extends SemService {
    private static final Logger LOG = Logger.getInstance(SemServiceImpl.class);
    private volatile MultiMap<SemKey<?>, NullableFunction<PsiElement, Collection<? extends SemElement>>> myProducers;
    private final Project myProject;
    private final CachedValuesManager myCVManager;

    public SemServiceImpl(Project project2) {
        this.myProject = project2;
        this.myCVManager = CachedValuesManager.getManager(this.myProject);
        SemContributor.EP_NAME.addExtensionPointListener(() -> {
            this.myProducers = null;
        }, (Disposable)project2);
    }

    private MultiMap<SemKey<?>, NullableFunction<PsiElement, Collection<? extends SemElement>>> collectProducers() {
        final MultiMap<SemKey<?>, NullableFunction<PsiElement, Collection<? extends SemElement>>> map2 = MultiMap.createSmart();
        SemRegistrar registrar = new SemRegistrar(){

            @Override
            public <T extends SemElement, V extends PsiElement> void registerSemElementProvider(SemKey<T> key, ElementPattern<? extends V> place, NullableFunction<? super V, ? extends T> provider) {
                map2.putValue(key, element2 -> {
                    if (place.accepts(element2)) {
                        return Collections.singleton(provider.fun((Object)element2));
                    }
                    return null;
                });
            }

            @Override
            public <T extends SemElement, V extends PsiElement> void registerRepeatableSemElementProvider(SemKey<T> key, ElementPattern<? extends V> place, NullableFunction<? super V, ? extends Collection<T>> provider) {
                map2.putValue(key, element2 -> {
                    if (place.accepts(element2)) {
                        return (Collection)provider.fun((Object)element2);
                    }
                    return null;
                });
            }
        };
        for (SemContributorEP contributor : SemContributor.EP_NAME.getExtensionList()) {
            SemContributor semContributor;
            try {
                semContributor = (SemContributor)this.myProject.instantiateExtensionWithPicoContainerOnlyIfNeeded(contributor.implementation, contributor.getPluginDescriptor());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (ExtensionNotApplicableException e) {
                continue;
            }
            catch (Exception e) {
                LOG.error(e);
                continue;
            }
            semContributor.registerSemProviders(registrar, this.myProject);
        }
        return map2;
    }

    @Override
    public <T extends SemElement> List<T> getSemElements(@NotNull SemKey<T> key, @NotNull PsiElement psi) {
        SemCacheChunk chunk;
        List<T> cached;
        if (key == null) {
            SemServiceImpl.$$$reportNull$$$0(0);
        }
        if (psi == null) {
            SemServiceImpl.$$$reportNull$$$0(1);
        }
        return (cached = SemServiceImpl.findCached(key, chunk = (SemCacheChunk)this.myCVManager.getCachedValue(psi, () -> CachedValueProvider.Result.create(new SemCacheChunk(), PsiModificationTracker.MODIFICATION_COUNT)))) != null ? cached : this.createSemElements(key, psi, chunk);
    }

    @NotNull
    private <T extends SemElement> List<T> createSemElements(@NotNull SemKey<T> key, @NotNull PsiElement psi, SemCacheChunk chunk) {
        if (key == null) {
            SemServiceImpl.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            SemServiceImpl.$$$reportNull$$$0(3);
        }
        this.ensureInitialized();
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        LinkedHashSet<SemElement> result2 = new LinkedHashSet<SemElement>();
        THashMap map2 = new THashMap();
        for (SemKey<?> each : key.getInheritors()) {
            List<SemElement> list2 = this.createSemElements(each, psi);
            map2.put(each, list2);
            result2.addAll(list2);
        }
        if (stamp.mayCacheNow()) {
            for (SemKey<Object> semKey : map2.keySet()) {
                chunk.putSemElements(semKey, (List)map2.get(semKey));
            }
        }
        return new ArrayList(result2);
    }

    private void ensureInitialized() {
        if (this.myProducers == null) {
            this.myProducers = this.collectProducers();
        }
    }

    @NotNull
    private List<SemElement> createSemElements(SemKey<?> key, PsiElement psi) {
        SmartList result2 = null;
        Collection<NullableFunction<PsiElement, Collection<? extends SemElement>>> functions = this.myProducers.get(key);
        if (!functions.isEmpty()) {
            for (NullableFunction<PsiElement, Collection<? extends SemElement>> producer : functions) {
                Collection<? extends SemElement> elements2 = producer.fun(psi);
                if (elements2 == null) continue;
                if (result2 == null) {
                    result2 = new SmartList();
                }
                ContainerUtil.addAllNotNull(result2, elements2);
            }
        }
        List<SemElement> list2 = result2 == null ? Collections.emptyList() : Collections.unmodifiableList(result2);
        if (list2 == null) {
            SemServiceImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Nullable
    private static <T extends SemElement> List<T> findCached(SemKey<T> key, SemCacheChunk chunk) {
        List<SemElement> singleList = null;
        LinkedHashSet<SemElement> result2 = null;
        List<SemKey<?>> inheritors = key.getInheritors();
        for (int i = 0; i < inheritors.size(); ++i) {
            List<SemElement> cached = chunk.getSemElements(inheritors.get(i));
            if (cached == null) {
                return null;
            }
            if (cached == Collections.emptyList()) continue;
            if (singleList == null) {
                singleList = cached;
                continue;
            }
            if (result2 == null) {
                result2 = new LinkedHashSet<SemElement>(singleList);
            }
            result2.addAll(cached);
        }
        if (result2 == null) {
            if (singleList != null) {
                return singleList;
            }
            return Collections.emptyList();
        }
        return new ArrayList(result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/semantic/SemServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/semantic/SemServiceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSemElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSemElements";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSemElements";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SemCacheChunk {
        private final IntObjectMap<List<SemElement>> map = ContainerUtil.createConcurrentIntObjectMap();

        private SemCacheChunk() {
        }

        List<SemElement> getSemElements(SemKey<?> key) {
            return this.map.get(key.getUniqueId());
        }

        void putSemElements(SemKey<?> key, List<SemElement> elements2) {
            this.map.put(key.getUniqueId(), elements2);
        }
    }
}

