/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafEquality;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SliceLeafAnalyzer {
    private static final Logger LOG = Logger.getInstance(SliceLeafAnalyzer.class);
    @NotNull
    private final SliceLeafEquality myLeafEquality;
    @NotNull
    private final SliceLanguageSupportProvider myProvider;

    public SliceLeafAnalyzer(@NotNull SliceLeafEquality leafEquality, @NotNull SliceLanguageSupportProvider provider) {
        if (leafEquality == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(1);
        }
        this.myLeafEquality = leafEquality;
        this.myProvider = provider;
    }

    public static SliceNode filterTree(SliceNode oldRoot, NullableFunction<? super SliceNode, ? extends SliceNode> filter2, PairProcessor<? super SliceNode, ? super List<SliceNode>> postProcessor) {
        boolean success;
        SliceNode filtered2 = filter2.fun(oldRoot);
        if (filtered2 == null) {
            return null;
        }
        ArrayList<SliceNode> childrenFiltered = new ArrayList<SliceNode>();
        if (oldRoot.myCachedChildren != null) {
            for (SliceNode child2 : oldRoot.myCachedChildren) {
                SliceNode childFiltered = SliceLeafAnalyzer.filterTree(child2, filter2, postProcessor);
                if (childFiltered == null) continue;
                childrenFiltered.add(childFiltered);
            }
        }
        boolean bl = success = postProcessor == null || postProcessor.process(filtered2, childrenFiltered);
        if (!success) {
            return null;
        }
        filtered2.myCachedChildren = new ArrayList<SliceNode>(childrenFiltered);
        return filtered2;
    }

    private void groupByValues(@NotNull Collection<? extends PsiElement> leaves, @NotNull SliceRootNode oldRoot, @NotNull Map<SliceNode, Collection<PsiElement>> map2) {
        if (leaves == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(2);
        }
        if (oldRoot == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(3);
        }
        if (map2 == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(4);
        }
        assert (oldRoot.myCachedChildren.size() == 1);
        SliceRootNode root = this.createTreeGroupedByValues(leaves, oldRoot, map2);
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceUsage rootUsage = (SliceUsage)oldRootStart.getValue();
        String description = SliceManager.getElementDescription(null, rootUsage.getElement(), " (grouped by value)");
        SliceManager.getInstance(root.getProject()).createToolWindow(true, root, true, description);
    }

    @NotNull
    public SliceRootNode createTreeGroupedByValues(@NotNull Collection<? extends PsiElement> leaves, @NotNull SliceRootNode oldRoot, @NotNull Map<SliceNode, Collection<PsiElement>> map2) {
        if (leaves == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(5);
        }
        if (oldRoot == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(6);
        }
        if (map2 == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(7);
        }
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceRootNode root = oldRoot.copy();
        root.setChanged();
        root.targetEqualUsages.clear();
        ArrayList<SliceLeafValueRootNode> leafValueRoots = new ArrayList<SliceLeafValueRootNode>(leaves.size());
        for (PsiElement psiElement : leaves) {
            SliceNode newNode = SliceLeafAnalyzer.filterTree(oldRootStart, oldNode -> {
                if (oldNode.getDuplicate() != null) {
                    return null;
                }
                if (!SliceLeafAnalyzer.node(oldNode, map2).contains(leafExpression)) {
                    return null;
                }
                return oldNode.copy();
            }, (node, children2) -> {
                if (!children2.isEmpty()) {
                    return true;
                }
                PsiElement element2 = ((SliceUsage)node.getValue()).getElement();
                if (element2 == null) {
                    return false;
                }
                return element2.getManager().areElementsEquivalent(element2, leafExpression);
            });
            SliceLeafValueRootNode lvNode = new SliceLeafValueRootNode(root.getProject(), root, this.myProvider.createRootUsage(psiElement, ((SliceUsage)oldRoot.getValue()).params), Collections.singletonList(newNode));
            leafValueRoots.add(lvNode);
        }
        root.setChildren(leafValueRoots);
        SliceRootNode sliceRootNode = root;
        if (sliceRootNode == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(8);
        }
        return sliceRootNode;
    }

    public void startAnalyzeValues(final @NotNull AbstractTreeStructure treeStructure, final @NotNull Runnable finish) {
        if (treeStructure == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(9);
        }
        if (finish == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(10);
        }
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref<Object> leafExpressions = Ref.create(null);
        final Map<SliceNode, Collection<PsiElement>> map2 = this.createMap();
        String encouragementPiece = " (may very well take the whole day)";
        ProgressManager.getInstance().run(new Task.Backgroundable(root.getProject(), "Expanding All Nodes..." + encouragementPiece, true){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Collection<PsiElement> l = SliceLeafAnalyzer.this.calcLeafExpressions(root, treeStructure, map2);
                leafExpressions.set(l);
            }

            @Override
            public void onCancel() {
                finish.run();
            }

            @Override
            public void onSuccess() {
                try {
                    Collection leaves = (Collection)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    if (leaves.isEmpty()) {
                        Messages.showErrorDialog("Unable to find leaf expressions to group by", "Cannot Group");
                        return;
                    }
                    SliceLeafAnalyzer.this.groupByValues(leaves, root, map2);
                }
                finally {
                    finish.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/slicer/SliceLeafAnalyzer$1", "run"));
            }
        });
    }

    public Map<SliceNode, Collection<PsiElement>> createMap() {
        return ConcurrentFactoryMap.create(k -> ConcurrentCollectionFactory.createConcurrentSet(this.myLeafEquality), () -> ConcurrentCollectionFactory.createMap(ContainerUtil.identityStrategy()));
    }

    private static Collection<PsiElement> node(SliceNode node, Map<SliceNode, Collection<PsiElement>> map2) {
        return map2.get(node);
    }

    @NotNull
    public Collection<PsiElement> calcLeafExpressions(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, Collection<PsiElement>> map2) {
        if (root == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(11);
        }
        if (treeStructure == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(12);
        }
        if (map2 == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(13);
        }
        final SliceNodeGuide guide = new SliceNodeGuide(treeStructure);
        final AtomicInteger depth = new AtomicInteger();
        final boolean printToLog = LOG.isTraceEnabled();
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            @Override
            public void elementStarted(@NotNull SliceNode element2) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                depth.incrementAndGet();
                super.elementStarted(element2);
            }

            @Override
            public void visit(@NotNull SliceNode element2) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                element2.calculateDupNode();
                SliceLeafAnalyzer.node(element2, map2).clear();
                SliceNode duplicate = element2.getDuplicate();
                if (duplicate != null) {
                    SliceLeafAnalyzer.node(element2, map2).addAll(SliceLeafAnalyzer.node(duplicate, map2));
                } else {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement value2;
                        SliceUsage sliceUsage = (SliceUsage)element2.getValue();
                        Collection<SliceNode> children2 = element2.getChildren();
                        if (printToLog) {
                            LOG.trace(StringUtil.repeat("  ", Math.max(depth.get(), 0)) + "analyzing usages of " + sliceUsage + " (in " + (sliceUsage == null ? "null" : sliceUsage.getFile().getName() + ":" + sliceUsage.getLine()) + ")");
                        }
                        if (children2.isEmpty() && sliceUsage != null && sliceUsage.canBeLeaf() && (value2 = sliceUsage.getElement()) != null) {
                            SliceLeafAnalyzer.node(element2, map2).addAll(ContainerUtil.singleton(value2, SliceLeafAnalyzer.this.myLeafEquality));
                        }
                    });
                    super.visit(element2);
                }
            }

            @Override
            public void elementFinished(@NotNull SliceNode element2) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                depth.decrementAndGet();
                SliceNode parent = guide.getParent(element2);
                if (parent != null) {
                    SliceLeafAnalyzer.node(parent, map2).addAll(SliceLeafAnalyzer.node(element2, map2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/intellij/slicer/SliceLeafAnalyzer$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        walkingState.visit(root);
        Collection<PsiElement> collection = SliceLeafAnalyzer.node(root, map2);
        if (collection == null) {
            SliceLeafAnalyzer.$$$reportNull$$$0(14);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafEquality";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaves";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 4: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceLeafAnalyzer";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceLeafAnalyzer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeGroupedByValues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLeafExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "groupByValues";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTreeGroupedByValues";
                break;
            }
            case 8: 
            case 14: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startAnalyzeValues";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcLeafExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SliceNodeGuide
    implements WalkingState.TreeGuide<SliceNode> {
        private final AbstractTreeStructure myTreeStructure;

        public SliceNodeGuide(@NotNull AbstractTreeStructure treeStructure) {
            if (treeStructure == null) {
                SliceNodeGuide.$$$reportNull$$$0(0);
            }
            this.myTreeStructure = treeStructure;
        }

        @Override
        public SliceNode getNextSibling(@NotNull SliceNode element2) {
            AbstractTreeNode parent;
            if (element2 == null) {
                SliceNodeGuide.$$$reportNull$$$0(1);
            }
            if ((parent = element2.getParent()) == null) {
                return null;
            }
            return element2.getNext((List)parent.getChildren());
        }

        @Override
        public SliceNode getPrevSibling(@NotNull SliceNode element2) {
            AbstractTreeNode parent;
            if (element2 == null) {
                SliceNodeGuide.$$$reportNull$$$0(2);
            }
            if ((parent = element2.getParent()) == null) {
                return null;
            }
            return element2.getPrev((List)parent.getChildren());
        }

        @Override
        public SliceNode getFirstChild(@NotNull SliceNode element2) {
            Object[] children2;
            if (element2 == null) {
                SliceNodeGuide.$$$reportNull$$$0(3);
            }
            return (children2 = this.myTreeStructure.getChildElements(element2)).length == 0 ? null : (SliceNode)children2[0];
        }

        @Override
        public SliceNode getParent(@NotNull SliceNode element2) {
            AbstractTreeNode parent;
            if (element2 == null) {
                SliceNodeGuide.$$$reportNull$$$0(4);
            }
            return (parent = element2.getParent()) instanceof SliceNode ? (SliceNode)parent : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeStructure";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/slicer/SliceLeafAnalyzer$SliceNodeGuide";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNextSibling";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrevSibling";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstChild";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

