/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceHandler;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SlicePanel;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceToolwindowSettings;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

@State(name="SliceManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SliceManager
implements PersistentStateComponent<StoredSettingsBean> {
    private final Project myProject;
    private ContentManager myBackContentManager;
    private ContentManager myForthContentManager;
    private final StoredSettingsBean myStoredSettings;
    private static final String BACK_TOOLWINDOW_ID = "Analyze Dataflow to";
    private static final String FORTH_TOOLWINDOW_ID = "Analyze Dataflow from";

    public static SliceManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            SliceManager.$$$reportNull$$$0(0);
        }
        return ServiceManager.getService(project2, SliceManager.class);
    }

    public SliceManager(@NotNull Project project2) {
        if (project2 == null) {
            SliceManager.$$$reportNull$$$0(1);
        }
        this.myStoredSettings = new StoredSettingsBean();
        this.myProject = project2;
    }

    private ContentManager getContentManager(boolean dataFlowToThis) {
        if (dataFlowToThis) {
            if (this.myBackContentManager == null) {
                ToolWindow backToolWindow = ToolWindowManager.getInstance(this.myProject).registerToolWindow(BACK_TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM, this.myProject);
                this.myBackContentManager = backToolWindow.getContentManager();
                ContentManagerWatcher.watchContentManager(backToolWindow, this.myBackContentManager);
            }
            return this.myBackContentManager;
        }
        if (this.myForthContentManager == null) {
            ToolWindow forthToolWindow = ToolWindowManager.getInstance(this.myProject).registerToolWindow(FORTH_TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM, this.myProject);
            this.myForthContentManager = forthToolWindow.getContentManager();
            ContentManagerWatcher.watchContentManager(forthToolWindow, this.myForthContentManager);
        }
        return this.myForthContentManager;
    }

    public void slice(@NotNull PsiElement element2, boolean dataFlowToThis, @NotNull SliceHandler handler2) {
        if (element2 == null) {
            SliceManager.$$$reportNull$$$0(2);
        }
        if (handler2 == null) {
            SliceManager.$$$reportNull$$$0(3);
        }
        String dialogTitle = SliceManager.getElementDescription((dataFlowToThis ? BACK_TOOLWINDOW_ID : FORTH_TOOLWINDOW_ID) + " ", element2, null);
        dialogTitle = Pattern.compile("(<style>.*</style>)|<[^<>]*>", 32).matcher(dialogTitle).replaceAll("");
        SliceAnalysisParams params = handler2.askForParams(element2, dataFlowToThis, this.myStoredSettings, StringUtil.unescapeXmlEntities(dialogTitle));
        if (params == null) {
            return;
        }
        SliceRootNode rootNode = new SliceRootNode(this.myProject, new DuplicateMap(), LanguageSlicing.getProvider(element2).createRootUsage(element2, params));
        this.createToolWindow(dataFlowToThis, rootNode, false, SliceManager.getElementDescription(null, element2, null));
    }

    public void createToolWindow(boolean dataFlowToThis, @NotNull SliceRootNode rootNode, boolean splitByLeafExpressions, @NotNull String displayName) {
        if (rootNode == null) {
            SliceManager.$$$reportNull$$$0(4);
        }
        if (displayName == null) {
            SliceManager.$$$reportNull$$$0(5);
        }
        final SliceToolwindowSettings sliceToolwindowSettings = SliceToolwindowSettings.getInstance(this.myProject);
        final ContentManager contentManager2 = this.getContentManager(dataFlowToThis);
        final Content[] myContent = new Content[1];
        ToolWindow toolWindow = ToolWindowManager.getInstance(this.myProject).getToolWindow(dataFlowToThis ? BACK_TOOLWINDOW_ID : FORTH_TOOLWINDOW_ID);
        SlicePanel slicePanel = new SlicePanel(this.myProject, dataFlowToThis, rootNode, splitByLeafExpressions, toolWindow){

            @Override
            protected void close() {
                super.close();
                contentManager2.removeContent(myContent[0], true);
            }

            @Override
            public boolean isAutoScroll() {
                return sliceToolwindowSettings.isAutoScroll();
            }

            @Override
            public void setAutoScroll(boolean autoScroll) {
                sliceToolwindowSettings.setAutoScroll(autoScroll);
            }

            @Override
            public boolean isPreview() {
                return sliceToolwindowSettings.isPreview();
            }

            @Override
            public void setPreview(boolean preview) {
                sliceToolwindowSettings.setPreview(preview);
            }
        };
        myContent[0] = contentManager2.getFactory().createContent(slicePanel, displayName, true);
        contentManager2.addContent(myContent[0]);
        contentManager2.setSelectedContent(myContent[0]);
        toolWindow.activate(null);
    }

    public static String getElementDescription(String prefix, PsiElement element2, String suffix) {
        SliceLanguageSupportProvider provider = LanguageSlicing.getProvider(element2);
        if (provider != null) {
            element2 = provider.getElementForDescription(element2);
        }
        String desc = ElementDescriptionUtil.getElementDescription(element2, RefactoringDescriptionLocation.WITHOUT_PARENT);
        return "<html><body>" + (prefix == null ? "" : prefix) + StringUtil.first(desc, 100, true) + (suffix == null ? "" : suffix) + "</body></html>";
    }

    @Override
    public StoredSettingsBean getState() {
        return this.myStoredSettings;
    }

    @Override
    public void loadState(@NotNull StoredSettingsBean state) {
        if (state == null) {
            SliceManager.$$$reportNull$$$0(6);
        }
        this.myStoredSettings.analysisUIOptions.loadState(state.analysisUIOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/slicer/SliceManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "slice";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class StoredSettingsBean {
        boolean showDereferences = true;
        AnalysisUIOptions analysisUIOptions = new AnalysisUIOptions();

        StoredSettingsBean() {
        }
    }
}

