/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.context.ContextInfo;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class WorkingContextManager {
    private static final Logger LOG = Logger.getInstance(WorkingContextManager.class);
    @NonNls
    private static final String TASKS_FOLDER = "tasks";
    private final Project myProject;
    @NonNls
    private static final String TASKS_ZIP_POSTFIX = ".tasks.zip";
    @NonNls
    private static final String TASK_XML_POSTFIX = ".task.xml";
    private static final String CONTEXT_ZIP_POSTFIX = ".contexts.zip";
    private static final Comparator<JBZipEntry> ENTRY_COMPARATOR = (o1, o2) -> Long.signum(o2.getTime() - o1.getTime());
    private boolean ENABLED;

    public static WorkingContextManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            WorkingContextManager.$$$reportNull$$$0(0);
        }
        return project2.getService(WorkingContextManager.class);
    }

    public WorkingContextManager(@NotNull Project project2) {
        if (project2 == null) {
            WorkingContextManager.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.ENABLED = !ApplicationManager.getApplication().isUnitTestMode();
    }

    public void enableUntil(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            WorkingContextManager.$$$reportNull$$$0(2);
        }
        this.ENABLED = true;
        Disposer.register(disposable2, () -> {
            this.ENABLED = false;
        });
    }

    public void loadContext(@NotNull Element fromElement) {
        if (fromElement == null) {
            WorkingContextManager.$$$reportNull$$$0(3);
        }
        for (WorkingContextProvider provider : WorkingContextProvider.EP_NAME.getExtensionList()) {
            try {
                Element child2 = fromElement.getChild(provider.getId());
                if (child2 == null) continue;
                provider.loadContext(this.myProject, child2);
            }
            catch (InvalidDataException e) {
                LOG.error(e);
            }
        }
    }

    public void saveContext(Element toElement) {
        for (WorkingContextProvider provider : WorkingContextProvider.EP_NAME.getExtensionList()) {
            try {
                Element child2 = new Element(provider.getId());
                provider.saveContext(this.myProject, child2);
                toElement.addContent(child2);
            }
            catch (WriteExternalException e) {
                LOG.error(e);
            }
        }
    }

    public void clearContext() {
        for (WorkingContextProvider provider : WorkingContextProvider.EP_NAME.getExtensionList()) {
            provider.clearContext(this.myProject);
        }
    }

    public void saveContext(Task task2) {
        String entryName = task2.getId() + TASK_XML_POSTFIX;
        this.saveContext(entryName, TASKS_ZIP_POSTFIX, task2.getSummary());
    }

    public void saveContext(@Nullable String entryName, @Nullable String comment) {
        this.saveContext(entryName, CONTEXT_ZIP_POSTFIX, comment);
    }

    public boolean hasContext(String entryName) {
        return this.doEntryAction(CONTEXT_ZIP_POSTFIX, entryName, entry -> {});
    }

    private synchronized void saveContext(@Nullable String entryName, String zipPostfix, @Nullable String comment) {
        if (!this.ENABLED) {
            return;
        }
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            if (entryName == null) {
                int i = archive.getEntries().size();
                do {
                    entryName = "context" + i++;
                } while (archive.getEntry("/" + entryName) != null);
            }
            JBZipEntry entry = archive.getOrCreateEntry("/" + entryName);
            if (comment != null) {
                entry.setComment(StringUtil.first(comment, 200, true));
            }
            Element element2 = new Element("context");
            this.saveContext(element2);
            String s = new XMLOutputter().outputString(element2);
            entry.setData(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    private JBZipFile getTasksArchive(String postfix) {
        File file2 = this.getArchiveFile(postfix);
        try {
            return new JBZipFile(file2);
        }
        catch (IOException e) {
            file2.delete();
            JBZipFile zipFile = null;
            try {
                zipFile = new JBZipFile(file2);
                Notifications.Bus.notify(new Notification("Tasks", "Context Data Corrupted", "Context information history for " + this.myProject.getName() + " was corrupted.\nThe history was replaced with empty one.", NotificationType.ERROR), this.myProject);
            }
            catch (IOException e1) {
                LOG.error("Can't repair form context data corruption", e1);
            }
            return zipFile;
        }
    }

    private File getArchiveFile(String postfix) {
        File tasksFolder = PathManager.getConfigDir().resolve(TASKS_FOLDER).toFile();
        if (!tasksFolder.exists()) {
            tasksFolder.mkdirs();
        }
        String projectName = FileUtil.sanitizeFileName(this.myProject.getName());
        return new File(tasksFolder, projectName + postfix);
    }

    public void restoreContext(@NotNull Task task2) {
        if (task2 == null) {
            WorkingContextManager.$$$reportNull$$$0(4);
        }
        this.loadContext(TASKS_ZIP_POSTFIX, task2.getId() + TASK_XML_POSTFIX);
    }

    private boolean loadContext(String zipPostfix, String entryName) {
        return this.doEntryAction(zipPostfix, entryName, entry -> {
            String s = new String(entry.getData(), StandardCharsets.UTF_8);
            this.loadContext(JDOMUtil.load(s));
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean doEntryAction(String zipPostfix, String entryName, ThrowableConsumer<JBZipEntry, Exception> action2) {
        if (!this.ENABLED) {
            return false;
        }
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            JBZipEntry entry = archive.getEntry(StringUtil.startsWithChar(entryName, '/') ? entryName : "/" + entryName);
            if (entry == null) return false;
            action2.consume(entry);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return false;
    }

    public List<ContextInfo> getContextHistory() {
        return this.getContextHistory(CONTEXT_ZIP_POSTFIX);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized List<ContextInfo> getContextHistory(String zipPostfix) {
        if (!this.ENABLED) {
            return Collections.emptyList();
        }
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            List<JBZipEntry> entries = archive.getEntries();
            List<ContextInfo> list2 = ContainerUtil.mapNotNull(entries, entry -> entry.getName().startsWith("/context") ? new ContextInfo(entry.getName(), entry.getTime(), entry.getComment()) : null);
            return list2;
        }
        catch (Exception e) {
            LOG.error(e);
            return Collections.emptyList();
        }
    }

    public boolean loadContext(String name) {
        return this.loadContext(CONTEXT_ZIP_POSTFIX, name);
    }

    public void removeContext(String name) {
        this.removeContext(name, CONTEXT_ZIP_POSTFIX);
    }

    public void removeContext(Task task2) {
        this.removeContext(task2.getId(), TASKS_ZIP_POSTFIX);
    }

    private void removeContext(String name, String postfix) {
        if (!this.ENABLED) {
            return;
        }
        try (JBZipFile archive = this.getTasksArchive(postfix);){
            JBZipEntry entry = archive.getEntry(name);
            if (entry != null) {
                archive.eraseEntry(entry);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public void pack(int max, int delta) {
        this.pack(max, delta, CONTEXT_ZIP_POSTFIX);
        this.pack(max, delta, TASKS_ZIP_POSTFIX);
    }

    private synchronized void pack(int max, int delta, String zipPostfix) {
        if (!this.ENABLED) {
            return;
        }
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            List<JBZipEntry> entries = archive.getEntries();
            if (entries.size() > max + delta) {
                JBZipEntry[] array = entries.toArray(new JBZipEntry[0]);
                Arrays.sort(array, ENTRY_COMPARATOR);
                for (int i = array.length - 1; i >= max; --i) {
                    archive.eraseEntry(array[i]);
                }
                archive.gc();
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public File getContextFile() {
        return this.getArchiveFile(CONTEXT_ZIP_POSTFIX);
    }

    public File getTaskFile() {
        return this.getArchiveFile(TASKS_ZIP_POSTFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tasks/context/WorkingContextManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "enableUntil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

