/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.serialization.SerializationException;
import com.intellij.tasks.BranchInfo;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskProjectConfiguration;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TaskManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class TaskManagerImpl
extends TaskManager
implements PersistentStateComponent<Config>,
ChangeListDecorator,
Disposable {
    private static final Logger LOG = Logger.getInstance(TaskManagerImpl.class);
    private static final DecimalFormat LOCAL_TASK_ID_FORMAT = new DecimalFormat("LOCAL-00000");
    public static final Comparator<Task> TASK_UPDATE_COMPARATOR = (o1, o2) -> {
        int i = Comparing.compare(o2.getUpdated(), o1.getUpdated());
        return i == 0 ? Comparing.compare(o2.getCreated(), o1.getCreated()) : i;
    };
    private static final Convertor<Task, String> KEY_CONVERTOR = o -> o.getId();
    private final Project myProject;
    private final Map<String, Task> myIssueCache;
    private final Map<String, LocalTask> myTasks;
    @NotNull
    private LocalTask myActiveTask;
    private Timer myCacheRefreshTimer;
    private volatile boolean myUpdating;
    private final Config myConfig;
    private final ChangeListAdapter myChangeListListener;
    private final List<TaskRepository> myRepositories;
    private final EventDispatcher<TaskListener> myDispatcher;
    private final Set<TaskRepository> myBadRepositories;

    public TaskManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(0);
        }
        this.myIssueCache = Collections.synchronizedMap(new LinkedHashMap());
        this.myTasks = Collections.synchronizedMap(new LinkedHashMap<String, LocalTask>(){

            @Override
            public LocalTask put(String key, LocalTask task2) {
                LocalTask result2 = super.put(key, task2);
                if (this.size() > ((TaskManagerImpl)TaskManagerImpl.this).myConfig.taskHistoryLength) {
                    ArrayList list2 = new ArrayList(this.entrySet());
                    Collections.sort(list2, (o1, o2) -> TASK_UPDATE_COMPARATOR.compare((Task)o2.getValue(), (Task)o1.getValue()));
                    for (Map.Entry oldest : list2) {
                        if (((LocalTask)oldest.getValue()).isDefault()) continue;
                        this.remove(oldest.getKey());
                        break;
                    }
                }
                return result2;
            }
        });
        this.myActiveTask = TaskManagerImpl.createDefaultTask();
        this.myConfig = new Config();
        this.myRepositories = new ArrayList<TaskRepository>();
        this.myDispatcher = EventDispatcher.create(TaskListener.class);
        this.myBadRepositories = ContainerUtil.newConcurrentSet();
        this.myProject = project2;
        this.myChangeListListener = new ChangeListAdapter(){

            @Override
            public void changeListRemoved(ChangeList list2) {
                LocalTask task2 = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)list2);
                if (task2 != null) {
                    for (ChangeListInfo info : task2.getChangeLists()) {
                        if (!Comparing.equal(info.id, ((LocalChangeList)list2).getId())) continue;
                        info.id = "";
                    }
                }
            }

            @Override
            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                if (automatic) {
                    return;
                }
                LocalTask associatedTask = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)newDefaultList);
                if (associatedTask != null && !TaskManagerImpl.this.getActiveTask().equals(associatedTask)) {
                    ApplicationManager.getApplication().invokeLater(() -> TaskManagerImpl.this.activateTask(associatedTask, true), TaskManagerImpl.this.myProject.getDisposed());
                }
            }
        };
        project2.getMessageBus().connect().subscribe(ProjectManager.TOPIC, new ProjectManagerListener(){

            @Override
            public void projectOpened(@NotNull Project project2) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (TaskManagerImpl.this.myProject == project2) {
                    TaskManagerImpl.this.projectOpened();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/impl/TaskManagerImpl$3", "projectOpened"));
            }
        });
    }

    public void prepareForNextTest() {
        this.myTasks.clear();
        LocalTaskImpl defaultTask = TaskManagerImpl.createDefaultTask();
        this.addTask(defaultTask);
        this.myActiveTask = defaultTask;
        this.setRepositories(Collections.emptyList());
    }

    @Override
    public TaskRepository[] getAllRepositories() {
        return this.myRepositories.toArray(new TaskRepository[0]);
    }

    public <T extends TaskRepository> void setRepositories(@NotNull List<T> repositories) {
        if (repositories == null) {
            TaskManagerImpl.$$$reportNull$$$0(1);
        }
        HashSet<TaskRepository> set = new HashSet<TaskRepository>(this.myRepositories);
        set.removeAll(repositories);
        this.myBadRepositories.removeAll(set);
        this.myIssueCache.clear();
        this.myRepositories.clear();
        this.myRepositories.addAll(repositories);
        List<TaskProjectConfiguration.SharedServer> servers = this.getProjectConfiguration().servers;
        servers.clear();
        block0: for (TaskRepository repository : repositories) {
            if (!repository.isShared() || repository.getUrl() == null) continue;
            TaskRepositoryType type = repository.getRepositoryType();
            for (TaskProjectConfiguration.SharedServer server : servers) {
                if (!repository.getUrl().equals(server.url) || !type.getName().equals(server.type)) continue;
                continue block0;
            }
            TaskProjectConfiguration.SharedServer server = new TaskProjectConfiguration.SharedServer();
            server.type = type.getName();
            server.url = repository.getUrl();
            servers.add(server);
        }
    }

    @Override
    public void removeTask(@NotNull LocalTask task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(2);
        }
        if (task2.isDefault()) {
            return;
        }
        if (this.myActiveTask.equals(task2)) {
            this.activateTask(this.myTasks.get("Default"), true);
        }
        this.myTasks.remove(task2.getId());
        this.myDispatcher.getMulticaster().taskRemoved(task2);
        WorkingContextManager.getInstance(this.myProject).removeContext(task2);
    }

    @Override
    public void addTaskListener(TaskListener listener2) {
        this.myDispatcher.addListener(listener2);
    }

    @Override
    public void addTaskListener(@NotNull TaskListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            TaskManagerImpl.$$$reportNull$$$0(4);
        }
        this.myDispatcher.addListener(listener2, parentDisposable);
    }

    @Override
    public void removeTaskListener(TaskListener listener2) {
        this.myDispatcher.removeListener(listener2);
    }

    @Override
    @NotNull
    public LocalTask getActiveTask() {
        LocalTask localTask = this.myActiveTask;
        if (localTask == null) {
            TaskManagerImpl.$$$reportNull$$$0(5);
        }
        return localTask;
    }

    @Override
    @Nullable
    public LocalTask findTask(String id2) {
        return this.myTasks.get(id2);
    }

    @Override
    @NotNull
    public List<Task> getIssues(@Nullable String query) {
        List<Task> list2 = this.getIssues(query, true);
        if (list2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    public List<Task> getIssues(@Nullable String query, boolean forceRequest) {
        return this.getIssues(query, 0, 50, true, new EmptyProgressIndicator(), forceRequest);
    }

    @Override
    public List<Task> getIssues(@Nullable String query, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator indicator, boolean forceRequest) {
        List<Task> tasks;
        if (indicator == null) {
            TaskManagerImpl.$$$reportNull$$$0(7);
        }
        if ((tasks = this.getIssuesFromRepositories(query, offset, limit, withClosed, forceRequest, indicator)) == null) {
            return this.getCachedIssues(withClosed);
        }
        this.myIssueCache.putAll(ContainerUtil.newMapFromValues(tasks.iterator(), KEY_CONVERTOR));
        return ContainerUtil.filter(tasks, task2 -> withClosed || !task2.isClosed());
    }

    @Override
    public List<Task> getCachedIssues() {
        return this.getCachedIssues(true);
    }

    @Override
    public List<Task> getCachedIssues(boolean withClosed) {
        return ContainerUtil.filter(this.myIssueCache.values(), task2 -> withClosed || !task2.isClosed());
    }

    private void updateIssue(@NotNull String id2) {
        if (id2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(8);
        }
        for (TaskRepository repository : this.getAllRepositories()) {
            if (repository.extractId(id2) == null) continue;
            try {
                LOG.info("Searching for task '" + id2 + "' in " + repository);
                Task issue = repository.findTask(id2);
                if (issue == null) continue;
                LocalTask localTask = this.findTask(id2);
                if (localTask != null) {
                    localTask.updateFromIssue(issue);
                    return;
                }
                return;
            }
            catch (Exception e) {
                LOG.info(e);
            }
        }
    }

    @Override
    public List<LocalTask> getLocalTasks() {
        return this.getLocalTasks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LocalTask> getLocalTasks(boolean withClosed) {
        Map<String, LocalTask> map2 = this.myTasks;
        synchronized (map2) {
            return ContainerUtil.filter(this.myTasks.values(), task2 -> withClosed || !this.isLocallyClosed((LocalTask)task2));
        }
    }

    @Override
    public LocalTask addTask(@NotNull Task issue) {
        if (issue == null) {
            TaskManagerImpl.$$$reportNull$$$0(9);
        }
        LocalTaskImpl task2 = issue instanceof LocalTaskImpl ? (LocalTaskImpl)issue : new LocalTaskImpl(issue);
        this.addTask(task2);
        return task2;
    }

    @Override
    public LocalTaskImpl createLocalTask(@NotNull String summary) {
        if (summary == null) {
            TaskManagerImpl.$$$reportNull$$$0(10);
        }
        return TaskManagerImpl.createTask(LOCAL_TASK_ID_FORMAT.format(this.myConfig.localTasksCounter++), summary);
    }

    private static LocalTaskImpl createTask(@NotNull String id2, @NotNull String summary) {
        if (id2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(11);
        }
        if (summary == null) {
            TaskManagerImpl.$$$reportNull$$$0(12);
        }
        LocalTaskImpl task2 = new LocalTaskImpl(id2, summary);
        Date date = new Date();
        task2.setCreated(date);
        task2.setUpdated(date);
        return task2;
    }

    @Override
    public LocalTask activateTask(@NotNull Task origin, boolean clearContext) {
        if (origin == null) {
            TaskManagerImpl.$$$reportNull$$$0(13);
        }
        return this.activateTask(origin, clearContext, false);
    }

    public LocalTask activateTask(@NotNull Task origin, boolean clearContext, boolean newTask) {
        LocalTask activeTask;
        if (origin == null) {
            TaskManagerImpl.$$$reportNull$$$0(14);
        }
        if (origin.equals(activeTask = this.getActiveTask())) {
            return activeTask;
        }
        this.saveActiveTask();
        LocalTask task2 = this.doActivate(origin, true);
        Runnable restore = () -> {
            WorkingContextManager contextManager = WorkingContextManager.getInstance(this.myProject);
            if (clearContext) {
                contextManager.clearContext();
            }
            contextManager.restoreContext(origin);
        };
        boolean switched = false;
        if (this.isVcsEnabled()) {
            this.restoreVcsContext(task2, newTask);
            if (!newTask) {
                switched = this.switchBranch(task2, restore);
            }
        }
        if (!switched) {
            restore.run();
        }
        return task2;
    }

    private void restoreVcsContext(LocalTask task2, boolean newTask) {
        List<ChangeListInfo> changeLists = task2.getChangeLists();
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
        if (changeLists.isEmpty()) {
            task2.addChangelist(new ChangeListInfo(changeListManager.getDefaultChangeList()));
        } else {
            ChangeListInfo info = changeLists.get(0);
            LocalChangeList changeList = changeListManager.getChangeList(info.id);
            if (changeList == null) {
                changeList = changeListManager.addChangeList(info.name, info.comment);
                info.id = changeList.getId();
            }
            changeListManager.setDefaultChangeList(changeList);
        }
        this.unshelveChanges(task2);
    }

    private boolean switchBranch(LocalTask task2, Runnable invokeAfter) {
        List<BranchInfo> branches = task2.getBranches(false);
        MultiMap<String, BranchInfo> multiMap = new MultiMap<String, BranchInfo>();
        for (BranchInfo branch : branches) {
            multiMap.putValue(branch.repository, branch);
        }
        block1: for (String repo : multiMap.keySet()) {
            Collection infos = multiMap.get(repo);
            if (infos.size() <= 1) continue;
            List<BranchInfo> existing = this.getAllBranches(repo);
            Iterator iterator2 = infos.iterator();
            while (iterator2.hasNext()) {
                BranchInfo info = (BranchInfo)iterator2.next();
                if (existing.contains(info)) continue;
                iterator2.remove();
                if (infos.size() != 1) continue;
                continue block1;
            }
        }
        VcsTaskHandler.TaskInfo info = TaskManagerImpl.fromBranches(new ArrayList<BranchInfo>(multiMap.values()));
        VcsTaskHandler[] handlers = VcsTaskHandler.getAllHandlers(this.myProject);
        boolean switched = false;
        for (VcsTaskHandler handler2 : handlers) {
            switched |= handler2.switchToTask(info, invokeAfter);
        }
        return switched;
    }

    public void shelveChanges(LocalTask task2, @NotNull String shelfName) {
        Collection<Change> changes;
        if (shelfName == null) {
            TaskManagerImpl.$$$reportNull$$$0(15);
        }
        if ((changes = ChangeListManager.getInstance(this.myProject).getDefaultChangeList().getChanges()).isEmpty()) {
            return;
        }
        try {
            ShelveChangesManager.getInstance((Project)this.myProject).shelveChanges(changes, shelfName, true);
            task2.setShelfName(shelfName);
        }
        catch (Exception e) {
            LOG.warn("Can't shelve changes", e);
        }
    }

    private void unshelveChanges(LocalTask task2) {
        String name = task2.getShelfName();
        if (name != null) {
            ShelveChangesManager manager = ShelveChangesManager.getInstance((Project)this.myProject);
            ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
            for (ShelvedChangeList list2 : manager.getShelvedChangeLists()) {
                if (!name.equals(list2.DESCRIPTION)) continue;
                manager.unshelveChangeList(list2, null, list2.getBinaryFiles(), changeListManager.getDefaultChangeList(), true);
                return;
            }
        }
    }

    private List<BranchInfo> getAllBranches(String repo) {
        VcsTaskHandler[] handlers;
        ArrayList<BranchInfo> infos = new ArrayList<BranchInfo>();
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers(this.myProject)) {
            VcsTaskHandler.TaskInfo[] tasks;
            for (VcsTaskHandler.TaskInfo info : tasks = handler2.getAllExistingTasks()) {
                infos.addAll(ContainerUtil.filter(BranchInfo.fromTaskInfo(info, false), info1 -> Comparing.equal(info1.repository, repo)));
            }
        }
        return infos;
    }

    private static VcsTaskHandler.TaskInfo fromBranches(List<BranchInfo> branches) {
        if (branches.isEmpty()) {
            return new VcsTaskHandler.TaskInfo(null, Collections.emptyList());
        }
        MultiMap<String, String> map2 = new MultiMap<String, String>();
        for (BranchInfo branch : branches) {
            map2.putValue(branch.name, branch.repository);
        }
        Map.Entry next = map2.entrySet().iterator().next();
        return new VcsTaskHandler.TaskInfo((String)next.getKey(), next.getValue());
    }

    public void createBranch(LocalTask task2, LocalTask previousActive, String name, @Nullable VcsTaskHandler.TaskInfo branchFrom) {
        VcsTaskHandler[] handlers;
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers(this.myProject)) {
            VcsTaskHandler.TaskInfo[] info = handler2.getCurrentTasks();
            if (previousActive != null && previousActive.getBranches(false).isEmpty()) {
                TaskManagerImpl.addBranches(previousActive, info, false);
            }
            TaskManagerImpl.addBranches(task2, info, true);
            if (info.length == 0 && branchFrom != null) {
                TaskManagerImpl.addBranches(task2, new VcsTaskHandler.TaskInfo[]{branchFrom}, true);
            }
            TaskManagerImpl.addBranches(task2, new VcsTaskHandler.TaskInfo[]{handler2.startNewTask(name)}, false);
        }
    }

    public void mergeBranch(LocalTask task2) {
        VcsTaskHandler[] handlers;
        VcsTaskHandler.TaskInfo original = TaskManagerImpl.fromBranches(task2.getBranches(true));
        VcsTaskHandler.TaskInfo feature = TaskManagerImpl.fromBranches(task2.getBranches(false));
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers(this.myProject)) {
            handler2.closeTask(feature, original);
        }
    }

    public static void addBranches(LocalTask task2, VcsTaskHandler.TaskInfo[] info, boolean original) {
        for (VcsTaskHandler.TaskInfo taskInfo : info) {
            List<BranchInfo> branchInfos = BranchInfo.fromTaskInfo(taskInfo, original);
            for (BranchInfo branchInfo : branchInfos) {
                task2.addBranch(branchInfo);
            }
        }
    }

    private void saveActiveTask() {
        WorkingContextManager.getInstance(this.myProject).saveContext(this.myActiveTask);
        this.myActiveTask.setUpdated(new Date());
        String shelfName = this.myActiveTask.getShelfName();
        if (shelfName != null) {
            this.shelveChanges(this.myActiveTask, shelfName);
        }
    }

    private LocalTask doActivate(Task origin, boolean explicitly) {
        LocalTask oldActiveTask;
        LocalTaskImpl task2;
        LocalTaskImpl localTaskImpl = task2 = origin instanceof LocalTaskImpl ? (LocalTaskImpl)origin : new LocalTaskImpl(origin);
        if (explicitly) {
            task2.setUpdated(new Date());
        }
        this.myActiveTask.setActive(false);
        task2.setActive(true);
        this.addTask(task2);
        if (task2.isIssue()) {
            StartupManager.getInstance(this.myProject).runWhenProjectIsInitialized(() -> ProgressManager.getInstance().run(new Task.Backgroundable(this.myProject, "Updating " + task2.getPresentableId()){

                @Override
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    TaskManagerImpl.this.updateIssue(task2.getId());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl$4", "run"));
                }
            }));
        }
        boolean isChanged = !task2.equals(oldActiveTask = this.myActiveTask);
        this.myActiveTask = task2;
        if (isChanged) {
            this.myDispatcher.getMulticaster().taskDeactivated(oldActiveTask);
            this.myDispatcher.getMulticaster().taskActivated(task2);
        }
        return task2;
    }

    private void addTask(@NotNull LocalTaskImpl task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(16);
        }
        this.myTasks.put(task2.getId(), task2);
        this.myDispatcher.getMulticaster().taskAdded(task2);
    }

    @Override
    public boolean testConnection(final TaskRepository repository) {
        TestConnectionTask task2 = new TestConnectionTask("Test connection"){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                indicator.setText("Connecting to " + repository.getUrl() + "...");
                indicator.setFraction(0.0);
                indicator.setIndeterminate(true);
                try {
                    this.myConnection = repository.createCancellableConnection();
                    if (this.myConnection != null) {
                        future = ApplicationManager.getApplication().executeOnPooledThread(this.myConnection);
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            try {
                                this.myException = future.get(100L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            catch (TimeoutException ignore) {
                                try {
                                    indicator.checkCanceled();
                                    continue;
                                }
                                catch (ProcessCanceledException e) {
                                    this.myException = e;
                                    this.myConnection.cancel();
                                    return;
                                }
                            }
                            ** while (true)
                            catch (Exception e) {
                                this.myException = e;
                                return;
                            }
                            break;
                        }
                    }
                    try {
                        repository.testConnection();
                    }
                    catch (Exception e) {
                        TaskManagerImpl.access$300().info(e);
                        this.myException = e;
                    }
                }
                catch (Exception e) {
                    this.myException = e;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl$5", "run"));
            }
        };
        ProgressManager.getInstance().run(task2);
        Exception e = task2.myException;
        if (e == null) {
            this.myBadRepositories.remove(repository);
            Messages.showMessageDialog(this.myProject, "Connection is successful", "Connection", Messages.getInformationIcon());
        } else if (!(e instanceof ProcessCanceledException)) {
            String message = e.getMessage();
            if (e instanceof UnknownHostException) {
                message = "Unknown host: " + message;
            }
            if (message == null) {
                LOG.error(e);
                message = "Unknown error";
            }
            Messages.showErrorDialog(this.myProject, StringUtil.capitalize(message), "Error");
        }
        return e == null;
    }

    @Override
    @NotNull
    public Config getState() {
        this.myConfig.tasks = ContainerUtil.map(this.myTasks.values(), task2 -> new LocalTaskImpl((Task)task2));
        this.myConfig.servers = XmlSerializer.serialize(this.getAllRepositories());
        Config config2 = this.myConfig;
        if (config2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(17);
        }
        return config2;
    }

    @Override
    public void loadState(@NotNull Config config2) {
        if (config2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(18);
        }
        config2.branchNameFormat = TaskUtil.updateToVelocity(config2.branchNameFormat);
        config2.changelistNameFormat = TaskUtil.updateToVelocity(config2.changelistNameFormat);
        XmlSerializerUtil.copyBean(config2, this.myConfig);
        this.myRepositories.clear();
        Element element2 = config2.servers;
        ArrayList<TaskRepository> repositories = TaskManagerImpl.loadRepositories(element2);
        this.myRepositories.addAll(repositories);
        this.myTasks.clear();
        for (LocalTaskImpl task2 : config2.tasks) {
            String url;
            if (task2.getRepository() == null && (url = task2.getIssueUrl()) != null) {
                for (TaskRepository repository : repositories) {
                    if (repository.getUrl() == null || !url.startsWith(repository.getUrl())) continue;
                    task2.setRepository(repository);
                }
            }
            this.addTask(task2);
        }
    }

    public static ArrayList<TaskRepository> loadRepositories(@NotNull Element element2) {
        if (element2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(19);
        }
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
            for (Element o : element2.getChildren(repositoryType.getName())) {
                try {
                    TaskRepository repository = (TaskRepository)XmlSerializer.deserialize(o, repositoryType.getRepositoryClass());
                    repository.setRepositoryType(repositoryType);
                    repository.initializeRepository();
                    repositories.add(repository);
                }
                catch (SerializationException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        }
        return repositories;
    }

    public void callProjectOpened() {
        this.projectOpened();
    }

    private void projectOpened() {
        TaskProjectConfiguration projectConfiguration = this.getProjectConfiguration();
        block0: for (TaskProjectConfiguration.SharedServer server : projectConfiguration.servers) {
            if (server.type == null || server.url == null) continue;
            for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
                if (!repositoryType.getName().equals(server.type)) continue;
                for (TaskRepository repository : this.myRepositories) {
                    if (!repositoryType.equals(repository.getRepositoryType()) || !server.url.equals(repository.getUrl())) continue;
                    continue block0;
                }
                TaskRepository repository = repositoryType.createRepository();
                repository.setUrl(server.url);
                repository.setShared(true);
                this.myRepositories.add(repository);
            }
        }
        LocalTask defaultTask = this.findTask("Default");
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
        LocalChangeList defaultList = changeListManager.findChangeList(LocalChangeList.getDefaultName());
        if (defaultList != null && defaultTask != null) {
            ChangeListInfo listInfo = new ChangeListInfo(defaultList);
            if (!defaultTask.getChangeLists().contains(listInfo)) {
                defaultTask.addChangelist(listInfo);
            }
        }
        for (LocalTask localTask : this.getLocalTasks()) {
            Iterator<ChangeListInfo> iterator2 = localTask.getChangeLists().iterator();
            while (iterator2.hasNext()) {
                ChangeListInfo changeListInfo = iterator2.next();
                if (changeListManager.getChangeList(changeListInfo.id) != null) continue;
                iterator2.remove();
            }
        }
        changeListManager.addChangeListListener(this.myChangeListListener, this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> WorkingContextManager.getInstance(this.myProject).pack(200, 50));
        }
    }

    private TaskProjectConfiguration getProjectConfiguration() {
        return ServiceManager.getService(this.myProject, TaskProjectConfiguration.class);
    }

    @Override
    public void initializeComponent() {
        LocalTask defaultTask;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCacheRefreshTimer = TimerUtil.createNamedTimer("TaskManager refresh", this.myConfig.updateInterval * 60 * 1000, new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (((TaskManagerImpl)TaskManagerImpl.this).myConfig.updateEnabled && !TaskManagerImpl.this.myUpdating) {
                        LOG.debug("Updating issues cache (every " + ((TaskManagerImpl)TaskManagerImpl.this).myConfig.updateInterval + " min)");
                        TaskManagerImpl.this.updateIssues(null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/impl/TaskManagerImpl$6", "actionPerformed"));
                }
            });
            this.myCacheRefreshTimer.setInitialDelay(0);
            StartupManager.getInstance(this.myProject).registerPostStartupActivity(() -> this.myCacheRefreshTimer.start());
        }
        if ((defaultTask = this.findTask("Default")) == null) {
            defaultTask = TaskManagerImpl.createDefaultTask();
            this.addTask(defaultTask);
        }
        LocalTask activeTask = null;
        List<LocalTask> tasks = this.getLocalTasks();
        Collections.sort(tasks, TASK_UPDATE_COMPARATOR);
        for (LocalTask task2 : tasks) {
            if (activeTask == null) {
                if (!task2.isActive()) continue;
                activeTask = task2;
                continue;
            }
            task2.setActive(false);
        }
        if (activeTask == null) {
            activeTask = defaultTask;
        }
        this.myActiveTask = activeTask;
        this.doActivate(this.myActiveTask, false);
        this.myDispatcher.getMulticaster().taskActivated(this.myActiveTask);
    }

    @NotNull
    private static LocalTaskImpl createDefaultTask() {
        LocalTaskImpl task2 = new LocalTaskImpl("Default", "Default task");
        Date date = new Date();
        task2.setCreated(date);
        task2.setUpdated(date);
        LocalTaskImpl localTaskImpl = task2;
        if (localTaskImpl == null) {
            TaskManagerImpl.$$$reportNull$$$0(20);
        }
        return localTaskImpl;
    }

    @Override
    public void dispose() {
        if (this.myCacheRefreshTimer != null) {
            this.myCacheRefreshTimer.stop();
        }
    }

    @Override
    public void updateIssues(@Nullable Runnable onComplete) {
        TaskRepository first = ContainerUtil.find(this.getAllRepositories(), repository -> repository.isConfigured());
        if (first == null) {
            this.myIssueCache.clear();
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        this.myUpdating = true;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doUpdate(onComplete);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.doUpdate(onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(@Nullable Runnable onComplete) {
        try {
            List<Task> issues = this.getIssuesFromRepositories(null, 0, this.myConfig.updateIssuesCount, false, false, new EmptyProgressIndicator());
            if (issues == null) {
                return;
            }
            Map<String, Task> map2 = this.myIssueCache;
            synchronized (map2) {
                this.myIssueCache.clear();
                for (Task task2 : issues) {
                    this.myIssueCache.put(task2.getId(), task2);
                }
            }
            map2 = this.myTasks;
            synchronized (map2) {
                for (Map.Entry entry : this.myTasks.entrySet()) {
                    Task issue = this.myIssueCache.get(entry.getKey());
                    if (issue == null) continue;
                    ((LocalTask)entry.getValue()).updateFromIssue(issue);
                }
            }
        }
        finally {
            if (onComplete != null) {
                onComplete.run();
            }
            this.myUpdating = false;
        }
    }

    @Nullable
    private List<Task> getIssuesFromRepositories(@Nullable String request2, int offset, int limit, boolean withClosed, boolean forceRequest, @NotNull ProgressIndicator cancelled) {
        if (cancelled == null) {
            TaskManagerImpl.$$$reportNull$$$0(21);
        }
        ArrayList<Task> issues = null;
        for (TaskRepository repository : this.getAllRepositories()) {
            if (!repository.isConfigured() || !forceRequest && this.myBadRepositories.contains(repository)) continue;
            try {
                long start2 = System.currentTimeMillis();
                Task[] tasks = repository.getIssues(request2, offset, limit, withClosed, cancelled);
                long timeSpent = System.currentTimeMillis() - start2;
                LOG.debug(String.format("Total %s ms to download %d issues from '%s' (pattern '%s')", timeSpent, tasks.length, repository.getUrl(), request2));
                this.myBadRepositories.remove(repository);
                if (issues == null) {
                    issues = new ArrayList<Task>(tasks.length);
                }
                if (!repository.isSupported(16) && request2 != null) {
                    List<Task> filteredTasks = TaskUtil.filterTasks(request2, Arrays.asList(tasks));
                    issues.addAll(filteredTasks);
                    continue;
                }
                ContainerUtil.addAll(issues, tasks);
            }
            catch (ProcessCanceledException start2) {
            }
            catch (Exception e) {
                String reason = "";
                if (e.getClass() == Exception.class || e instanceof RequestFailedException) {
                    reason = e.getMessage();
                }
                if (e instanceof SocketTimeoutException || e instanceof HttpRequests.HttpStatusException) {
                    LOG.warn("Can't connect to " + repository + ": " + e.getMessage());
                } else {
                    LOG.warn("Cannot connect to " + repository, e);
                }
                this.myBadRepositories.add(repository);
                if (!forceRequest) continue;
                throw new RequestFailedException(repository, reason);
            }
        }
        return issues;
    }

    @Override
    public boolean isVcsEnabled() {
        return ProjectLevelVcsManager.getInstance(this.myProject).getAllActiveVcss().length > 0;
    }

    @Override
    public AbstractVcs getActiveVcs() {
        AbstractVcs[] vcss = ProjectLevelVcsManager.getInstance(this.myProject).getAllActiveVcss();
        if (vcss.length == 0) {
            return null;
        }
        for (AbstractVcs vcs : vcss) {
            if (vcs.getType() != VcsType.distributed) continue;
            return vcs;
        }
        return vcss[0];
    }

    @Override
    public boolean isLocallyClosed(@NotNull LocalTask localTask) {
        if (localTask == null) {
            TaskManagerImpl.$$$reportNull$$$0(22);
        }
        if (!this.isVcsEnabled()) {
            return false;
        }
        List<ChangeListInfo> lists = localTask.getChangeLists();
        return lists.isEmpty() || lists.stream().anyMatch(list2 -> StringUtil.isEmpty(list2.id));
    }

    @Override
    @Nullable
    public LocalTask getAssociatedTask(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(23);
        }
        if (TaskManagerImpl.hasChangelist(this.getActiveTask(), list2)) {
            return this.getActiveTask();
        }
        for (LocalTask task2 : this.getLocalTasks()) {
            if (!TaskManagerImpl.hasChangelist(task2, list2)) continue;
            return task2;
        }
        return null;
    }

    private static boolean hasChangelist(LocalTask task2, LocalChangeList list2) {
        for (ChangeListInfo changeListInfo : new ArrayList<ChangeListInfo>(task2.getChangeLists())) {
            if (!changeListInfo.id.equals(list2.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void trackContext(@NotNull LocalChangeList changeList) {
        if (changeList == null) {
            TaskManagerImpl.$$$reportNull$$$0(24);
        }
        ChangeListInfo changeListInfo = new ChangeListInfo(changeList);
        String changeListName = changeList.getName();
        LocalTaskImpl task2 = this.createLocalTask(changeListName);
        task2.addChangelist(changeListInfo);
        this.addTask(task2);
        if (changeList.isDefault()) {
            this.activateTask(task2, false);
        }
    }

    @Override
    public void decorateChangeList(@NotNull LocalChangeList changeList, @NotNull ColoredTreeCellRenderer cellRenderer, boolean selected2, boolean expanded, boolean hasFocus) {
        LocalTask task2;
        if (changeList == null) {
            TaskManagerImpl.$$$reportNull$$$0(25);
        }
        if (cellRenderer == null) {
            TaskManagerImpl.$$$reportNull$$$0(26);
        }
        if ((task2 = this.getAssociatedTask(changeList)) != null && task2.isIssue()) {
            cellRenderer.setIcon(task2.getIcon());
        }
    }

    public void createChangeList(@NotNull LocalTask task2, String name) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(27);
        }
        String comment = TaskUtil.getChangeListComment(task2);
        this.createChangeList(task2, name, comment);
    }

    private void createChangeList(LocalTask task2, String name, @Nullable String comment) {
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
        LocalChangeList changeList = changeListManager.findChangeList(name);
        if (changeList == null) {
            changeList = changeListManager.addChangeList(name, comment);
        } else {
            LocalTask associatedTask = this.getAssociatedTask(changeList);
            if (associatedTask != null) {
                associatedTask.removeChangelist(new ChangeListInfo(changeList));
            }
            changeListManager.editComment(name, comment);
        }
        task2.addChangelist(new ChangeListInfo(changeList));
        changeListManager.setDefaultChangeList(changeList);
    }

    public String getChangelistName(Task task2) {
        String name = task2.isIssue() && this.myConfig.changelistNameFormat != null ? TaskUtil.formatTask(task2, this.myConfig.changelistNameFormat) : task2.getSummary();
        return StringUtil.shortenTextWithEllipsis(name, 100, 0);
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task2, String separator) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(28);
        }
        String name = this.constructDefaultBranchName(task2);
        if (task2.isIssue()) {
            String string = name.replace(" ", separator);
            if (string == null) {
                TaskManagerImpl.$$$reportNull$$$0(29);
            }
            return string;
        }
        List<String> words = StringUtil.getWordsIn(name);
        String[] strings = ArrayUtilRt.toStringArray(words);
        String string = StringUtil.join(strings, 0, Math.min(2, strings.length), separator);
        if (string == null) {
            TaskManagerImpl.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(31);
        }
        String string = this.suggestBranchName(task2, "-");
        if (string == null) {
            TaskManagerImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public String constructDefaultBranchName(@NotNull Task task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(33);
        }
        String string = task2.isIssue() ? TaskUtil.formatTask(task2, this.myConfig.branchNameFormat) : task2.getSummary();
        if (string == null) {
            TaskManagerImpl.$$$reportNull$$$0(34);
        }
        return string;
    }

    public ChangeListAdapter getChangeListListener() {
        return this.myChangeListListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: 
            case 16: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/TaskManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelfName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTask";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/TaskManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultTask";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestBranchName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "constructDefaultBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRepositories";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTaskListener";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIssues";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateIssue";
                break;
            }
            case 9: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLocalTask";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "activateTask";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shelveChanges";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadRepositories";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIssuesFromRepositories";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyClosed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedTask";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "trackContext";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "decorateChangeList";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createChangeList";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "suggestBranchName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "constructDefaultBranchName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class TestConnectionTask
    extends Task.Modal {
        protected Exception myException;
        @Nullable
        protected TaskRepository.CancellableConnection myConnection;

        TestConnectionTask(String title) {
            super(TaskManagerImpl.this.myProject, title, true);
        }

        @Override
        public void onCancel() {
            if (this.myConnection != null) {
                this.myConnection.cancel();
            }
        }
    }

    public static class Config {
        @Property(surroundWithTag=false)
        @XCollection(elementName="task")
        public List<LocalTaskImpl> tasks = new ArrayList<LocalTaskImpl>();
        public int localTasksCounter = 1;
        public int taskHistoryLength = 50;
        public boolean updateEnabled = true;
        public int updateInterval = 20;
        public int updateIssuesCount = 100;
        public boolean clearContext = true;
        public boolean createChangelist = true;
        public boolean createBranch = true;
        public boolean useBranch = false;
        public boolean shelveChanges = false;
        public boolean commitChanges = true;
        public boolean mergeBranch = true;
        public boolean saveContextOnCommit = true;
        public boolean trackContextForNewChangelist = false;
        public String changelistNameFormat = "${id} ${summary}";
        public String branchNameFormat = "${id}";
        public boolean searchClosedTasks = false;
        @Tag(value="servers")
        public Element servers = new Element("servers");
    }
}

