/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.JBTerminalSchemeColorPalette;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalSettingsListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import com.jediterm.terminal.ui.settings.DefaultTabbedSettingsProvider;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalSystemSettingsProviderBase
extends DefaultTabbedSettingsProvider
implements Disposable {
    private final MyColorsSchemeDelegate myColorsScheme;
    private JBTerminalSchemeColorPalette myColorPalette;
    private final Set<TerminalSettingsListener> myListeners = new HashSet<TerminalSettingsListener>();

    public JBTerminalSystemSettingsProviderBase() {
        this.myColorsScheme = JBTerminalSystemSettingsProviderBase.createBoundColorSchemeDelegate();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(this);
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            int newSize;
            int oldSize = this.myColorsScheme.getConsoleFontSize();
            if (oldSize != (newSize = this.myColorsScheme.detectConsoleFontSize())) {
                this.myColorsScheme.setConsoleFontSize(newSize);
                this.fireFontChanged();
            }
        });
        connection.subscribe(EditorColorsManager.TOPIC, new EditorColorsListener(){

            @Override
            public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
                JBTerminalSystemSettingsProviderBase.this.myColorsScheme.updateGlobalScheme(scheme);
                JBTerminalSystemSettingsProviderBase.this.myColorsScheme.setConsoleFontSize(JBTerminalSystemSettingsProviderBase.this.myColorsScheme.detectConsoleFontSize());
                JBTerminalSystemSettingsProviderBase.this.myColorPalette = null;
                JBTerminalSystemSettingsProviderBase.this.fireFontChanged();
            }
        });
    }

    @NotNull
    public TerminalActionPresentation getNewSessionActionPresentation() {
        TerminalActionPresentation presentation = super.getNewSessionActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.NewSession.text", new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getOpenUrlActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.OpenAsUrl.text", new Object[0]), Collections.emptyList());
    }

    @NotNull
    public TerminalActionPresentation getCopyActionPresentation() {
        return new TerminalActionPresentation(UIUtil.removeMnemonic(ActionsBundle.message("action.$Copy.text", new Object[0])), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("$Copy"));
    }

    @NotNull
    public TerminalActionPresentation getPasteActionPresentation() {
        return new TerminalActionPresentation(UIUtil.removeMnemonic(ActionsBundle.message("action.$Paste.text", new Object[0])), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("$Paste"));
    }

    @NotNull
    public TerminalActionPresentation getClearBufferActionPresentation() {
        TerminalActionPresentation presentation = super.getClearBufferActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.ClearBuffer.text", new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getPageUpActionPresentation() {
        TerminalActionPresentation presentation = super.getPageUpActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.PageUp.text", new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getPageDownActionPresentation() {
        TerminalActionPresentation presentation = super.getPageDownActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.PageDown.text", new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getLineUpActionPresentation() {
        TerminalActionPresentation presentation = super.getLineUpActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.LineUp.text", new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getLineDownActionPresentation() {
        TerminalActionPresentation presentation = super.getLineDownActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.LineDown.text", new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getCloseSessionActionPresentation() {
        TerminalActionPresentation presentation = super.getCloseSessionActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.CloseSession.text", new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getFindActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.Find.text", new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Find"));
    }

    @NotNull
    public ColorPalette getTerminalColorPalette() {
        JBTerminalSchemeColorPalette colorPalette = this.myColorPalette;
        if (colorPalette == null) {
            this.myColorPalette = colorPalette = new JBTerminalSchemeColorPalette(this.myColorsScheme);
        }
        JBTerminalSchemeColorPalette jBTerminalSchemeColorPalette = colorPalette;
        if (jBTerminalSchemeColorPalette == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(0);
        }
        return jBTerminalSchemeColorPalette;
    }

    @NotNull
    public static String getGotoNextSplitTerminalActionText(boolean forward) {
        String string = forward ? ActionsBundle.message("action.NextSplitter.text", new Object[0]) : ActionsBundle.message("action.PrevSplitter.text", new Object[0]);
        if (string == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public TerminalAction getGotoNextSplitTerminalAction(@Nullable JBTerminalWidgetListener listener2, boolean forward) {
        String actionId = forward ? "Terminal.NextSplitter" : "Terminal.PrevSplitter";
        String text2 = UIUtil.removeMnemonic(JBTerminalSystemSettingsProviderBase.getGotoNextSplitTerminalActionText(forward));
        return new TerminalAction(new TerminalActionPresentation(text2, JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId(actionId)), event -> {
            if (listener2 != null) {
                listener2.gotoNextSplitTerminal(forward);
            }
            return true;
        });
    }

    @NotNull
    private static List<KeyStroke> getKeyStrokesByActionId(@NotNull String actionId) {
        Shortcut[] shortcuts;
        if (actionId == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(2);
        }
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        for (Shortcut sc : shortcuts = KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()) {
            if (!(sc instanceof KeyboardShortcut)) continue;
            KeyStroke ks = ((KeyboardShortcut)sc).getFirstKeyStroke();
            keyStrokes.add(ks);
        }
        ArrayList<KeyStroke> arrayList = keyStrokes;
        if (arrayList == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public void dispose() {
    }

    public void addListener(TerminalSettingsListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(TerminalSettingsListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void fireFontChanged() {
        for (TerminalSettingsListener l : this.myListeners) {
            l.fontChanged();
        }
    }

    @NotNull
    public TerminalActionPresentation getNextTabActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.SelectNextTab.text", new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("NextTab"));
    }

    @NotNull
    public TerminalActionPresentation getPreviousTabActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.SelectPreviousTab.text", new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("PreviousTab"));
    }

    @NotNull
    public TerminalActionPresentation getMoveTabRightActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.MoveRight.text", new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.MoveToolWindowTabRight"));
    }

    @NotNull
    public TerminalActionPresentation getMoveTabLeftActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.MoveLeft.text", new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.MoveToolWindowTabLeft"));
    }

    @NotNull
    public TerminalActionPresentation getShowTabsActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message("terminal.action.ShowTabs.text", new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("ShowContent"));
    }

    @NotNull
    private static MyColorsSchemeDelegate createBoundColorSchemeDelegate() {
        return new MyColorsSchemeDelegate();
    }

    @NotNull
    MyColorsSchemeDelegate getColorsScheme() {
        MyColorsSchemeDelegate myColorsSchemeDelegate = this.myColorsScheme;
        if (myColorsSchemeDelegate == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(4);
        }
        return myColorsSchemeDelegate;
    }

    public float getLineSpace() {
        return this.myColorsScheme.getConsoleLineSpacing();
    }

    public TextStyle getSelectionColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorsScheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR)), TerminalColor.awt((Color)this.myColorsScheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR)));
    }

    public TextStyle getFoundPatternColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorsScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getForegroundColor()), TerminalColor.awt((Color)this.myColorsScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getBackgroundColor()));
    }

    public TextStyle getHyperlinkColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorsScheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor()), TerminalColor.awt((Color)this.myColorsScheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getBackgroundColor()));
    }

    public TextStyle getDefaultStyle() {
        return new TextStyle(TerminalColor.index((int)JBTerminalSchemeColorPalette.getDefaultForegroundIndex()), TerminalColor.index((int)JBTerminalSchemeColorPalette.getDefaultBackgroundIndex()));
    }

    public Font getTerminalFont() {
        return new Font(this.getFontName(), 0, (int)this.getTerminalFontSize());
    }

    public String getFontName() {
        List<String> fonts = this.myColorsScheme.getConsoleFontPreferences().getEffectiveFontFamilies();
        if (fonts.size() > 0) {
            return fonts.get(0);
        }
        return "Monospaced-14";
    }

    public float getTerminalFontSize() {
        return this.myColorsScheme.getConsoleFontSize();
    }

    public boolean useAntialiasing() {
        return true;
    }

    public int caretBlinkingMs() {
        if (!EditorSettingsExternalizable.getInstance().isBlinkCaret()) {
            return 0;
        }
        return EditorSettingsExternalizable.getInstance().getBlinkPeriod();
    }

    public int getBufferMaxLinesCount() {
        int linesCount = Registry.get("terminal.buffer.max.lines.count").asInteger();
        if (linesCount > 0) {
            return linesCount;
        }
        return super.getBufferMaxLinesCount();
    }

    public boolean overrideIdeShortcuts() {
        return false;
    }

    public boolean useInverseSelectionColor() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/JBTerminalSystemSettingsProviderBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalColorPalette";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoNextSplitTerminalActionText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/JBTerminalSystemSettingsProviderBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokesByActionId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokesByActionId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyColorsSchemeDelegate
    implements EditorColorsScheme {
        private final FontPreferencesImpl myFontPreferences = new FontPreferencesImpl();
        private final HashMap<TextAttributesKey, TextAttributes> myOwnAttributes = new HashMap();
        private final HashMap<ColorKey, Color> myOwnColors = new HashMap();
        private Map<EditorFontType, Font> myFontsMap = null;
        private String myFaceName = null;
        private EditorColorsScheme myGlobalScheme;
        private int myConsoleFontSize;

        private MyColorsSchemeDelegate() {
            this.updateGlobalScheme(null);
            this.myConsoleFontSize = this.detectConsoleFontSize();
            this.initFonts();
        }

        @NotNull
        private EditorColorsScheme getGlobal() {
            EditorColorsScheme editorColorsScheme = this.myGlobalScheme;
            if (editorColorsScheme == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(0);
            }
            return editorColorsScheme;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.getGlobal().getName();
            if (string == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(1);
            }
            return string;
        }

        private void initFonts() {
            String consoleFontName = this.getConsoleFontName();
            int consoleFontSize = this.getConsoleFontSize();
            this.myFontPreferences.clear();
            this.myFontPreferences.register(consoleFontName, consoleFontSize);
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            Font plainFont = new Font(consoleFontName, 0, consoleFontSize);
            Font boldFont = new Font(consoleFontName, 1, consoleFontSize);
            Font italicFont = new Font(consoleFontName, 2, consoleFontSize);
            Font boldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
            this.myFontsMap.put(EditorFontType.PLAIN, plainFont);
            this.myFontsMap.put(EditorFontType.BOLD, boldFont);
            this.myFontsMap.put(EditorFontType.ITALIC, italicFont);
            this.myFontsMap.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        }

        @Override
        public void setName(String name) {
            this.getGlobal().setName(name);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.getGlobal().getDisplayName();
            if (string == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public TextAttributes getAttributes(TextAttributesKey key) {
            if (this.myOwnAttributes.containsKey(key)) {
                return this.myOwnAttributes.get(key);
            }
            return this.getGlobal().getAttributes(key);
        }

        @Override
        public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
            if (key == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(3);
            }
            this.myOwnAttributes.put(key, attributes);
        }

        @Override
        @NotNull
        public Color getDefaultBackground() {
            Color color = this.getGlobal().getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
            Color color2 = color != null ? color : this.getGlobal().getDefaultBackground();
            if (color2 == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(4);
            }
            return color2;
        }

        @Override
        @NotNull
        public Color getDefaultForeground() {
            Color foregroundColor = this.getGlobal().getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY).getForegroundColor();
            Color color = foregroundColor != null ? foregroundColor : this.getGlobal().getDefaultForeground();
            if (color == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(5);
            }
            return color;
        }

        @Override
        public Color getColor(ColorKey key) {
            if (this.myOwnColors.containsKey(key)) {
                return this.myOwnColors.get(key);
            }
            return this.getGlobal().getColor(key);
        }

        @Override
        public void setColor(ColorKey key, Color color) {
            this.myOwnColors.put(key, color);
        }

        @Override
        @NotNull
        public FontPreferences getFontPreferences() {
            FontPreferences fontPreferences = this.myGlobalScheme.getFontPreferences();
            if (fontPreferences == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(6);
            }
            return fontPreferences;
        }

        @Override
        public void setFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(7);
            }
            throw new IllegalStateException();
        }

        @Override
        public int getEditorFontSize() {
            return this.getGlobal().getEditorFontSize();
        }

        @Override
        public void setEditorFontSize(int fontSize) {
        }

        @Override
        public String getEditorFontName() {
            return this.getGlobal().getEditorFontName();
        }

        @Override
        public void setEditorFontName(String fontName) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Font getFont(EditorFontType key) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get((Object)key)) != null) {
                Font font2 = font;
                if (font2 == null) {
                    MyColorsSchemeDelegate.$$$reportNull$$$0(8);
                }
                return font2;
            }
            Font font3 = this.getGlobal().getFont(key);
            if (font3 == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(9);
            }
            return font3;
        }

        @Override
        public void setFont(EditorFontType key, Font font) {
            if (this.myFontsMap == null) {
                this.initFonts();
            }
            this.myFontsMap.put(key, font);
        }

        @Override
        public float getLineSpacing() {
            return this.getGlobal().getLineSpacing();
        }

        @Override
        public void setLineSpacing(float lineSpacing) {
            this.getGlobal().setLineSpacing(lineSpacing);
        }

        @Override
        @Nullable
        public Object clone() {
            return null;
        }

        @Override
        public void readExternal(Element element2) {
        }

        private void updateGlobalScheme(@Nullable EditorColorsScheme scheme) {
            this.myFontsMap = null;
            this.myGlobalScheme = scheme != null ? scheme : EditorColorsManager.getInstance().getGlobalScheme();
        }

        @Override
        @NotNull
        public FontPreferences getConsoleFontPreferences() {
            FontPreferencesImpl fontPreferencesImpl = this.myFontPreferences;
            if (fontPreferencesImpl == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(10);
            }
            return fontPreferencesImpl;
        }

        @Override
        public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(11);
            }
            preferences.copyTo(this.myFontPreferences);
            this.initFonts();
        }

        @Override
        public String getConsoleFontName() {
            if (this.myFaceName == null) {
                return this.getGlobal().getConsoleFontName();
            }
            return this.myFaceName;
        }

        @Override
        public void setConsoleFontName(String fontName) {
            this.myFaceName = fontName;
            this.initFonts();
        }

        private int detectConsoleFontSize() {
            if (UISettings.getInstance().getPresentationMode()) {
                return UISettings.getInstance().getPresentationModeFontSize();
            }
            return this.getGlobal().getConsoleFontSize();
        }

        @Override
        public int getConsoleFontSize() {
            return this.myConsoleFontSize;
        }

        @Override
        public void setConsoleFontSize(int fontSize) {
            this.myConsoleFontSize = fontSize;
            this.initFonts();
        }

        @Override
        public float getConsoleLineSpacing() {
            return this.getGlobal().getConsoleLineSpacing();
        }

        @Override
        public void setConsoleLineSpacing(float lineSpacing) {
            this.getGlobal().setConsoleLineSpacing(lineSpacing);
        }

        @Override
        @NotNull
        public Properties getMetaProperties() {
            Properties properties = this.myGlobalScheme.getMetaProperties();
            if (properties == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(12);
            }
            return properties;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorsSchemeDelegate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGlobal";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorsSchemeDelegate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultBackground";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultForeground";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFontPreferences";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFont";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConsoleFontPreferences";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setAttributes";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setFontPreferences";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setConsoleFontPreferences";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

