/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class TerminalConsoleContentHelper
implements Disposable {
    private static final int FLUSH_TIMEOUT = 200;
    private final Collection<ObservableConsoleView.ChangeListener> myChangeListeners;
    private final Set<ConsoleViewContentType> myContentTypes;
    private final Alarm myAlarm;
    private final AtomicBoolean myRequested;
    private volatile boolean myDisposed;

    TerminalConsoleContentHelper(@NotNull TerminalExecutionConsole console) {
        if (console == null) {
            TerminalConsoleContentHelper.$$$reportNull$$$0(0);
        }
        this.myChangeListeners = new CopyOnWriteArraySet<ObservableConsoleView.ChangeListener>();
        this.myContentTypes = ContainerUtil.newConcurrentSet();
        this.myRequested = new AtomicBoolean(false);
        this.myDisposed = false;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        Disposer.register(console, this);
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            TerminalConsoleContentHelper.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            TerminalConsoleContentHelper.$$$reportNull$$$0(2);
        }
        this.myChangeListeners.add(listener2);
        Disposer.register(parent, () -> this.myChangeListeners.remove(listener2));
    }

    public void onContentTypePrinted(@NotNull ConsoleViewContentType contentType) {
        if (contentType == null) {
            TerminalConsoleContentHelper.$$$reportNull$$$0(3);
        }
        this.myContentTypes.add(contentType);
        if (this.myRequested.compareAndSet(false, true) && !this.myDisposed) {
            this.myAlarm.addRequest(this::flush, 200);
        }
    }

    private void flush() {
        if (this.myDisposed) {
            return;
        }
        this.myRequested.set(false);
        ArrayList<ConsoleViewContentType> contentTypes = new ArrayList<ConsoleViewContentType>(this.myContentTypes);
        this.myContentTypes.removeAll(contentTypes);
        if (!contentTypes.isEmpty()) {
            this.fireContentAdded(contentTypes);
        }
    }

    private void fireContentAdded(@NotNull List<ConsoleViewContentType> contentTypes) {
        if (contentTypes == null) {
            TerminalConsoleContentHelper.$$$reportNull$$$0(4);
        }
        for (ObservableConsoleView.ChangeListener listener2 : this.myChangeListeners) {
            listener2.contentAdded(contentTypes);
        }
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
        this.myAlarm.cancelAllRequests();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTypes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/terminal/TerminalConsoleContentHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onContentTypePrinted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fireContentAdded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

