/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TObjectLongHashMap;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class CpuUsageData {
    private static final ThreadMXBean ourThreadMXBean = ManagementFactory.getThreadMXBean();
    private static final List<GarbageCollectorMXBean> ourGcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private static final CompilationMXBean ourCompilationMXBean = ManagementFactory.getCompilationMXBean();
    public final long durationMs;
    private final FreeMemorySnapshot myMemStart;
    private final FreeMemorySnapshot myMemEnd;
    private final long myCompilationTime;
    private final List<Pair<Long, String>> myGcTimes = new ArrayList<Pair<Long, String>>();
    private final List<Pair<Long, String>> myThreadTimes = new ArrayList<Pair<Long, String>>();

    private CpuUsageData(long durationMs, TObjectLongHashMap<GarbageCollectorMXBean> gcTimes, TLongLongHashMap threadTimes, long compilationTime, FreeMemorySnapshot memStart, FreeMemorySnapshot memEnd) {
        this.durationMs = durationMs;
        this.myMemStart = memStart;
        this.myMemEnd = memEnd;
        this.myCompilationTime = compilationTime;
        gcTimes.forEachEntry((bean, gcTime) -> {
            this.myGcTimes.add(Pair.create(gcTime, bean.getName()));
            return true;
        });
        threadTimes.forEachEntry((id2, time) -> {
            ThreadInfo info = ourThreadMXBean.getThreadInfo(id2);
            this.myThreadTimes.add(Pair.create(CpuUsageData.toMillis(time), info == null ? "<unknown>" : info.getThreadName()));
            return true;
        });
    }

    public String getGcStats() {
        return CpuUsageData.printLongestNames(this.myGcTimes) + "; free " + this.myMemStart + " -> " + this.myMemEnd + " MB";
    }

    public String getThreadStats() {
        return CpuUsageData.printLongestNames(this.myThreadTimes);
    }

    public String getSummary(String indent) {
        return indent + "GC: " + this.getGcStats() + "\n" + indent + "Threads: " + this.getThreadStats() + "\n" + indent + "JIT: " + this.myCompilationTime + "ms";
    }

    boolean hasAnyActivityBesides(Thread thread) {
        return this.myCompilationTime > 0L || this.myThreadTimes.stream().anyMatch(pair -> (Long)pair.first > 0L && !((String)pair.second).equals(thread.getName())) || this.myGcTimes.stream().anyMatch(pair -> (Long)pair.first > 0L);
    }

    @NotNull
    private static String printLongestNames(List<Pair<Long, String>> times) {
        String stats = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(times).sortedBy(p -> -((Long)p.first).longValue())).filter(p -> (Long)p.first > 10L)).limit(10L)).map(p -> "\"" + (String)p.second + "\" took " + p.first + "ms").joining((CharSequence)", ");
        String string = stats.isEmpty() ? "insignificant" : stats;
        if (string == null) {
            CpuUsageData.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static long toMillis(long timeNs) {
        return timeNs / 1000000L;
    }

    public static <E extends Throwable> CpuUsageData measureCpuUsage(ThrowableRunnable<E> runnable2) throws E {
        FreeMemorySnapshot memStart = new FreeMemorySnapshot();
        TObjectLongHashMap<GarbageCollectorMXBean> gcTimes = new TObjectLongHashMap<GarbageCollectorMXBean>();
        for (GarbageCollectorMXBean garbageCollectorMXBean : ourGcBeans) {
            gcTimes.put(garbageCollectorMXBean, garbageCollectorMXBean.getCollectionTime());
        }
        TLongLongHashMap threadTimes = new TLongLongHashMap();
        for (long id2 : ourThreadMXBean.getAllThreadIds()) {
            threadTimes.put(id2, ourThreadMXBean.getThreadUserTime(id2));
        }
        long l = ourCompilationMXBean.getTotalCompilationTime();
        long start2 = System.nanoTime();
        runnable2.run();
        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2);
        long compTime = ourCompilationMXBean.getTotalCompilationTime() - l;
        FreeMemorySnapshot memEnd = new FreeMemorySnapshot();
        for (long id3 : ourThreadMXBean.getAllThreadIds()) {
            threadTimes.put(id3, ourThreadMXBean.getThreadUserTime(id3) - threadTimes.get(id3));
        }
        Object object = ourGcBeans.iterator();
        while (object.hasNext()) {
            GarbageCollectorMXBean bean = (GarbageCollectorMXBean)object.next();
            gcTimes.put(bean, bean.getCollectionTime() - gcTimes.get(bean));
        }
        return new CpuUsageData(duration, gcTimes, threadTimes, compTime, memStart, memEnd);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/CpuUsageData", "printLongestNames"));
    }

    private static class FreeMemorySnapshot {
        final long free = FreeMemorySnapshot.toMb(Runtime.getRuntime().freeMemory());
        final long total = FreeMemorySnapshot.toMb(Runtime.getRuntime().totalMemory());

        private FreeMemorySnapshot() {
        }

        private static long toMb(long bytes) {
            return bytes / 1024L / 1024L;
        }

        public String toString() {
            return this.free + "/" + this.total;
        }
    }
}

