/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public final class EditorListenerTracker {
    private final Map<Class<? extends EventListener>, List<? extends EventListener>> before;

    public EditorListenerTracker() {
        EncodingManager.getInstance();
        this.before = ((EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster()).getListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkListenersLeak() throws AssertionError {
        try {
            Class<? extends EventListener> aClass;
            EditorEventMulticasterImpl multicaster = (EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster();
            Map<Class<? extends EventListener>, List<? extends EventListener>> after2 = multicaster.getListeners();
            LinkedHashMap leaked = new LinkedHashMap();
            for (Map.Entry<Class<? extends EventListener>, List<? extends EventListener>> entry : after2.entrySet()) {
                aClass = entry.getKey();
                List<? extends EventListener> beforeList = this.before.get(aClass);
                ArrayList<EventListener> afterList = new ArrayList<EventListener>((Collection)entry.getValue());
                if (beforeList != null) {
                    afterList.removeAll(beforeList);
                }
                afterList.removeIf(listener2 -> {
                    if (listener2 instanceof PsiDocumentManager && ((PsiDocumentManagerBase)listener2).isDefaultProject()) {
                        return true;
                    }
                    String name = listener2.getClass().getName();
                    return name.startsWith("com.intellij.copyright.CopyrightManagerDocumentListener$") || name.startsWith("com.jetbrains.liveEdit.highlighting.ElementHighlighterCaretListener");
                });
                if (afterList.isEmpty()) continue;
                leaked.put(aClass, afterList);
            }
            for (Map.Entry<Class<EventListener>, List<EventListener>> entry : leaked.entrySet()) {
                aClass = entry.getKey();
                List<EventListener> list2 = entry.getValue();
                Assert.fail((String)("Listeners leaked for " + aClass + ":\n" + list2));
            }
        }
        finally {
            this.before.clear();
        }
    }
}

