/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.ProjectRule;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TempFiles;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeavyPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static TestApplicationManager ourTestAppManager;
    private static boolean ourReportedLeakedProjects;
    protected Project myProject;
    protected Module myModule;
    protected final Collection<File> myFilesToDelete = new THashSet<File>();
    private final TempFiles myTempFiles = new TempFiles(this.myFilesToDelete);
    protected boolean myAssertionsInTestDetected;
    public static Thread ourTestThread;
    private static TestCase ourTestCase;
    private static final long DEFAULT_TEST_TIME = 300L;
    public static long ourTestTime;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private static boolean ourPlatformPrefixInitialized;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private SdkLeakTracker myOldSdks;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    @Nullable
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private static final String[] PREFIX_CANDIDATES;

    @NotNull
    public TempFiles getTempDir() {
        TempFiles tempFiles = this.myTempFiles;
        if (tempFiles == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(0);
        }
        return tempFiles;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure() throws IOException {
        VirtualFile virtualFile2 = PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, this.myFilesToDelete);
        if (virtualFile2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(1);
        }
        return virtualFile2;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure(String rootPath) throws Exception {
        VirtualFile virtualFile2 = PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, rootPath, this.myFilesToDelete);
        if (virtualFile2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(2);
        }
        return virtualFile2;
    }

    public static void synchronizeTempDirVfs(@NotNull VirtualFile tempDir) {
        if (tempDir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(3);
        }
        tempDir.getChildren();
        tempDir.refresh(false, true);
    }

    public static void synchronizeTempDirVfs(@NotNull Path tempDir) {
        VirtualFile virtualFile2;
        if (tempDir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(4);
        }
        if ((virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName(tempDir.toString()))) != null) {
            HeavyPlatformTestCase.synchronizeTempDirVfs(Objects.requireNonNull(virtualFile2));
        }
    }

    protected void initApplication() throws Exception {
        boolean firstTime = ourTestAppManager == null;
        ourTestAppManager = TestApplicationManager.getInstance();
        ourTestAppManager.setDataProvider(this);
        if (firstTime) {
            HeavyPlatformTestCase.cleanPersistedVFSContent();
        }
        this.myOldSdks = new SdkLeakTracker();
    }

    public static void doAutodetectPlatformPrefix() {
        if (ourPlatformPrefixInitialized) {
            return;
        }
        if (System.getProperty("idea.platform.prefix") != null) {
            ourPlatformPrefixInitialized = true;
            return;
        }
        for (String candidate : PREFIX_CANDIDATES) {
            String markerPath = candidate == null ? "idea/ApplicationInfo.xml" : "META-INF/" + candidate + "Plugin.xml";
            URL resource = HeavyPlatformTestCase.class.getClassLoader().getResource(markerPath);
            if (resource == null) continue;
            if (candidate == null) break;
            HeavyPlatformTestCase.setPlatformPrefix(candidate);
            break;
        }
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File tempDir = new File(FileUtilRt.getTempDirectory());
        this.myFilesToDelete.add(tempDir);
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            HeavyPlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.debug(this.getClass().getName() + ".setUp()");
        this.initApplication();
        if (this.myOldSdks == null) {
            this.myOldSdks = new SdkLeakTracker();
        }
        this.setUpProject();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        boolean isTrackCodeStyleChanges = !this.isStressTest() && ApplicationManager.getApplication() != null && !(ApplicationManager.getApplication() instanceof MockApplication);
        this.myCodeStyleSettingsTracker = isTrackCodeStyleChanges ? new CodeStyleSettingsTracker(() -> CodeStyle.getDefaultSettings()) : null;
        ourTestCase = this;
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
            CodeStyle.setTemporarySettings(this.myProject, new CodeStyleSettings());
            InjectedLanguageManagerImpl.pushInjectors(this.myProject);
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject)).clearUncommittedDocuments();
        }
        UIUtil.dispatchAllInvocationEvents();
        this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final PsiManager getPsiManager() {
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        if (psiManager == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(5);
        }
        return psiManager;
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProject = this.doCreateProject(this.getProjectDirOrFile());
        ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
        LocalFileSystem.getInstance().refreshIoFiles(this.myFilesToDelete);
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx(this.myProject).mergeRootsChangesDuring(() -> {
            this.setUpModule();
            this.setUpJdk();
        }));
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        this.runStartupActivities();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    @NotNull
    protected Project doCreateProject(@NotNull Path projectFile) throws Exception {
        if (projectFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(6);
        }
        return HeavyPlatformTestCase.createProject(projectFile);
    }

    @NotNull
    public static Project createProject(@NotNull Path file2) {
        Project project2;
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(7);
        }
        try {
            ProjectManagerImpl projectManager = (ProjectManagerImpl)ProjectManager.getInstance();
            OpenProjectTask options = new OpenProjectTask();
            options.useDefaultProjectAsTemplate = false;
            options.isRefreshVfsNeeded = false;
            project2 = Objects.requireNonNull(projectManager.newProject(file2, null, options));
        }
        catch (TooManyProjectLeakedException e) {
            if (ourReportedLeakedProjects) {
                HeavyPlatformTestCase.fail((String)"Too many projects leaked, again.");
                if (null == null) {
                    HeavyPlatformTestCase.$$$reportNull$$$0(9);
                }
                return null;
            }
            ourReportedLeakedProjects = true;
            HeavyPlatformTestCase.reportLeakedProjects(e);
            if (null == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(10);
            }
            return null;
        }
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(8);
        }
        return project2;
    }

    @NotNull
    public static String publishHeapDump(@NotNull String fileNamePrefix) {
        if (fileNamePrefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(11);
        }
        String fileName = fileNamePrefix + ".hprof.zip";
        File dumpFile = new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), fileName);
        try {
            FileUtil.delete(dumpFile);
            MemoryDumpHelper.captureMemoryDumpZipped(dumpFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String dumpPath = dumpFile.getAbsolutePath();
        System.out.println("##teamcity[publishArtifacts '" + dumpPath + "']");
        String string = dumpPath;
        if (string == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Contract(value="_ -> fail")
    public static void reportLeakedProjects(@NotNull TooManyProjectLeakedException e) {
        if (e == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(13);
        }
        TIntHashSet hashCodes = new TIntHashSet();
        for (Project project2 : e.getLeakedProjects()) {
            hashCodes.add(System.identityHashCode(project2));
        }
        String dumpPath = HeavyPlatformTestCase.publishHeapDump("leakedProjects");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Too many projects leaked: \n");
        LeakHunter.processLeaks(LeakHunter.allRoots(), ProjectImpl.class, p -> hashCodes.contains(System.identityHashCode(p)), (leaked, backLink) -> {
            int hashCode = System.identityHashCode(leaked);
            leakers.append("Leaked project found:").append(leaked).append("; hash: ").append(hashCode).append("; place: ").append(ProjectRule.getCreationPlace(leaked)).append("\n");
            leakers.append(backLink).append("\n");
            leakers.append(";-----\n");
            hashCodes.remove(hashCode);
            return !hashCodes.isEmpty();
        });
        HeavyPlatformTestCase.fail((String)(stringBuilder + "\nPlease see '" + dumpPath + "' for a memory dump"));
    }

    protected void runStartupActivities() {
        StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance(this.myProject);
        startupManager.runStartupActivities();
        startupManager.runPostStartupActivitiesRegisteredDynamically();
    }

    @NotNull
    protected Path getProjectDirOrFile() {
        return this.getProjectDirOrFile(false);
    }

    protected boolean isCreateProjectFileExplicitly() {
        return true;
    }

    @NotNull
    protected final Path getProjectDirOrFile(boolean isDirectoryBasedProject) {
        if (!isDirectoryBasedProject && this.isCreateProjectFileExplicitly()) {
            Path path2;
            try {
                File tempFile = FileUtil.createTempFile(this.getName(), ".ipr");
                this.myFilesToDelete.add(tempFile);
                path2 = tempFile.toPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (path2 == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(14);
            }
            return path2;
        }
        Path tempFile = TemporaryDirectory.generateTemporaryPath(FileUtil.sanitizeFileName(this.getName(), false) + (isDirectoryBasedProject ? "" : ".ipr"));
        this.myFilesToDelete.add(tempFile.toFile());
        Path path3 = tempFile;
        if (path3 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(15);
        }
        return path3;
    }

    protected void setUpModule() {
        try {
            WriteCommandAction.writeCommandAction(this.getProject()).run(() -> {
                this.myModule = this.createMainModule();
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected Module createMainModule() throws IOException {
        Module module2 = this.createModule(this.myProject.getName());
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(16);
        }
        return module2;
    }

    @NotNull
    protected Module createModule(@NonNls @NotNull String moduleName) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(17);
        }
        Module module2 = this.doCreateRealModule(moduleName);
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(18);
        }
        return module2;
    }

    @NotNull
    protected Module doCreateRealModule(@NotNull String moduleName) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(19);
        }
        Module module2 = this.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(20);
        }
        return module2;
    }

    @NotNull
    protected Module doCreateRealModuleIn(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType moduleType) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(21);
        }
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(22);
        }
        if (moduleType == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(23);
        }
        Module module2 = this.createModuleAt(moduleName, project2, moduleType, Objects.requireNonNull(project2.getBasePath()));
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(24);
        }
        return module2;
    }

    @NotNull
    protected Module createModuleAt(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType moduleType, @NotNull String path2) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(25);
        }
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(26);
        }
        if (moduleType == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(27);
        }
        if (path2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(28);
        }
        if (this.isCreateProjectFileExplicitly()) {
            File moduleFile = new File(FileUtil.toSystemDependentName(path2), moduleName + ".iml");
            FileUtil.createIfDoesntExist(moduleFile);
            this.myFilesToDelete.add(moduleFile);
            Module module2 = WriteAction.computeAndWait(() -> {
                VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleFile);
                HeavyPlatformTestCase.assertNotNull((Object)virtualFile2);
                Module module2 = ModuleManager.getInstance(project2).newModule(virtualFile2.getPath(), moduleType.getId());
                module2.getModuleFile();
                return module2;
            });
            if (module2 == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(29);
            }
            return module2;
        }
        ModuleManager moduleManager = ModuleManager.getInstance(project2);
        Module module3 = WriteAction.computeAndWait(() -> moduleManager.newModule(path2 + File.separatorChar + moduleName + ".iml", moduleType.getId()));
        if (module3 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(30);
        }
        return module3;
    }

    @NotNull
    protected ModuleType getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(31);
        }
        return emptyModuleType;
    }

    public static void cleanupApplicationCaches(@Nullable Project project2) {
        LocalFileSystemImpl localFileSystem2;
        FileBasedIndex fileBasedIndex;
        ProjectManagerEx projectManager;
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
        if (globalInstance != null) {
            globalInstance.dropHistoryInTests();
        }
        if (project2 != null && !project2.isDisposed()) {
            ((UndoManagerImpl)UndoManager.getInstance(project2)).dropHistoryInTests();
            ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest();
            ((PsiManagerImpl)PsiManager.getInstance(project2)).cleanupForNextTest();
        }
        if ((projectManager = ProjectManagerEx.getInstanceExIfCreated()) != null && projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiManagerImpl)PsiManager.getInstance(defaultProject)).cleanupForNextTest();
        }
        if ((fileBasedIndex = app.getServiceIfCreated(FileBasedIndex.class)) != null) {
            ((FileBasedIndexImpl)fileBasedIndex).cleanupForNextTest();
        }
        if (app.getServiceIfCreated(VirtualFileManager.class) != null && (localFileSystem2 = (LocalFileSystemImpl)LocalFileSystem.getInstance()) != null) {
            localFileSystem2.cleanupForNextTest();
        }
    }

    @NotNull
    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            Set<VirtualFile> set = ourEternallyLivingFilesCache;
            if (set == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(32);
            }
            return set;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file2 : IndexableSetContributor.getRootsToIndex(contributor)) {
                HeavyPlatformTestCase.registerSurvivor(survivors, file2);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        HashSet<VirtualFile> hashSet = survivors;
        if (hashSet == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    public static void addSurvivingFiles(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(34);
        }
        for (VirtualFile virtualFile2 : files2) {
            HeavyPlatformTestCase.registerSurvivor(HeavyPlatformTestCase.eternallyLivingFiles(), virtualFile2);
        }
    }

    private static void registerSurvivor(@NotNull Set<? super VirtualFile> survivors, @NotNull VirtualFile file2) {
        if (survivors == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(35);
        }
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(36);
        }
        HeavyPlatformTestCase.addSubTree(file2, survivors);
        while (file2 != null && survivors.add(file2)) {
            file2 = file2.getParent();
        }
    }

    private static void addSubTree(@NotNull VirtualFile root, @NotNull Set<? super VirtualFile> to) {
        if (root == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(37);
        }
        if (to == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(38);
        }
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child2 : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child2 instanceof VirtualDirectoryImpl)) continue;
                to.add(child2);
                HeavyPlatformTestCase.addSubTree(child2, to);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.myProject;
        if (project2 != null && !project2.isDisposed()) {
            TestApplicationManagerKt.waitForProjectLeakingThreads(project2);
        }
        RunAll.runAll(() -> this.disposeRootDisposable(), () -> {
            if (this.myProject != null) {
                LightPlatformTestCase.doTearDown(this.myProject, ourTestAppManager);
                this.myProject = null;
            }
        }, () -> {
            if (this.myProject != null) {
                HeavyPlatformTestCase.closeAndDisposeProjectAndCheckThatNoOpenProjects(this.myProject);
                this.myProject = null;
            }
        }, () -> UIUtil.dispatchAllInvocationEvents(), () -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project2);
            }
        }, () -> {
            StartMarkAction.checkCleared(project2);
            InplaceRefactoring.checkCleared();
        }, () -> {
            JarFileSystemImpl.cleanupForNextTest();
            this.getTempDir().deleteAll();
            LocalFileSystem.getInstance().refreshIoFiles(this.myFilesToDelete);
            LaterInvocator.dispatchPendingFlushes();
        }, () -> {
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }, () -> super.tearDown(), () -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }, () -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> this.myOldSdks.checkForJdkTableLeaks(), () -> this.myVirtualFilePointerTracker.assertPointersAreDisposed(), () -> {
            this.myModule = null;
            this.myFilesToDelete.clear();
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
        });
    }

    public static void closeAndDisposeProjectAndCheckThatNoOpenProjects(@NotNull Project projectToClose) {
        if (projectToClose == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(39);
        }
        ProjectManagerEx.getInstanceEx().forceCloseProject(projectToClose);
        ProjectRule.checkThatNoOpenProjects();
    }

    protected void resetAllFields() {
        this.resetClassFields(this.getClass());
    }

    @Override
    @NotNull
    protected final <T extends Disposable> T disposeOnTearDown(@NotNull T disposable2) {
        if (disposable2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(40);
        }
        Disposer.register(this.myProject, disposable2);
        T t = disposable2;
        if (t == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(41);
        }
        return t;
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        if (aClass == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(42);
        }
        try {
            HeavyPlatformTestCase.clearDeclaredFields(this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
        }
        if (aClass == HeavyPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    protected void registerTestProjectJdk(Sdk jdk) {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk existingSdk : jdkTable.getAllJdks()) {
            if (existingSdk != jdk) continue;
            return;
        }
        WriteAction.runAndWait(() -> jdkTable.addJdk(jdk, this.myProject));
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        if (jdk != null) {
            this.registerTestProjectJdk(jdk);
        }
        for (Module module2 : modules = ModuleManager.getInstance(this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk(module2, jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        try {
            this.runBareImpl();
        }
        finally {
            try {
                EdtTestUtil.runInEdtAndWait(() -> {
                    HeavyPlatformTestCase.cleanupApplicationCaches(this.getProject());
                    this.resetAllFields();
                });
            }
            catch (Throwable throwable) {}
        }
    }

    private void runBareImpl() throws Throwable {
        ThrowableRunnable<Throwable> runnable2 = () -> {
            ourTestThread = Thread.currentThread();
            ourTestTime = 300L;
            try {
                try {
                    this.myAssertionsInTestDetected = true;
                    this.setUp();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable e) {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw e;
                }
                Throwable exception = null;
                try {
                    this.myAssertionsInTestDetected = true;
                    this.runTest();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable e) {
                    exception = e;
                }
                finally {
                    block20: {
                        try {
                            this.tearDown();
                        }
                        catch (Throwable e) {
                            if (exception != null) break block20;
                            exception = e;
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
            finally {
                ourTestThread = null;
            }
        };
        this.runBareRunnable(runnable2);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        HeavyPlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable2) throws Throwable {
        if (runnable2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(43);
        }
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait(runnable2);
        } else {
            runnable2.run();
        }
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void invokeTestRunnable(@NotNull Runnable runnable2) throws Exception {
        if (runnable2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(44);
        }
        Ref e = new Ref();
        Runnable runnable1 = () -> {
            try {
                if (ApplicationManager.getApplication().isDispatchThread() && this.isRunInWriteAction()) {
                    ApplicationManager.getApplication().runWriteAction(runnable2);
                } else {
                    runnable2.run();
                }
            }
            catch (Exception e1) {
                e.set(e1);
            }
        };
        if (this.annotatedWith(WrapInCommand.class)) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (!e.isNull()) {
            throw (Exception)e.get();
        }
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(45);
        }
        return this.myProject == null || this.myProject.isDisposed() ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix) throws IOException {
        if (prefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(46);
        }
        File file2 = this.createTempDir(prefix, true);
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(47);
        }
        return file2;
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix, boolean refresh2) throws IOException {
        if (prefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(48);
        }
        File tempDirectory = FileUtilRt.createTempDirectory("idea_test_" + prefix, null, false);
        this.myFilesToDelete.add(tempDirectory);
        if (refresh2) {
            HeavyPlatformTestCase.getVirtualFile(tempDirectory);
        }
        File file2 = tempDirectory;
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(49);
        }
        return file2;
    }

    protected static VirtualFile getVirtualFile(@NotNull File file2) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(50);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }

    @NotNull
    protected File createTempDirectory() throws IOException {
        File file2 = this.createTempDir("");
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(51);
        }
        return file2;
    }

    @NotNull
    protected File createTempDirectory(boolean refresh2) throws IOException {
        File file2 = this.createTempDir("", refresh2);
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(52);
        }
        return file2;
    }

    @NotNull
    protected File createTempFile(@NotNull String name, @Nullable String text2) throws IOException {
        File directory;
        File file2;
        if (name == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(53);
        }
        if (!(file2 = new File(directory = this.createTempDirectory(), name)).createNewFile()) {
            throw new IOException("Can't create " + file2);
        }
        if (text2 != null) {
            FileUtil.writeToFile(file2, text2);
        }
        File file3 = file2;
        if (file3 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(54);
        }
        return file3;
    }

    public static void setContentOnDisk(@NotNull File file2, byte @Nullable [] bom, @NotNull String content2, @NotNull Charset charset) throws IOException {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(55);
        }
        if (content2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(56);
        }
        if (charset == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(57);
        }
        FileOutputStream stream = new FileOutputStream(file2);
        if (bom != null) {
            stream.write(bom);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write(content2);
        }
    }

    @NotNull
    public VirtualFile createTempFile(@NonNls @NotNull String ext, byte @Nullable [] bom, @NonNls @NotNull String content2, @NotNull Charset charset) throws IOException {
        if (ext == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(58);
        }
        if (content2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(59);
        }
        if (charset == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(60);
        }
        File temp = FileUtil.createTempFile("copy", "." + ext);
        HeavyPlatformTestCase.setContentOnDisk(temp, bom, content2, charset);
        this.myFilesToDelete.add(temp);
        VirtualFile file2 = HeavyPlatformTestCase.getVirtualFile(temp);
        assert (file2 != null) : temp;
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(61);
        }
        return virtualFile2;
    }

    @Nullable
    protected PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(62);
        }
        return PsiDocumentManager.getInstance(this.getProject()).getPsiFile(document);
    }

    private static void setPlatformPrefix(@NotNull String prefix) {
        if (prefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(63);
        }
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    @NotNull
    protected static VirtualFile createChildData(@NotNull VirtualFile dir, @NotNull @NonNls String name) {
        VirtualFile virtualFile2;
        if (dir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(64);
        }
        if (name == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(65);
        }
        try {
            virtualFile2 = WriteAction.computeAndWait(() -> dir.createChildData(null, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(66);
        }
        return virtualFile2;
    }

    @NotNull
    protected static VirtualFile createChildDirectory(@NotNull VirtualFile dir, @NotNull @NonNls String name) {
        VirtualFile virtualFile2;
        if (dir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(67);
        }
        if (name == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(68);
        }
        try {
            virtualFile2 = WriteAction.computeAndWait(() -> dir.createChildDirectory(null, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(69);
        }
        return virtualFile2;
    }

    protected static void rename(@NotNull VirtualFile vFile1, @NotNull String newName) {
        if (vFile1 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(70);
        }
        if (newName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(71);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.rename(vFile1, newName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void delete(@NotNull VirtualFile vFile1) {
        if (vFile1 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(72);
        }
        VfsTestUtil.deleteFile(vFile1);
    }

    public static void move(@NotNull VirtualFile vFile1, @NotNull VirtualFile newFile) {
        if (vFile1 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(73);
        }
        if (newFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(74);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.move(vFile1, newFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected static VirtualFile copy(@NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(75);
        }
        if (newParent == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(76);
        }
        if (copyName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(77);
        }
        VirtualFile[] copy2 = new VirtualFile[1];
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                copy2[0] = file2.copy(file2, newParent, copyName);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile virtualFile2 = copy2[0];
        if (virtualFile2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(78);
        }
        return virtualFile2;
    }

    public static void copyDirContentsTo(@NotNull VirtualFile vTestRoot, @NotNull VirtualFile toDir) {
        if (vTestRoot == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(79);
        }
        if (toDir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(80);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                for (VirtualFile file2 : vTestRoot.getChildren()) {
                    VfsUtil.copy(file2, file2, toDir);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFileText(@NotNull VirtualFile file2, @NotNull String text2) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(81);
        }
        if (text2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(82);
        }
        try {
            WriteAction.runAndWait(() -> VfsUtil.saveText(file2, text2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content2) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(83);
        }
        if (content2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(84);
        }
        try {
            WriteAction.runAndWait(() -> file2.setBinaryContent(content2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content2, long newModificationStamp, long newTimeStamp, Object object) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(85);
        }
        if (content2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(86);
        }
        try {
            void requestor;
            WriteAction.runAndWait(() -> file2.setBinaryContent(content2, newModificationStamp, newTimeStamp, requestor));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected VirtualFile getOrCreateProjectBaseDir() {
        String basePath = this.myProject.getBasePath();
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByPath(Objects.requireNonNull(basePath));
        if (baseDir == null) {
            try {
                Files.createDirectories(Paths.get(basePath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            VirtualFile virtualFile2 = Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByPath(basePath));
            if (virtualFile2 == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(87);
            }
            return virtualFile2;
        }
        VirtualFile virtualFile3 = baseDir;
        if (virtualFile3 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(88);
        }
        return virtualFile3;
    }

    @NotNull
    protected static VirtualFile getOrCreateModuleDir(@NotNull Module module2) throws IOException {
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(89);
        }
        File moduleDir = new File(PathUtil.getParentPath(module2.getModuleFilePath()));
        FileUtil.ensureExists(moduleDir);
        VirtualFile virtualFile2 = Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir));
        if (virtualFile2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(90);
        }
        return virtualFile2;
    }

    static {
        ourTestTime = 300L;
        PREFIX_CANDIDATES = new String[]{"Rider", "GoLand", "CLion", null, "AppCode", "SwiftTests", "CidrCommonTests", "DataGrip", "Python", "PyCharmCore", "Ruby", "PhpStorm", "UltimateLangXml", "Idea", "PlatformLangXml"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/HeavyPlatformTestCase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 7: 
            case 36: 
            case 50: 
            case 55: 
            case 75: 
            case 81: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNamePrefix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "survivors";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectToClose";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 46: 
            case 48: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 53: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 56: 
            case 59: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 70: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile1";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vTestRoot";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestProjectStructure";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/HeavyPlatformTestCase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "publishHeapDump";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDirOrFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModule";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModuleIn";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleAt";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "eternallyLivingFiles";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "disposeOnTearDown";
                break;
            }
            case 47: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDir";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 54: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectBaseDir";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModuleDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeTempDirVfs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCreateProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "publishHeapDump";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportLeakedProjects";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRealModule";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRealModuleIn";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createModuleAt";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addSurvivingFiles";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerSurvivor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addSubTree";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDisposeProjectAndCheckThatNoOpenProjects";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "disposeOnTearDown";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resetClassFields";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "runBareRunnable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "invokeTestRunnable";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createTempDir";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 53: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setContentOnDisk";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setPlatformPrefix";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "copyDirContentsTo";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "setFileText";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModuleDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

