/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.util.ResourceUtil;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public abstract class IdeResourcesTestCase
extends LightPlatformTestCase {
    public void testFeatureTipsRegistered() {
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        Set<String> ids = registry.getFeatureIds();
        IdeResourcesTestCase.assertNotEmpty(ids);
        TreeSet<String> errors = new TreeSet<String>();
        for (String id2 : ids) {
            FeatureDescriptor descriptor2 = registry.getFeatureDescriptor(id2);
            TipAndTrickBean tip = TipUIUtil.getTip(descriptor2);
            if (tip != null) continue;
            errors.add("<tipAndTrick file=\"" + descriptor2.getTipFileName() + "\" feature-id=\"" + id2 + "\"/>");
        }
        IdeResourcesTestCase.assertEquals((String)("Register the following extensions:\n" + StringUtil.join(errors, "\n")), (int)0, (int)errors.size());
    }

    public void testTipFilesPresent() {
        TreeSet<String> errors = new TreeSet<String>();
        TipAndTrickBean[] tips = TipAndTrickBean.EP_NAME.getExtensions();
        IdeResourcesTestCase.assertNotEmpty(Arrays.asList(tips));
        for (TipAndTrickBean tip : tips) {
            URL url = ResourceUtil.getResource(tip.getPluginDescriptor().getPluginClassLoader(), "/tips/", tip.fileName);
            if (url != null) continue;
            errors.add(tip.fileName);
        }
        IdeResourcesTestCase.assertEquals((String)(tips.length + " tips are checked, the following files are missing:\n" + StringUtil.join(errors, "\n")), (int)0, (int)errors.size());
    }

    public void testTipFilesDuplicates() {
        TreeSet<String> errors = new TreeSet<String>();
        TipAndTrickBean[] tips = TipAndTrickBean.EP_NAME.getExtensions();
        IdeResourcesTestCase.assertNotEmpty(Arrays.asList(tips));
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        for (TipAndTrickBean tip : tips) {
            if (visited.add(tip.fileName)) continue;
            errors.add(tip.fileName);
        }
        IdeResourcesTestCase.assertEquals((String)("The following tip files are registered more than once:\n" + StringUtil.join(errors, "\n")), (int)0, (int)errors.size());
    }
}

