/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.io.CharArrayReader;
import java.io.File;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class InspectionTestUtil {
    private InspectionTestUtil() {
    }

    public static void compareWithExpected(Element expectedDoc, Element doc, boolean checkRange) throws Exception {
        ArrayList<Element> expectedProblems = new ArrayList<Element>(expectedDoc.getChildren("problem"));
        ArrayList<Element> reportedProblems = new ArrayList<Element>(doc.getChildren("problem"));
        Element[] expectedArray = expectedProblems.toArray(new Element[0]);
        ArrayList<String> problems = new ArrayList<String>();
        block0: for (Element expectedProblem : expectedArray) {
            Element[] reportedArrayed;
            for (Element reportedProblem : reportedArrayed = reportedProblems.toArray(new Element[0])) {
                if (!InspectionTestUtil.compareProblemWithExpected(reportedProblem, expectedProblem, checkRange)) continue;
                expectedProblems.remove(expectedProblem);
                reportedProblems.remove(reportedProblem);
                continue block0;
            }
            Document missing = new Document(expectedProblem.clone());
            problems.add("The following haven't been reported as expected: " + JDOMUtil.writeDocument(missing, "\n"));
        }
        for (Element reportedProblem : reportedProblems) {
            Document extra = new Document(reportedProblem.clone());
            problems.add("The following has been unexpectedly reported: " + JDOMUtil.writeDocument(extra, "\n"));
        }
        if (!problems.isEmpty()) {
            Assert.fail((String)String.join((CharSequence)"\n", problems));
        }
    }

    static boolean compareProblemWithExpected(Element reportedProblem, Element expectedProblem, boolean checkRange) throws Exception {
        if (!InspectionTestUtil.compareFiles(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareLines(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareDescriptions(reportedProblem, expectedProblem)) {
            return false;
        }
        return !checkRange || InspectionTestUtil.compareTextRange(reportedProblem, expectedProblem);
    }

    static boolean compareTextRange(Element reportedProblem, Element expectedProblem) {
        Element reportedTextRange = reportedProblem.getChild("entry_point");
        if (reportedTextRange == null) {
            return false;
        }
        Element expectedTextRange = expectedProblem.getChild("entry_point");
        return Comparing.equal(reportedTextRange.getAttributeValue("TYPE"), expectedTextRange.getAttributeValue("TYPE")) && Comparing.equal(reportedTextRange.getAttributeValue("FQNAME"), expectedTextRange.getAttributeValue("FQNAME"));
    }

    static boolean compareDescriptions(Element reportedProblem, Element expectedProblem) throws Exception {
        String reportedDescription;
        String expectedDescription = expectedProblem.getChildText("description");
        if (expectedDescription.equals(reportedDescription = reportedProblem.getChildText("description"))) {
            return true;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new CharArrayReader(expectedDescription.toCharArray()));
        tokenizer.quoteChar(39);
        int idx = 0;
        while (tokenizer.nextToken() != -1) {
            String word;
            if (tokenizer.sval != null) {
                word = tokenizer.sval;
            } else {
                if (tokenizer.ttype != -2) continue;
                word = Double.toString(tokenizer.nval);
            }
            idx = reportedDescription.indexOf(word, idx);
            if (idx == -1) {
                return false;
            }
            idx += word.length();
        }
        return true;
    }

    static boolean compareLines(Element reportedProblem, Element expectedProblem) {
        return Comparing.equal(reportedProblem.getChildText("line"), expectedProblem.getChildText("line"));
    }

    static boolean compareFiles(Element reportedProblem, Element expectedProblem) {
        String reportedFileName = reportedProblem.getChildText("file");
        if (reportedFileName == null) {
            return true;
        }
        File reportedFile = new File(reportedFileName);
        return Comparing.equal(reportedFile.getName(), expectedProblem.getChildText("file"));
    }

    public static void compareToolResults(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, boolean checkRange, @NotNull String testDir) {
        if (context == null) {
            InspectionTestUtil.$$$reportNull$$$0(0);
        }
        if (toolWrapper == null) {
            InspectionTestUtil.$$$reportNull$$$0(1);
        }
        if (testDir == null) {
            InspectionTestUtil.$$$reportNull$$$0(2);
        }
        InspectionTestUtil.compareToolResults(context, checkRange, testDir, Collections.singletonList(toolWrapper));
    }

    static void compareToolResults(@NotNull GlobalInspectionContextImpl context, boolean checkRange, @NotNull String testDir, @NotNull Collection<? extends InspectionToolWrapper> toolWrappers) {
        if (context == null) {
            InspectionTestUtil.$$$reportNull$$$0(3);
        }
        if (testDir == null) {
            InspectionTestUtil.$$$reportNull$$$0(4);
        }
        if (toolWrappers == null) {
            InspectionTestUtil.$$$reportNull$$$0(5);
        }
        Element root = new Element("problems");
        for (InspectionToolWrapper inspectionToolWrapper : toolWrappers) {
            InspectionToolPresentation presentation = context.getPresentation(inspectionToolWrapper);
            presentation.updateContent();
            presentation.exportResults(p -> root.addContent((Element)p), x -> false, x -> false);
        }
        try {
            File file2 = new File(testDir + "/expected.xml");
            InspectionTestUtil.compareWithExpected(JDOMUtil.load(file2), root, checkRange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void runTool(@NotNull InspectionToolWrapper toolWrapper, @NotNull AnalysisScope scope, @NotNull GlobalInspectionContextForTests globalContext) {
        String shortName;
        HighlightDisplayKey key;
        if (toolWrapper == null) {
            InspectionTestUtil.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            InspectionTestUtil.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            InspectionTestUtil.$$$reportNull$$$0(8);
        }
        if ((key = HighlightDisplayKey.find(shortName = toolWrapper.getShortName())) == null) {
            HighlightDisplayKey.register(shortName, toolWrapper.getDisplayName(), toolWrapper.getID());
        }
        globalContext.doInspections(scope);
        do {
            UIUtil.dispatchAllInvocationEvents();
        } while (!globalContext.isFinished());
    }

    @NotNull
    public static <T extends InspectionProfileEntry> List<InspectionProfileEntry> instantiateTools(@NotNull Collection<Class<? extends T>> inspections) {
        if (inspections == null) {
            InspectionTestUtil.$$$reportNull$$$0(9);
        }
        Set<String> classNames = JBIterable.from(inspections).transform(Class::getName).toSet();
        return InspectionTestUtil.instantiateTools(classNames);
    }

    public static <T extends InspectionProfileEntry> T instantiateTool(Class<? extends T> inspection) {
        return (T)InspectionTestUtil.instantiateTools(Collections.singleton(inspection)).get(0);
    }

    @NotNull
    public static List<InspectionProfileEntry> instantiateTools(Set<String> classNames) {
        List<InspectionProfileEntry> tools = JBIterable.of(LocalInspectionEP.LOCAL_INSPECTION, InspectionEP.GLOBAL_INSPECTION).flatten(o -> o.getExtensionList()).filter(o -> classNames.contains(o.implementationClass)).transform(InspectionEP::instantiateTool).toList();
        if (tools.size() != classNames.size()) {
            TreeSet<String> missing = new TreeSet<String>(classNames);
            missing.removeAll(JBIterable.from(tools).transform(o -> o.getClass().getName()).toSet());
            throw new RuntimeException("Unregistered inspections requested: " + missing);
        }
        List<InspectionProfileEntry> list2 = tools;
        if (list2 == null) {
            InspectionTestUtil.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/InspectionTestUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/InspectionTestUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareToolResults";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "instantiateTools";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

