/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.ProjectRule;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeakHunter {
    public static void checkProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project2) -> !project2.isDefault() && !project2.isLight());
    }

    public static void checkNonDefaultProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project2) -> !project2.isDefault());
    }

    public static void checkLeak(@NotNull Object root, @NotNull Class<?> suspectClass) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(0);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(1);
        }
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    public static <T> void checkLeak(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(2);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(3);
        }
        LeakHunter.processLeaks(rootsSupplier, suspectClass, isReallyLeak, (leaked, backLink) -> {
            String place = leaked instanceof Project ? ProjectRule.getCreationPlace((Project)leaked) : "";
            String message = "Found leaked " + leaked.getClass() + ": " + leaked + "; hash: " + System.identityHashCode(leaked) + "; place: " + place + "\n" + backLink;
            System.out.println(message);
            System.out.println(";-----");
            UsefulTestCase.printThreadDump();
            throw new AssertionError((Object)message);
        });
    }

    static <T> void processLeaks(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak, @NotNull PairProcessor<? super T, Object> processor2) throws AssertionError {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(4);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            LeakHunter.$$$reportNull$$$0(6);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorBase.clearCacheForTests();
        Runnable runnable2 = () -> {
            try (AccessToken ignored = ProhibitAWTEvents.start("checking for leaks");){
                DebugReflectionUtil.walkObjects(10000, (Map)rootsSupplier.get(), suspectClass, Conditions.alwaysTrue(), (value2, backLink) -> {
                    Object leaked = value2;
                    if (isReallyLeak == null || isReallyLeak.value(leaked)) {
                        return processor2.process(leaked, backLink);
                    }
                    return true;
                });
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            runnable2.run();
        } else {
            application.runReadAction(runnable2);
        }
    }

    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(7);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(8);
        }
        LeakHunter.checkLeak(() -> Collections.singletonMap(root, "Root object"), suspectClass, isReallyLeak);
    }

    @NotNull
    public static Supplier<Map<Object, String>> allRoots() {
        Supplier<Map<Object, String>> supplier = () -> {
            ClassLoader classLoader = LeakHunter.class.getClassLoader();
            Vector allLoadedClasses = ReflectionUtil.getField(classLoader.getClass(), classLoader, Vector.class, "classes");
            LaterInvocator.purgeExpiredItems();
            IdentityHashMap<Object, String> result2 = new IdentityHashMap<Object, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                result2.put(application, "ApplicationManager.getApplication()");
            }
            result2.put(Disposer.getTree(), "Disposer.getTree()");
            result2.put(IdeEventQueue.getInstance(), "IdeEventQueue.getInstance()");
            result2.put(LaterInvocator.getLaterInvocatorEdtQueue(), "LaterInvocator.getLaterInvocatorEdtQueue()");
            result2.put(LaterInvocator.getLaterInvocatorWtQueue(), "LaterInvocator.getLaterInvocatorWtQueue()");
            result2.put(ThreadTracker.getThreads().values(), "all live threads");
            if (allLoadedClasses != null) {
                result2.put(allLoadedClasses, "all loaded classes statics");
            }
            return result2;
        };
        if (supplier == null) {
            LeakHunter.$$$reportNull$$$0(9);
        }
        return supplier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspectClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsSupplier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LeakHunter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LeakHunter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "allRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkLeak";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processLeaks";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

