/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(String text2) {
        this.doTest(text2, null);
    }

    protected void doTest(String text2, @Nullable String expected) {
        this.doTest(text2, expected, this.createLexer());
    }

    protected void doTest(String text2, @Nullable String expected, @NotNull Lexer lexer) {
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(0);
        }
        String result2 = LexerTestCase.printTokens(text2, 0, lexer);
        if (expected != null) {
            LexerTestCase.assertSameLines(expected, result2);
        } else {
            LexerTestCase.assertSameLinesWithFile(this.getPathToTestDataFile(this.getExpectedFileExtension()), result2);
        }
    }

    @NotNull
    protected String getPathToTestDataFile(String extension) {
        String string = IdeaTestExecutionPolicy.getHomePathWithPolicy() + "/" + this.getDirPath() + "/" + this.getTestName(true) + extension;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected String getExpectedFileExtension() {
        return ".txt";
    }

    protected void checkZeroState(String text2, TokenSet tokenTypes) {
        IElementType type;
        Lexer lexer = this.createLexer();
        lexer.start(text2);
        while ((type = lexer.getTokenType()) != null) {
            if (tokenTypes.contains(type) && lexer.getState() != 0) {
                LexerTestCase.fail((String)("Non-zero lexer state on token \"" + lexer.getTokenText() + "\" (" + type + ") at " + lexer.getTokenStart()));
            }
            lexer.advance();
        }
    }

    protected void checkCorrectRestart(String text2) {
        IElementType type;
        Lexer mainLexer = this.createLexer();
        String allTokens = LexerTestCase.printTokens(text2, 0, mainLexer);
        Lexer auxLexer = this.createLexer();
        auxLexer.start(text2);
        while ((type = auxLexer.getTokenType()) != null) {
            int tokenStart;
            String subTokens;
            if (auxLexer.getState() == 0 && !allTokens.endsWith(subTokens = LexerTestCase.printTokens(text2, tokenStart = auxLexer.getTokenStart(), mainLexer))) {
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + tokenStart + "; lexer state should not return 0 at this point"), (String)allTokens, (String)subTokens);
            }
            auxLexer.advance();
        }
    }

    protected String printTokens(String text2, int start2) {
        return LexerTestCase.printTokens(text2, start2, this.createLexer());
    }

    protected void checkCorrectRestartOnEveryToken(@NotNull String text2) {
        IElementType type;
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(2);
        }
        Lexer mainLexer = this.createLexer();
        List<Trinity<IElementType, Integer, Integer>> allTokens = LexerTestCase.tokenize(text2, 0, 0, mainLexer);
        Lexer auxLexer = this.createLexer();
        auxLexer.start(text2);
        int index = 0;
        while ((type = auxLexer.getTokenType()) != null) {
            List<Trinity<IElementType, Integer, Integer>> subTokens = LexerTestCase.tokenize(text2, auxLexer.getTokenStart(), auxLexer.getState(), mainLexer);
            if (!allTokens.subList(index++, allTokens.size()).equals(subTokens)) {
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + auxLexer.getTokenStart() + " - " + auxLexer.getTokenText() + "\nAll tokens <type, offset, lexer state>: " + allTokens + "\n"), allTokens.subList(index - 1, allTokens.size()), subTokens);
            }
            auxLexer.advance();
        }
    }

    @NotNull
    private static List<Trinity<IElementType, Integer, Integer>> tokenize(@NotNull String text2, int start2, int state, @NotNull Lexer lexer) {
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(3);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(4);
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> allTokens = new ArrayList<Trinity<IElementType, Integer, Integer>>();
        try {
            lexer.start(text2, start2, text2.length(), state);
        }
        catch (Throwable t) {
            LOG.error("Restarting impossible from offset " + start2, t);
            throw new RuntimeException(t);
        }
        while (lexer.getTokenType() != null) {
            allTokens.add(Trinity.create(lexer.getTokenType(), lexer.getTokenStart(), lexer.getState()));
            lexer.advance();
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> arrayList = allTokens;
        if (arrayList == null) {
            LexerTestCase.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public static String printTokens(CharSequence text2, int start2, Lexer lexer) {
        IElementType tokenType;
        lexer.start(text2, start2, text2.length());
        StringBuilder result2 = new StringBuilder();
        while ((tokenType = lexer.getTokenType()) != null) {
            result2.append(LexerTestCase.printSingleToken(text2, tokenType, lexer.getTokenStart(), lexer.getTokenEnd()));
            lexer.advance();
        }
        return result2.toString();
    }

    @NotNull
    public static String printTokens(@NotNull HighlighterIterator iterator2) {
        if (iterator2 == null) {
            LexerTestCase.$$$reportNull$$$0(6);
        }
        CharSequence text2 = iterator2.getDocument().getCharsSequence();
        StringBuilder result2 = new StringBuilder();
        while (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            result2.append(LexerTestCase.printSingleToken(text2, tokenType, iterator2.getStart(), iterator2.getEnd()));
            iterator2.advance();
        }
        String string = result2.toString();
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static String printSingleToken(CharSequence fileText, IElementType tokenType, int start2, int end) {
        return tokenType + " ('" + LexerTestCase.getTokenText(tokenType, fileText, start2, end) + "')\n";
    }

    protected void doFileTest(String fileExt) {
        this.doTest(this.loadTestDataFile("." + fileExt));
    }

    @NotNull
    protected String loadTestDataFile(String fileExt) {
        String fileName = this.getPathToTestDataFile(fileExt);
        String text2 = "";
        try {
            String fileText = FileUtil.loadFile(new File(fileName));
            text2 = StringUtil.convertLineSeparators(this.shouldTrim() ? fileText.trim() : fileText);
        }
        catch (IOException e) {
            LexerTestCase.fail((String)("can't load file " + fileName + ": " + e.getMessage()));
        }
        String string = text2;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected boolean shouldTrim() {
        return true;
    }

    @NotNull
    private static String getTokenText(IElementType tokenType, CharSequence sequence, int start2, int end) {
        String string = tokenType instanceof TokenWrapper ? ((TokenWrapper)tokenType).getValue() : StringUtil.replace(sequence.subSequence(start2, end).toString(), "\n", "\\n");
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected abstract Lexer createLexer();

    protected abstract String getDirPath();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToTestDataFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "printTokens";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestDataFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkCorrectRestartOnEveryToken";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "printTokens";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

