/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowHeadlessManagerImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class ProjectViewTestUtil {
    public static VirtualFile[] getFiles(AbstractTreeNode<?> kid, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        VirtualFile[] result2;
        if (kid instanceof BasePsiNode) {
            Object value2 = kid.getValue();
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)value2);
            return new VirtualFile[]{virtualFile2};
        }
        if (converterFunction != null && (result2 = converterFunction.fun(kid)) != null) {
            return result2;
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public static void collect(AbstractTreeNode node, MultiValuesMap<VirtualFile, AbstractTreeNode<?>> map2, AbstractTreeStructure structure, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        Object[] kids;
        for (Object kid1 : kids = structure.getChildElements(node)) {
            VirtualFile[] files2;
            ProjectViewNode kid = (ProjectViewNode)kid1;
            for (VirtualFile vFile : files2 = ProjectViewTestUtil.getFiles(kid, converterFunction)) {
                map2.put(vFile, kid);
                for (ProjectViewNode eachParent = (ProjectViewNode)kid.getParent(); eachParent != null; eachParent = (ProjectViewNode)eachParent.getParent()) {
                    map2.put(vFile, eachParent);
                }
            }
            ProjectViewTestUtil.collect(kid, map2, structure, converterFunction);
        }
    }

    public static void checkContainsMethod(Object rootElement, AbstractTreeStructure structure, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        MultiValuesMap map2 = new MultiValuesMap();
        ProjectViewTestUtil.collect((AbstractTreeNode)rootElement, map2, structure, converterFunction);
        for (VirtualFile eachFile : map2.keySet()) {
            Collection<AbstractTreeNode<?>> nodes = map2.values();
            for (AbstractTreeNode<?> node : nodes) {
                boolean expected;
                ProjectViewNode eachNode = (ProjectViewNode)node;
                boolean actual = eachNode.contains(eachFile);
                if (actual == (expected = map2.get(eachFile).contains(eachNode))) continue;
                Assert.fail((String)("file=" + eachFile + "\n node=" + eachNode.getTestPresentation() + " expected:" + expected));
            }
        }
    }

    public static void checkGetParentConsistency(AbstractTreeStructure structure, Object from) {
        Object[] childElements;
        for (Object childElement : childElements = structure.getChildElements(from)) {
            Assert.assertSame((Object)from, (Object)structure.getParentElement(childElement));
            ProjectViewTestUtil.checkGetParentConsistency(structure, childElement);
        }
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.assertStructureEqual(structure, expected, 27, null, structure.getRootElement(), printInfo);
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, int maxRowCount, @Nullable Comparator comparator2, Object rootNode, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.checkGetParentConsistency(structure, rootNode);
        String actual = PlatformTestUtil.print(structure, rootNode, 0, comparator2, maxRowCount, ' ', printInfo).toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected static boolean isExpanded(DefaultMutableTreeNode nodeForElement, AbstractProjectViewPSIPane pane2) {
        TreePath path2 = new TreePath(nodeForElement.getPath());
        return pane2.getTree().isExpanded(path2.getParentPath());
    }

    public static DefaultMutableTreeNode getNodeForElement(PsiElement element2, AbstractProjectViewPSIPane pane2) {
        JTree tree = pane2.getTree();
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        return ProjectViewTestUtil.getNodeForElement(root, model, element2);
    }

    private static DefaultMutableTreeNode getNodeForElement(Object root, TreeModel model, PsiElement element2) {
        Object userObject;
        if (root instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)root).getUserObject()) instanceof AbstractTreeNode) {
            AbstractTreeNode treeNode = (AbstractTreeNode)userObject;
            if (element2.equals(treeNode.getValue())) {
                return (DefaultMutableTreeNode)root;
            }
            for (int i = 0; i < model.getChildCount(root); ++i) {
                DefaultMutableTreeNode nodeForChild = ProjectViewTestUtil.getNodeForElement(model.getChild(root, i), model, element2);
                if (nodeForChild == null) continue;
                return nodeForChild;
            }
        }
        return null;
    }

    public static boolean isExpanded(PsiElement element2, AbstractProjectViewPSIPane pane2) {
        DefaultMutableTreeNode nodeForElement = ProjectViewTestUtil.getNodeForElement(element2, pane2);
        return nodeForElement != null && ProjectViewTestUtil.isExpanded((DefaultMutableTreeNode)nodeForElement.getParent(), pane2);
    }

    public static void setupImpl(@NotNull Project project2, boolean loadPaneExtensions) {
        ToolWindowHeadlessManagerImpl toolWindowManager;
        ToolWindow toolWindow;
        if (project2 == null) {
            ProjectViewTestUtil.$$$reportNull$$$0(0);
        }
        if ((toolWindow = (toolWindowManager = (ToolWindowHeadlessManagerImpl)ToolWindowManager.getInstance(project2)).getToolWindow("Project")) == null) {
            for (ToolWindowEP bean : ToolWindowEP.EP_NAME.getExtensionList()) {
                if (!bean.id.equals("Project")) continue;
                toolWindow = toolWindowManager.doRegisterToolWindow(bean.id);
                break;
            }
        }
        assert (toolWindow != null);
        ((ProjectViewImpl)ProjectView.getInstance(project2)).setupImpl(toolWindow, loadPaneExtensions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/ProjectViewTestUtil", "setupImpl"));
    }
}

