/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.Assert;

public class PsiTestUtil {
    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @NotNull Module module2, String rootPath, @NotNull Collection<? super File> filesToDelete) throws Exception {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(1);
        }
        if (filesToDelete == null) {
            PsiTestUtil.$$$reportNull$$$0(2);
        }
        return PsiTestUtil.createTestProjectStructure(project2, module2, rootPath, filesToDelete, true);
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @NotNull Module module2, @NotNull Collection<? super File> filesToDelete) throws IOException {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(4);
        }
        if (filesToDelete == null) {
            PsiTestUtil.$$$reportNull$$$0(5);
        }
        return PsiTestUtil.createTestProjectStructure(project2, module2, null, filesToDelete, true);
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @Nullable Module module2, String rootPath, @NotNull Collection<? super File> filesToDelete, boolean addProjectRoots) throws IOException {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(6);
        }
        if (filesToDelete == null) {
            PsiTestUtil.$$$reportNull$$$0(7);
        }
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure("unitTest", module2, rootPath, filesToDelete, addProjectRoots);
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        VirtualFile virtualFile2 = vDir;
        if (virtualFile2 == null) {
            PsiTestUtil.$$$reportNull$$$0(8);
        }
        return virtualFile2;
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull String tempName, @Nullable Module module2, String rootPath, @NotNull Collection<? super File> filesToDelete, boolean addProjectRoots) throws IOException {
        if (tempName == null) {
            PsiTestUtil.$$$reportNull$$$0(9);
        }
        if (filesToDelete == null) {
            PsiTestUtil.$$$reportNull$$$0(10);
        }
        File dir = FileUtil.createTempDirectory(tempName, null, false);
        filesToDelete.add(dir);
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        assert (vDir != null && vDir.isDirectory()) : dir;
        HeavyPlatformTestCase.synchronizeTempDirVfs(vDir);
        EdtTestUtil.runInEdtAndWait(() -> WriteAction.run(() -> {
            if (rootPath != null) {
                VirtualFile vDir1 = LocalFileSystem.getInstance().findFileByPath(rootPath.replace(File.separatorChar, '/'));
                if (vDir1 == null) {
                    throw new Exception(rootPath + " not found");
                }
                VfsUtil.copyDirectory(null, vDir1, vDir, null);
            }
            if (addProjectRoots) {
                PsiTestUtil.addSourceContentToRoots(module2, vDir);
            }
        }));
        VirtualFile virtualFile2 = vDir;
        if (virtualFile2 == null) {
            PsiTestUtil.$$$reportNull$$$0(11);
        }
        return virtualFile2;
    }

    public static void removeAllRoots(@NotNull Module module2, Sdk jdk) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(12);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> {
            model.clear();
            model.setSdk(jdk);
        });
    }

    @NotNull
    public static SourceFolder addSourceContentToRoots(@NotNull Module module2, @NotNull VirtualFile vDir) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(13);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(14);
        }
        return PsiTestUtil.addSourceContentToRoots(module2, vDir, false);
    }

    @NotNull
    public static SourceFolder addSourceContentToRoots(@NotNull Module module2, @NotNull VirtualFile vDir, boolean testSource) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(15);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(16);
        }
        Ref result2 = Ref.create();
        ModuleRootModificationUtil.updateModel(module2, model -> result2.set(model.addContentEntry(vDir).addSourceFolder(vDir, testSource)));
        SourceFolder sourceFolder = (SourceFolder)result2.get();
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(17);
        }
        return sourceFolder;
    }

    @NotNull
    public static SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(18);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(19);
        }
        return PsiTestUtil.addSourceRoot(module2, vDir, false);
    }

    @NotNull
    public static SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir, boolean isTestSource) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(20);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(21);
        }
        return PsiTestUtil.addSourceRoot(module2, vDir, isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
    }

    @NotNull
    public static <P extends JpsElement> SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(22);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(23);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(24);
        }
        return PsiTestUtil.addSourceRoot(module2, vDir, rootType, (JpsElement)rootType.createDefaultProperties());
    }

    @NotNull
    public static <P extends JpsElement> SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(25);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(26);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(27);
        }
        if (properties == null) {
            PsiTestUtil.$$$reportNull$$$0(28);
        }
        Ref result2 = Ref.create();
        ModuleRootModificationUtil.updateModel(module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntry(model, vDir);
            if (entry == null) {
                entry = model.addContentEntry(vDir);
            }
            result2.set(entry.addSourceFolder(vDir, rootType, properties));
        });
        SourceFolder sourceFolder = (SourceFolder)result2.get();
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(29);
        }
        return sourceFolder;
    }

    @Nullable
    private static ContentEntry findContentEntry(@NotNull ModuleRootModel rootModel, @NotNull VirtualFile file2) {
        if (rootModel == null) {
            PsiTestUtil.$$$reportNull$$$0(30);
        }
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(31);
        }
        return ContainerUtil.find(rootModel.getContentEntries(), object -> {
            VirtualFile entryRoot = object.getFile();
            return entryRoot != null && VfsUtilCore.isAncestor(entryRoot, file2, false);
        });
    }

    public static ContentEntry addContentRoot(@NotNull Module module2, @NotNull VirtualFile vDir) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(32);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(33);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> model.addContentEntry(vDir));
        for (ContentEntry entry : ModuleRootManager.getInstance(module2).getContentEntries()) {
            if (!Comparing.equal(entry.getFile(), vDir)) continue;
            if (entry instanceof ContentEntryImpl) {
                Assert.assertFalse((boolean)((ContentEntryImpl)entry).isDisposed());
            }
            return entry;
        }
        return null;
    }

    public static void addExcludedRoot(@NotNull Module module2, @NotNull VirtualFile dir) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(34);
        }
        if (dir == null) {
            PsiTestUtil.$$$reportNull$$$0(35);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> ApplicationManager.getApplication().runReadAction(() -> PsiTestUtil.findContentEntryWithAssertion(model, dir).addExcludeFolder(dir)));
    }

    @NotNull
    private static ContentEntry findContentEntryWithAssertion(@NotNull ModifiableRootModel model, @NotNull VirtualFile dir) {
        if (model == null) {
            PsiTestUtil.$$$reportNull$$$0(36);
        }
        if (dir == null) {
            PsiTestUtil.$$$reportNull$$$0(37);
        }
        return PsiTestUtil.assertEntryFound(model, dir, PsiTestUtil.findContentEntry(model, dir));
    }

    @NotNull
    private static ContentEntry assertEntryFound(@NotNull ModifiableRootModel model, @NotNull VirtualFile dir, ContentEntry entry) {
        if (model == null) {
            PsiTestUtil.$$$reportNull$$$0(38);
        }
        if (dir == null) {
            PsiTestUtil.$$$reportNull$$$0(39);
        }
        if (entry == null) {
            throw new RuntimeException(dir + " is not under content roots: " + Arrays.toString(model.getContentRoots()));
        }
        ContentEntry contentEntry = entry;
        if (contentEntry == null) {
            PsiTestUtil.$$$reportNull$$$0(40);
        }
        return contentEntry;
    }

    public static void removeContentEntry(@NotNull Module module2, @NotNull VirtualFile contentRoot) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(41);
        }
        if (contentRoot == null) {
            PsiTestUtil.$$$reportNull$$$0(42);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> {
            ContentEntry entry = ContainerUtil.find(model.getContentEntries(), object -> contentRoot.equals(object.getFile()));
            model.removeContentEntry(PsiTestUtil.assertEntryFound(model, contentRoot, entry));
        });
    }

    public static void removeSourceRoot(@NotNull Module module2, @NotNull VirtualFile root) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(43);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(44);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                if (!root.equals(sourceFolder.getFile())) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
        });
    }

    public static void removeExcludedRoot(@NotNull Module module2, @NotNull VirtualFile root) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(45);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(46);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            entry.removeExcludeFolder(root.getUrl());
        });
    }

    public static void checkErrorElements(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTestUtil.$$$reportNull$$$0(47);
        }
        StringBuilder err = null;
        int s = 0;
        String text2 = element2.getText();
        for (PsiErrorElement error : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(element2)).filter(PsiErrorElement.class)) {
            TextRange r;
            if (err == null) {
                err = new StringBuilder();
            }
            if ((r = error.getTextRange()).getStartOffset() < s) continue;
            err.append(text2, s, r.getStartOffset()).append("<error desc=\"");
            err.append(error.getErrorDescription()).append("\">");
            err.append(error.getText()).append("</error>");
            s = r.getEndOffset();
        }
        if (err == null) {
            return;
        }
        err.append(text2, s, text2.length());
        UsefulTestCase.assertSameLines(text2, err.toString());
    }

    public static void checkFileStructure(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(48);
        }
        PsiTestUtil.compareFromAllRoots(file2, f -> DebugUtil.psiTreeToString(f, false));
    }

    private static void compareFromAllRoots(@NotNull PsiFile file2, @NotNull Function<? super PsiFile, String> fun) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(49);
        }
        if (fun == null) {
            PsiTestUtil.$$$reportNull$$$0(50);
        }
        PsiFile dummyFile = PsiTestUtil.createDummyCopy(file2);
        String psiTree = StringUtil.join(file2.getViewProvider().getAllFiles(), fun, "\n");
        String reparsedTree = StringUtil.join(dummyFile.getViewProvider().getAllFiles(), fun, "\n");
        PsiTestUtil.assertPsiTextTreeConsistency(psiTree, reparsedTree);
    }

    private static void assertPsiTextTreeConsistency(@NotNull String psiTree, @NotNull String reparsedTree) {
        if (psiTree == null) {
            PsiTestUtil.$$$reportNull$$$0(51);
        }
        if (reparsedTree == null) {
            PsiTestUtil.$$$reportNull$$$0(52);
        }
        if (!psiTree.equals(reparsedTree)) {
            String[] psiLines = StringUtil.splitByLinesDontTrim(psiTree);
            String[] reparsedLines = StringUtil.splitByLinesDontTrim(reparsedTree);
            int i = 0;
            while (true) {
                if (i >= psiLines.length || i >= reparsedLines.length || !psiLines[i].equals(reparsedLines[i])) break;
                ++i;
            }
            int n = Math.min(i, psiLines.length - 1);
            psiLines[n] = psiLines[n] + "   // in PSI structure";
            int n2 = Math.min(i, reparsedLines.length - 1);
            reparsedLines[n2] = reparsedLines[n2] + "   // re-created from text";
            psiTree = StringUtil.join(psiLines, "\n");
            reparsedTree = StringUtil.join(reparsedLines, "\n");
            Assert.assertEquals((Object)reparsedTree, (Object)psiTree);
        }
    }

    @NotNull
    private static PsiFile createDummyCopy(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(53);
        }
        LightVirtualFile copy2 = new LightVirtualFile(file2.getName(), file2.getText());
        copy2.setOriginalFile(file2.getViewProvider().getVirtualFile());
        PsiFile dummyCopy = Objects.requireNonNull(file2.getManager().findFile(copy2));
        if (dummyCopy instanceof PsiFileImpl) {
            ((PsiFileImpl)dummyCopy).setOriginalFile(file2);
        }
        PsiFile psiFile = dummyCopy;
        if (psiFile == null) {
            PsiTestUtil.$$$reportNull$$$0(54);
        }
        return psiFile;
    }

    public static void checkPsiMatchesTextIgnoringNonCode(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(55);
        }
        PsiTestUtil.compareFromAllRoots(file2, f -> DebugUtil.psiToStringIgnoringNonCode(f));
    }

    @Deprecated
    public static void disablePsiTextConsistencyChecks(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PsiTestUtil.$$$reportNull$$$0(56);
        }
        Registry.get("ide.check.structural.psi.text.consistency.in.tests").setValue(false, parentDisposable);
    }

    @NotNull
    public static LibraryBuilder newLibrary(String name) {
        return new LibraryBuilder(name);
    }

    public static void addLibrary(@NotNull Module module2, @NotNull String libPath) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(57);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(58);
        }
        File file2 = new File(libPath);
        String libName = file2.getName();
        PsiTestUtil.addLibrary(module2, libName, file2.getParent(), libName);
    }

    public static void addLibrary(@NotNull Module module2, String libName, @NotNull String libPath, String ... jarArr) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(59);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(60);
        }
        if (jarArr == null) {
            PsiTestUtil.$$$reportNull$$$0(61);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> PsiTestUtil.addLibrary(model, libName, libPath, jarArr));
    }

    public static void addLibrary(@NotNull Disposable parent, @NotNull Module module2, String libName, @NotNull String libPath, String ... jarArr) {
        if (parent == null) {
            PsiTestUtil.$$$reportNull$$$0(62);
        }
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(63);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(64);
        }
        if (jarArr == null) {
            PsiTestUtil.$$$reportNull$$$0(65);
        }
        Ref ref = new Ref();
        ModuleRootModificationUtil.updateModel(module2, model -> ref.set(PsiTestUtil.addLibrary(model, libName, libPath, jarArr)));
        Disposer.register(parent, () -> {
            Library library = (Library)ref.get();
            ModuleRootModificationUtil.updateModel(module2, model -> {
                LibraryOrderEntry entry = model.findLibraryOrderEntry(library);
                if (entry != null) {
                    model.removeOrderEntry(entry);
                }
            });
            WriteCommandAction.runWriteCommandAction(null, () -> {
                LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable(module2.getProject());
                LibraryTable.ModifiableModel model = table.getModifiableModel();
                model.removeLibrary(library);
                model.commit();
            });
        });
    }

    public static void addProjectLibrary(@NotNull Module module2, String libName, @NotNull List<String> classesRootPaths) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(66);
        }
        if (classesRootPaths == null) {
            PsiTestUtil.$$$reportNull$$$0(67);
        }
        List<VirtualFile> roots = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(module2, libName, roots, Collections.emptyList());
    }

    @NotNull
    private static List<VirtualFile> getLibraryRoots(@NotNull List<String> classesRootPaths) {
        if (classesRootPaths == null) {
            PsiTestUtil.$$$reportNull$$$0(68);
        }
        List<VirtualFile> list2 = ContainerUtil.map(classesRootPaths, path2 -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File((String)path2))));
        if (list2 == null) {
            PsiTestUtil.$$$reportNull$$$0(69);
        }
        return list2;
    }

    public static void addProjectLibrary(@NotNull ModifiableRootModel model, String libName, @NotNull List<String> classesRootPaths) {
        if (model == null) {
            PsiTestUtil.$$$reportNull$$$0(70);
        }
        if (classesRootPaths == null) {
            PsiTestUtil.$$$reportNull$$$0(71);
        }
        List<VirtualFile> roots = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(model, libName, roots, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static void addProjectLibrary(@NotNull Module module2, String libName, VirtualFile ... classesRoots) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(72);
        }
        if (classesRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(73);
        }
        PsiTestUtil.addProjectLibrary(module2, libName, Arrays.asList(classesRoots), Collections.emptyList());
    }

    @NotNull
    public static Library addProjectLibrary(@NotNull Module module2, String libName, @NotNull List<? extends VirtualFile> classesRoots, @NotNull List<? extends VirtualFile> sourceRoots2) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(74);
        }
        if (classesRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(75);
        }
        if (sourceRoots2 == null) {
            PsiTestUtil.$$$reportNull$$$0(76);
        }
        Ref result2 = Ref.create();
        ModuleRootModificationUtil.updateModel(module2, model -> result2.set(PsiTestUtil.addProjectLibrary(model, libName, classesRoots, sourceRoots2, Collections.emptyList(), Collections.emptyList())));
        Library library = (Library)result2.get();
        if (library == null) {
            PsiTestUtil.$$$reportNull$$$0(77);
        }
        return library;
    }

    @NotNull
    private static Library addProjectLibrary(@NotNull ModifiableRootModel model, String libName, @NotNull List<? extends VirtualFile> classesRoots, @NotNull List<? extends VirtualFile> sourceRoots2, @NotNull List<? extends VirtualFile> javaDocs, @NotNull List<? extends VirtualFile> externalAnnotationsRoots) {
        if (model == null) {
            PsiTestUtil.$$$reportNull$$$0(78);
        }
        if (classesRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(79);
        }
        if (sourceRoots2 == null) {
            PsiTestUtil.$$$reportNull$$$0(80);
        }
        if (javaDocs == null) {
            PsiTestUtil.$$$reportNull$$$0(81);
        }
        if (externalAnnotationsRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(82);
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(model.getProject());
        Library library = WriteAction.computeAndWait(() -> {
            Library library = libraryTable.createLibrary(libName);
            Library.ModifiableModel libraryModel = library.getModifiableModel();
            try {
                for (VirtualFile root : classesRoots) {
                    libraryModel.addRoot(root, OrderRootType.CLASSES);
                }
                for (VirtualFile root : sourceRoots2) {
                    libraryModel.addRoot(root, OrderRootType.SOURCES);
                }
                for (VirtualFile root : javaDocs) {
                    libraryModel.addRoot(root, JavadocOrderRootType.getInstance());
                }
                for (VirtualFile root : externalAnnotationsRoots) {
                    libraryModel.addRoot(root, AnnotationOrderRootType.getInstance());
                }
                libraryModel.commit();
            }
            catch (Throwable t) {
                libraryModel.dispose();
                throw t;
            }
            model.addLibraryEntry(library);
            OrderEntry[] orderEntries = model.getOrderEntries();
            OrderEntry last = orderEntries[orderEntries.length - 1];
            System.arraycopy(orderEntries, 0, orderEntries, 1, orderEntries.length - 1);
            orderEntries[0] = last;
            model.rearrangeOrderEntries(orderEntries);
            return library;
        });
        if (library == null) {
            PsiTestUtil.$$$reportNull$$$0(83);
        }
        return library;
    }

    @NotNull
    public static Library addLibrary(@NotNull ModifiableRootModel model, String libName, @NotNull String libPath, String ... jarArr) {
        if (model == null) {
            PsiTestUtil.$$$reportNull$$$0(84);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(85);
        }
        if (jarArr == null) {
            PsiTestUtil.$$$reportNull$$$0(86);
        }
        ArrayList<VirtualFile> classesRoots = new ArrayList<VirtualFile>();
        for (String jar : jarArr) {
            String path2;
            if (!libPath.endsWith("/") && !jar.startsWith("/")) {
                jar = "/" + jar;
            }
            VirtualFile root = (path2 = libPath + jar).endsWith(".jar") ? JarFileSystem.getInstance().refreshAndFindFileByPath(path2 + "!/") : LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
            assert (root != null) : "Library root folder not found: " + path2 + "!/";
            classesRoots.add(root);
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(model.getProject());
        if (libraryTable.getLibraryByName(libName) != null) {
            for (int index = 0; index < 100000; ++index) {
                String candidate = libName + "-" + index;
                if (libraryTable.getLibraryByName(candidate) != null) continue;
                libName = candidate;
                break;
            }
        }
        return PsiTestUtil.addProjectLibrary(model, libName, classesRoots, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static void addLibrary(@NotNull Module module2, String libName, @NotNull String libDir, String @NotNull [] classRoots, String @NotNull [] sourceRoots2) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(87);
        }
        if (libDir == null) {
            PsiTestUtil.$$$reportNull$$$0(88);
        }
        if (classRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(89);
        }
        if (sourceRoots2 == null) {
            PsiTestUtil.$$$reportNull$$$0(90);
        }
        String proto = (classRoots.length > 0 ? classRoots[0] : sourceRoots2[0]).endsWith(".jar!/") ? "jar" : "file";
        String parentUrl = VirtualFileManager.constructUrl(proto, libDir);
        ArrayList<String> classesUrls = new ArrayList<String>();
        for (String classRoot : classRoots) {
            classesUrls.add(parentUrl + classRoot);
        }
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (String sourceRoot : sourceRoots2) {
            sourceUrls.add(parentUrl + sourceRoot);
        }
        ModuleRootModificationUtil.addModuleLibrary(module2, libName, classesUrls, sourceUrls);
    }

    @NotNull
    public static Module addModule(@NotNull Project project2, @NotNull ModuleType type, @NotNull String name, @NotNull VirtualFile root) {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(91);
        }
        if (type == null) {
            PsiTestUtil.$$$reportNull$$$0(92);
        }
        if (name == null) {
            PsiTestUtil.$$$reportNull$$$0(93);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(94);
        }
        Module module2 = WriteCommandAction.writeCommandAction(project2).compute(() -> {
            String moduleName;
            ModifiableModuleModel moduleModel = ModuleManager.getInstance(project2).getModifiableModel();
            try {
                moduleName = moduleModel.newModule(root.getPath() + "/" + name + ".iml", type.getId()).getName();
                moduleModel.commit();
            }
            catch (Throwable t) {
                moduleModel.dispose();
                throw t;
            }
            Module dep = ModuleManager.getInstance(project2).findModuleByName(moduleName);
            assert (dep != null) : moduleName;
            ModifiableRootModel model = ModuleRootManager.getInstance(dep).getModifiableModel();
            try {
                model.addContentEntry(root).addSourceFolder(root, false);
                model.commit();
            }
            catch (Throwable t) {
                model.dispose();
                throw t;
            }
            return dep;
        });
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(95);
        }
        return module2;
    }

    public static void setCompilerOutputPath(@NotNull Module module2, @NotNull String url, boolean forTests) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(96);
        }
        if (url == null) {
            PsiTestUtil.$$$reportNull$$$0(97);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> {
            CompilerModuleExtension extension = model.getModuleExtension(CompilerModuleExtension.class);
            extension.inheritCompilerOutputPath(false);
            if (forTests) {
                extension.setCompilerOutputPathForTests(url);
            } else {
                extension.setCompilerOutputPath(url);
            }
        });
    }

    public static void setExcludeCompileOutput(@NotNull Module module2, boolean exclude) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(98);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> model.getModuleExtension(CompilerModuleExtension.class).setExcludeOutput(exclude));
    }

    public static void setJavadocUrls(@NotNull Module module2, String ... urls) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(99);
        }
        if (urls == null) {
            PsiTestUtil.$$$reportNull$$$0(100);
        }
        ModuleRootModificationUtil.updateModel(module2, model -> model.getModuleExtension(JavaModuleExternalPaths.class).setJavadocUrls(urls));
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addJdkAnnotations(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(101);
        }
        String path2 = FileUtil.toSystemIndependentName(PlatformTestUtil.getCommunityPath()) + "/java/jdkAnnotations";
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path2);
        return PsiTestUtil.addRootsToJdk(sdk2, AnnotationOrderRootType.getInstance(), root);
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addRootsToJdk(@NotNull Sdk sdk2, @NotNull OrderRootType rootType, VirtualFile ... roots) {
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(102);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(103);
        }
        if (roots == null) {
            PsiTestUtil.$$$reportNull$$$0(104);
        }
        return PsiTestUtil.modifyJdkRoots(sdk2, sdkModificator -> {
            for (VirtualFile root : roots) {
                sdkModificator.setName(sdkModificator.getName() + "+" + root.getPath());
                sdkModificator.addRoot(root, rootType);
            }
        });
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk modifyJdkRoots(@NotNull Sdk sdk2, Consumer<? super SdkModificator> modifier) {
        Sdk clone;
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(105);
        }
        try {
            clone = (Sdk)sdk2.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = clone.getSdkModificator();
        modifier.accept(sdkModificator);
        sdkModificator.commitChanges();
        Sdk sdk3 = clone;
        if (sdk3 == null) {
            PsiTestUtil.$$$reportNull$$$0(106);
        }
        return sdk3;
    }

    public static void checkStubsMatchText(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(107);
        }
        try {
            StubTextInconsistencyException.checkStubTextConsistency(file2);
        }
        catch (StubTextInconsistencyException e) {
            PsiTestUtil.compareStubTexts(e);
        }
    }

    public static void compareStubTexts(@NotNull StubTextInconsistencyException e) {
        if (e == null) {
            PsiTestUtil.$$$reportNull$$$0(108);
        }
        PsiTestUtil.assertPsiTextTreeConsistency(e.getStubsFromPsi(), e.getStubsFromText());
        throw e;
    }

    public static void checkPsiStructureWithCommit(@NotNull PsiFile psiFile, @NotNull Consumer<? super PsiFile> checker) {
        if (psiFile == null) {
            PsiTestUtil.$$$reportNull$$$0(109);
        }
        if (checker == null) {
            PsiTestUtil.$$$reportNull$$$0(110);
        }
        checker.accept(psiFile);
        Document document = psiFile.getViewProvider().getDocument();
        PsiDocumentManager manager = PsiDocumentManager.getInstance(psiFile.getProject());
        if (document != null && manager.isUncommited(document)) {
            manager.commitDocument(document);
            checker.accept(manager.getPsiFile(document));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 29: 
            case 40: 
            case 54: 
            case 69: 
            case 77: 
            case 83: 
            case 95: 
            case 106: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 29: 
            case 40: 
            case 54: 
            case 69: 
            case 77: 
            case 83: 
            case 95: 
            case 106: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 32: 
            case 34: 
            case 41: 
            case 43: 
            case 45: 
            case 57: 
            case 59: 
            case 63: 
            case 66: 
            case 72: 
            case 74: 
            case 87: 
            case 96: 
            case 98: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 29: 
            case 40: 
            case 54: 
            case 69: 
            case 77: 
            case 83: 
            case 95: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempName";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 24: 
            case 27: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 31: 
            case 48: 
            case 49: 
            case 53: 
            case 55: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 36: 
            case 38: 
            case 70: 
            case 78: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 44: 
            case 46: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTree";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparsedTree";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 58: 
            case 60: 
            case 64: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libPath";
                break;
            }
            case 61: 
            case 65: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarArr";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 67: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRootPaths";
                break;
            }
            case 73: 
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 76: 
            case 80: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocs";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalAnnotationsRoots";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRoots";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 101: 
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestProjectStructure";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceContentToRoots";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceRoot";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "assertEntryFound";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyCopy";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 77: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "addProjectLibrary";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "addModule";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyJdkRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestProjectStructure";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 29: 
            case 40: 
            case 54: 
            case 69: 
            case 77: 
            case 83: 
            case 95: 
            case 106: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRoots";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSourceContentToRoots";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoot";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntry";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addContentRoot";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntryWithAssertion";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "assertEntryFound";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeContentEntry";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceRoot";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkErrorElements";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkFileStructure";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "compareFromAllRoots";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "assertPsiTextTreeConsistency";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createDummyCopy";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiMatchesTextIgnoringNonCode";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "disablePsiTextConsistencyChecks";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addProjectLibrary";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "setCompilerOutputPath";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "setExcludeCompileOutput";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "setJavadocUrls";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "addJdkAnnotations";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "addRootsToJdk";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "modifyJdkRoots";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "checkStubsMatchText";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "compareStubTexts";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiStructureWithCommit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 29: 
            case 40: 
            case 54: 
            case 69: 
            case 77: 
            case 83: 
            case 95: 
            case 106: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LibraryBuilder {
        private final String myName;
        private final List<VirtualFile> myClassesRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> mySourceRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> myJavaDocRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> myExternalAnnotationsRoots = new ArrayList<VirtualFile>();

        private LibraryBuilder(String name) {
            this.myName = name;
        }

        @NotNull
        public LibraryBuilder classesRoot(@NotNull VirtualFile root) {
            if (root == null) {
                LibraryBuilder.$$$reportNull$$$0(0);
            }
            this.myClassesRoots.add(root);
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(1);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder classesRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(2);
            }
            this.myClassesRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(3);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder sourceRoot(@NotNull VirtualFile root) {
            if (root == null) {
                LibraryBuilder.$$$reportNull$$$0(4);
            }
            this.mySourceRoots.add(root);
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(5);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder sourceRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(6);
            }
            this.mySourceRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(7);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder javaDocRoot(@NotNull VirtualFile root) {
            if (root == null) {
                LibraryBuilder.$$$reportNull$$$0(8);
            }
            this.myJavaDocRoots.add(root);
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(9);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder javaDocRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(10);
            }
            this.myJavaDocRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(11);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder externalAnnotationsRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(12);
            }
            this.myExternalAnnotationsRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(13);
            }
            return libraryBuilder;
        }

        @NotNull
        public Library addTo(@NotNull ModifiableRootModel model) {
            if (model == null) {
                LibraryBuilder.$$$reportNull$$$0(14);
            }
            Library library = PsiTestUtil.addProjectLibrary(model, this.myName, this.myClassesRoots, this.mySourceRoots, this.myJavaDocRoots, this.myExternalAnnotationsRoots);
            if (library == null) {
                LibraryBuilder.$$$reportNull$$$0(15);
            }
            return library;
        }

        @NotNull
        public Library addTo(@NotNull Module module2) {
            if (module2 == null) {
                LibraryBuilder.$$$reportNull$$$0(16);
            }
            Ref result2 = Ref.create();
            ModuleRootModificationUtil.updateModel(module2, model -> result2.set(this.addTo((ModifiableRootModel)model)));
            Library library = (Library)result2.get();
            if (library == null) {
                LibraryBuilder.$$$reportNull$$$0(17);
            }
            return library;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/PsiTestUtil$LibraryBuilder";
                    break;
                }
                case 2: 
                case 6: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPath";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/PsiTestUtil$LibraryBuilder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classesRoot";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sourceRoot";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "javaDocRoot";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "externalAnnotationsRoot";
                    break;
                }
                case 15: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addTo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "classesRoot";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "sourceRoot";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "javaDocRoot";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "externalAnnotationsRoot";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

