/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0002J\u001c\u0010\u0018\u001a\u00020\u00052\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/testFramework/TemporaryDirectory;", "Lorg/junit/rules/ExternalResource;", "()V", "paths", "Lcom/intellij/util/SmartList;", "Ljava/nio/file/Path;", "<set-?>", "", "sanitizedName", "getSanitizedName", "()Ljava/lang/String;", "setSanitizedName", "(Ljava/lang/String;)V", "sanitizedName$delegate", "Lkotlin/properties/ReadWriteProperty;", "after", "", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "generatePath", "suffix", "newPath", "directoryName", "refreshVfs", "", "newVirtualDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.platform.testFramework"})
public final class TemporaryDirectory
extends ExternalResource {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final SmartList<Path> paths = new SmartList();
    private final ReadWriteProperty sanitizedName$delegate = Delegates.INSTANCE.notNull();
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TemporaryDirectory.class), "sanitizedName", "getSanitizedName()Ljava/lang/String;"))};
        Companion = new Companion(null);
    }

    private final String getSanitizedName() {
        return (String)this.sanitizedName$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setSanitizedName(String string) {
        this.sanitizedName$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        String string = description.getMethodName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"description.methodName");
        this.setSanitizedName(PathKt.sanitizeFileName$default((String)string, null, (boolean)false, (int)6, null));
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkExpressionValueIsNotNull((Object)statement2, (String)"super.apply(base, description)");
        return statement2;
    }

    protected void after() {
        SmartList<Throwable> errors = new SmartList<Throwable>();
        for (Path path2 : this.paths) {
            try {
                Path path3 = path2;
                Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"path");
                PathKt.delete$default((Path)path3, (boolean)false, (int)1, null);
            }
            catch (Throwable e) {
                errors.add(e);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List<? extends Throwable>)errors);
        this.paths.clear();
    }

    @NotNull
    public final Path newPath(@Nullable String directoryName, boolean refreshVfs) {
        Path path2 = this.generatePath(directoryName);
        if (refreshVfs) {
            VfsKt.refreshVfs(path2);
        }
        return path2;
    }

    public static /* synthetic */ Path newPath$default(TemporaryDirectory temporaryDirectory, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return temporaryDirectory.newPath(string, bl);
    }

    private final Path generatePath(String suffix) {
        String fileName = this.getSanitizedName();
        if (suffix != null) {
            fileName = fileName + '_' + suffix;
        }
        Path path2 = Companion.generateTemporaryPath(fileName);
        this.paths.add(path2);
        return path2;
    }

    @NotNull
    public final VirtualFile newVirtualDirectory(@Nullable String directoryName) {
        Path path2 = this.generatePath(directoryName);
        PathKt.createDirectories((Path)path2);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)path2));
        VfsUtil.markDirtyAndRefresh(false, true, true, virtualFile2);
        VirtualFile virtualFile3 = virtualFile2;
        if (virtualFile3 == null) {
            Intrinsics.throwNpe();
        }
        return virtualFile3;
    }

    public static /* synthetic */ VirtualFile newVirtualDirectory$default(TemporaryDirectory temporaryDirectory, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return temporaryDirectory.newVirtualDirectory(string);
    }

    @JvmStatic
    @NotNull
    public static final Path generateTemporaryPath(@NotNull String fileName) {
        return Companion.generateTemporaryPath(fileName);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/TemporaryDirectory$Companion;", "", "()V", "generateTemporaryPath", "Ljava/nio/file/Path;", "fileName", "", "intellij.platform.testFramework"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Path generateTemporaryPath(@NotNull String fileName) {
            Path path2;
            Path path3;
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            Path tempDirectory = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
            Path path4 = path3 = tempDirectory.resolve(fileName);
            Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"path");
            if (!PathKt.exists((Path)path4)) {
                return path3;
            }
            int i = 0;
            String string = FileUtilRt.getExtension(fileName);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtilRt.getExtension(fileName)");
            String ext = string;
            CharSequence charSequence = ext;
            boolean bl = false;
            if (charSequence.length() > 0) {
                ext = '.' + ext;
            }
            String string2 = FileUtilRt.getNameWithoutExtension(fileName);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtilRt.getNameWithoutExtension(fileName)");
            String name = string2;
            do {
                path3 = tempDirectory.resolve(name + '_' + i + ext);
                path2 = path3;
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
            } while (PathKt.exists((Path)path2) && ++i < 9);
            if (PathKt.exists((Path)path3)) {
                throw (Throwable)new IOException("Cannot generate unique random path with '" + name + "' prefix under '" + path3 + '\'');
            }
            return path3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

