/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.testFramework.TestModeFlagListener;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TestModeFlags {
    private static final HashMap<String, Object> ourFlags = new HashMap();
    private static final List<TestModeFlagListener> ourListeners = new CopyOnWriteArrayList<TestModeFlagListener>();

    public static <T> T set(Key<T> flag, T value2) {
        Object oldValue = ourFlags.get(flag.toString());
        ourFlags.put(flag.toString(), value2);
        for (TestModeFlagListener listener2 : ourListeners) {
            listener2.testModeFlagChanged(flag, value2);
        }
        return (T)oldValue;
    }

    public static void reset(Key<?> flag) {
        TestModeFlags.set(flag, null);
    }

    public static <T> void set(Key<T> flag, T value2, Disposable parentDisposable) {
        Object oldValue = TestModeFlags.get(flag);
        TestModeFlags.set(flag, value2);
        Disposer.register(parentDisposable, () -> TestModeFlags.set(flag, oldValue));
    }

    public static <T> T get(Key<T> flag) {
        return (T)ourFlags.get(flag.toString());
    }

    public static boolean is(Key<Boolean> flag) {
        return TestModeFlags.get(flag) == Boolean.TRUE;
    }

    public static void addListener(TestModeFlagListener listener2) {
        ourListeners.add(listener2);
    }
}

