/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.testFramework.CpuTimings;
import com.intellij.testFramework.IoTimings;

public class Timings {
    public static final long CPU_TIMING;
    public static final long IO_TIMING;
    public static final long REFERENCE_CPU_TIMING = 200L;
    public static final long REFERENCE_IO_TIMING = 100L;

    public static int adjustAccordingToMySpeed(int value2, boolean isParallelizable) {
        return Math.max(1, (int)(1.0 * (double)value2 * 200.0 / (double)CPU_TIMING) / 8 * (isParallelizable ? JobSchedulerImpl.getJobPoolParallelism() : 1));
    }

    public static String getStatistics() {
        return String.format("CPU=%d (%d%% reference CPU), I/O=%d (%d%% reference IO), %d cores", CPU_TIMING, CPU_TIMING * 100L / 200L, IO_TIMING, IO_TIMING * 100L / 100L, Runtime.getRuntime().availableProcessors());
    }

    static {
        long cpuTiming = CpuTimings.calcStableCpuTiming();
        if (SystemInfo.isJavaVersionAtLeast(11, 0, 0)) {
            cpuTiming = cpuTiming * 54L / 31L;
        }
        CPU_TIMING = cpuTiming;
        IO_TIMING = IoTimings.calcIoTiming();
    }
}

