/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create("TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(1);
        }
        return VfsTestUtil.createFile(root, relativePath, "");
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, @NotNull String text2) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(2);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            VfsTestUtil.$$$reportNull$$$0(4);
        }
        try {
            return VfsTestUtil.createFileOrDir(root, relativePath, VfsUtil.toByteArray(root, text2), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, byte @NotNull [] data2) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(5);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(6);
        }
        if (data2 == null) {
            VfsTestUtil.$$$reportNull$$$0(7);
        }
        return VfsTestUtil.createFileOrDir(root, relativePath, data2, false);
    }

    @NotNull
    public static VirtualFile createDir(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(8);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(9);
        }
        return VfsTestUtil.createFileOrDir(root, relativePath, ArrayUtil.EMPTY_BYTE_ARRAY, true);
    }

    @NotNull
    private static VirtualFile createFileOrDir(VirtualFile root, String relativePath, byte @NotNull [] data2, boolean dir) {
        VirtualFile virtualFile2;
        if (data2 == null) {
            VfsTestUtil.$$$reportNull$$$0(10);
        }
        try {
            virtualFile2 = WriteAction.computeAndWait(() -> {
                VirtualFile file2;
                VirtualFile parent = root;
                for (String name : StringUtil.tokenize(PathUtil.getParentPath(relativePath), "/")) {
                    VirtualFile child2 = parent.findChild(name);
                    if (child2 == null || !child2.isValid()) {
                        child2 = parent.createChildDirectory(VfsTestUtil.class, name);
                    }
                    parent = child2;
                }
                parent.getChildren();
                String name = PathUtil.getFileName(relativePath);
                if (dir) {
                    file2 = parent.createChildDirectory(VfsTestUtil.class, name);
                } else {
                    FileDocumentManager manager = FileDocumentManager.getInstance();
                    file2 = parent.findChild(name);
                    if (file2 == null) {
                        file2 = parent.createChildData(VfsTestUtil.class, name);
                    } else {
                        Document document = manager.getCachedDocument(file2);
                        if (document != null) {
                            manager.saveDocument(document);
                        }
                    }
                    file2.setBinaryContent(data2);
                    manager.reloadFiles(file2);
                }
                return file2;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile2 == null) {
            VfsTestUtil.$$$reportNull$$$0(11);
        }
        return virtualFile2;
    }

    public static void deleteFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsTestUtil.$$$reportNull$$$0(12);
        }
        try {
            WriteAction.runAndWait(() -> file2.delete(null));
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrow(throwable);
        }
    }

    public static void clearContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsTestUtil.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VfsUtil.saveText(file2, "");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void overwriteTestData(@NotNull String filePath2, @NotNull String actual) {
        if (filePath2 == null) {
            VfsTestUtil.$$$reportNull$$$0(14);
        }
        if (actual == null) {
            VfsTestUtil.$$$reportNull$$$0(15);
        }
        try {
            FileUtil.writeToFile(new File(filePath2), actual);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static VirtualFile findFileByCaseSensitivePath(@NotNull String absolutePath) {
        if (absolutePath == null) {
            VfsTestUtil.$$$reportNull$$$0(16);
        }
        String vfsPath = FileUtil.toSystemIndependentName(absolutePath);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(vfsPath);
        Assert.assertNotNull((String)("file " + absolutePath + " not found"), (Object)vFile);
        String realVfsPath = vFile.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.equals(realVfsPath) && vfsPath.equalsIgnoreCase(realVfsPath)) {
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + vfsPath + "\nreal path " + realVfsPath));
        }
        VirtualFile virtualFile2 = vFile;
        if (virtualFile2 == null) {
            VfsTestUtil.$$$reportNull$$$0(17);
        }
        return virtualFile2;
    }

    public static void assertFilePathEndsWithCaseSensitivePath(@NotNull VirtualFile file2, @NotNull String suffixPath) {
        if (file2 == null) {
            VfsTestUtil.$$$reportNull$$$0(18);
        }
        if (suffixPath == null) {
            VfsTestUtil.$$$reportNull$$$0(19);
        }
        String vfsSuffixPath = FileUtil.toSystemIndependentName(suffixPath);
        String vfsPath = file2.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.endsWith(vfsSuffixPath) && StringUtil.endsWithIgnoreCase(vfsPath, vfsSuffixPath)) {
            String realSuffixPath = vfsPath.substring(vfsPath.length() - vfsSuffixPath.length());
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + suffixPath + "\nreal path " + realSuffixPath));
        }
    }

    @NotNull
    public static List<VFileEvent> getEvents(@NotNull Runnable action2) {
        if (action2 == null) {
            VfsTestUtil.$$$reportNull$$$0(20);
        }
        final List<VFileEvent> allEvents = Collections.synchronizedList(new ArrayList());
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                allEvents.addAll(events);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/testFramework/VfsTestUtil$1", "after"));
            }
        });
        try {
            action2.run();
        }
        finally {
            connection.disconnect();
        }
        List<VFileEvent> list2 = allEvents;
        if (list2 == null) {
            VfsTestUtil.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    public static List<String> print(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            VfsTestUtil.$$$reportNull$$$0(22);
        }
        List<String> list2 = ContainerUtil.map(events, VfsTestUtil::print);
        if (list2 == null) {
            VfsTestUtil.$$$reportNull$$$0(23);
        }
        return list2;
    }

    private static String print(VFileEvent e) {
        int type = 63;
        if (e instanceof VFileCreateEvent) {
            type = 67;
        } else if (e instanceof VFileDeleteEvent) {
            type = 68;
        } else if (e instanceof VFileContentChangeEvent) {
            type = 85;
        } else if (e instanceof VFilePropertyChangeEvent) {
            type = 80;
        }
        return (char)type + " : " + e.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 17: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 17: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/VfsTestUtil";
                break;
            }
            case 12: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixPath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/VfsTestUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileOrDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileByCaseSensitivePath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "print";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFileOrDir";
                break;
            }
            case 11: 
            case 17: 
            case 21: 
            case 23: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearContent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "overwriteTestData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFileByCaseSensitivePath";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "assertFilePathEndsWithCaseSensitivePath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEvents";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 17: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

