/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class EditorTestFixture {
    @NotNull
    private final Project myProject;
    private final Editor myEditor;
    private final VirtualFile myFile;
    private boolean myEmptyLookup;

    public EditorTestFixture(@NotNull Project project2, Editor editor, VirtualFile file2) {
        if (project2 == null) {
            EditorTestFixture.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myEditor = editor;
        this.myFile = file2;
    }

    public void type(char c) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            EditorActionManager actionManager = EditorActionManager.getInstance();
            if (c == '\b') {
                this.performEditorAction("EditorBackSpace");
                return;
            }
            if (c == '\n') {
                if (this.performEditorAction("EditorChooseLookupItem")) {
                    return;
                }
                if (this.performEditorAction("NextTemplateVariable")) {
                    return;
                }
                this.performEditorAction("EditorEnter");
                return;
            }
            if (c == '\t') {
                if (this.performEditorAction("EditorChooseLookupItemReplace")) {
                    return;
                }
                if (this.performEditorAction("ExpandLiveTemplateByTab")) {
                    return;
                }
                if (this.performEditorAction("NextTemplateVariable")) {
                    return;
                }
                if (this.performEditorAction("EditorTab")) {
                    return;
                }
            }
            if (c == '\r' && this.performEditorAction("EditorChooseLookupItemCompleteStatement")) {
                return;
            }
            ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, this.getEditorDataContext());
            TypedAction.getInstance().actionPerformed(this.myEditor, c, this.getEditorDataContext());
        });
    }

    public void type(@NotNull String s) {
        if (s == null) {
            EditorTestFixture.$$$reportNull$$$0(1);
        }
        for (int i = 0; i < s.length(); ++i) {
            this.type(s.charAt(i));
        }
    }

    public boolean performEditorAction(@NotNull String actionId) {
        if (actionId == null) {
            EditorTestFixture.$$$reportNull$$$0(2);
        }
        DataContext dataContext = this.getEditorDataContext();
        ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        AnAction action2 = managerEx.getAction(actionId);
        AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), managerEx, 0);
        action2.beforeActionPerformedUpdate(event);
        if (!event.getPresentation().isEnabled()) {
            return false;
        }
        ActionUtil.performActionDumbAwareWithCallbacks(action2, event, dataContext);
        return true;
    }

    @NotNull
    private DataContext getEditorDataContext() {
        DataContext dataContext = ((EditorEx)this.myEditor).getDataContext();
        if (dataContext == null) {
            EditorTestFixture.$$$reportNull$$$0(3);
        }
        return dataContext;
    }

    public PsiFile getFile() {
        return this.myFile != null ? ReadAction.compute(() -> PsiManager.getInstance(this.myProject).findFile(this.myFile)) : null;
    }

    @NotNull
    public List<HighlightInfo> doHighlighting() {
        List<HighlightInfo> list2 = this.doHighlighting(false, false);
        if (list2 == null) {
            EditorTestFixture.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public List<HighlightInfo> doHighlighting(boolean myAllowDirt, boolean readEditorMarkupModel) {
        EdtTestUtil.runInEdtAndWait(() -> PsiDocumentManager.getInstance(this.myProject).commitAllDocuments());
        PsiFile file2 = this.getFile();
        Editor editor = this.myEditor;
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageManager.getInstance(file2.getProject()).getTopLevelFile(file2);
        }
        Assert.assertNotNull((Object)file2);
        List<HighlightInfo> list2 = CodeInsightTestFixtureImpl.instantiateAndRun(file2, editor, ArrayUtilRt.EMPTY_INT_ARRAY, myAllowDirt, readEditorMarkupModel);
        if (list2 == null) {
            EditorTestFixture.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    protected Editor getCompletionEditor() {
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.getFile());
    }

    public LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
    }

    public LookupElement[] complete(@NotNull CompletionType type) {
        if (type == null) {
            EditorTestFixture.$$$reportNull$$$0(6);
        }
        return this.complete(type, 1);
    }

    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    public LookupElement[] complete(@NotNull CompletionType type, int invocationCount) {
        if (type == null) {
            EditorTestFixture.$$$reportNull$$$0(7);
        }
        this.myEmptyLookup = false;
        ApplicationManager.getApplication().invokeAndWait(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            CodeCompletionHandlerBase handler2 = new CodeCompletionHandlerBase(type){

                @Override
                protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
                    EditorTestFixture.this.myEmptyLookup = indicator.getLookup().getItems().isEmpty();
                    super.completionFinished(indicator, hasModifiers);
                }
            };
            Editor editor = this.getCompletionEditor();
            Assert.assertNotNull((Object)editor);
            handler2.invokeCompletion(this.myProject, editor, invocationCount);
            PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        }, null, null, this.myEditor.getDocument()));
        return this.getLookupElements();
    }

    public LookupElement @Nullable [] getLookupElements() {
        LookupImpl lookup2 = this.getLookup();
        if (lookup2 == null) {
            return this.myEmptyLookup ? LookupElement.EMPTY_ARRAY : null;
        }
        List<LookupElement> list2 = lookup2.getItems();
        return list2.toArray(LookupElement.EMPTY_ARRAY);
    }

    public List<String> getLookupElementStrings() {
        LookupElement[] elements2 = this.getLookupElements();
        if (elements2 == null) {
            return null;
        }
        return ContainerUtil.map(elements2, LookupElement::getLookupString);
    }

    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        CaretModel caretModel = this.myEditor.getCaretModel();
        List<Caret> carets = caretModel.getAllCarets();
        ArrayList<Integer> originalOffsets = new ArrayList<Integer>(carets.size());
        for (Caret caret : carets) {
            originalOffsets.add(caret.getOffset());
        }
        caretModel.removeSecondaryCarets();
        Collections.reverse(originalOffsets);
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        Iterator iterator2 = originalOffsets.iterator();
        while (iterator2.hasNext()) {
            int originalOffset = (Integer)iterator2.next();
            caretModel.moveToOffset(originalOffset);
            LookupElement[] lookupElements = this.completeBasic();
            if (charToTypeAfterCompletion != null) {
                this.type(charToTypeAfterCompletion.charValue());
            }
            if (lookupElements == null) continue;
            result2.addAll(Arrays.asList(lookupElements));
        }
        ArrayList<LookupElement> arrayList = result2;
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public void assertPreferredCompletionItems(int selected2, String ... expected) {
        if (expected == null) {
            EditorTestFixture.$$$reportNull$$$0(9);
        }
        LookupImpl lookup2 = this.getLookup();
        Assert.assertNotNull((String)"No lookup is shown", (Object)lookup2);
        JList list2 = lookup2.getList();
        List<String> strings = this.getLookupElementStrings();
        Assert.assertNotNull(strings);
        List<String> actual = ContainerUtil.getFirstItems(strings, expected.length);
        if (!actual.equals(Arrays.asList(expected))) {
            UsefulTestCase.assertOrderedEquals(DumpLookupElementWeights.getLookupElementWeights(lookup2, false), expected);
        }
        if (selected2 != list2.getSelectedIndex()) {
            System.out.println(DumpLookupElementWeights.getLookupElementWeights(lookup2, false));
        }
        Assert.assertEquals((long)selected2, (long)list2.getSelectedIndex());
    }

    public void finishLookup(char completionChar) {
        Runnable command = () -> {
            LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
            Assert.assertNotNull((Object)lookup2);
            lookup2.finishLookup(completionChar);
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, command, null, null, this.myEditor.getDocument());
    }

    public PsiElement getElementAtCaret() {
        int findTargetFlags;
        Editor editor = this.getCompletionEditor();
        PsiElement element2 = TargetElementUtil.findTargetElement(editor, findTargetFlags = 3);
        if (element2 == null && editor instanceof EditorWindow) {
            element2 = TargetElementUtil.findTargetElement(((EditorWindow)editor).getDelegate(), findTargetFlags);
        }
        if (element2 == null) {
            Assert.fail((String)("element not found in file " + this.myFile.getName() + " at caret position offset " + this.myEditor.getCaretModel().getOffset() + ", psi structure:\n" + DebugUtil.psiToString(this.getFile(), true, true)));
        }
        return element2;
    }

    public <T extends PsiElement> T findElementByText(@NotNull String text2, @NotNull Class<T> elementClass) {
        if (text2 == null) {
            EditorTestFixture.$$$reportNull$$$0(10);
        }
        if (elementClass == null) {
            EditorTestFixture.$$$reportNull$$$0(11);
        }
        Document document = PsiDocumentManager.getInstance(this.myProject).getDocument(this.getFile());
        Assert.assertNotNull((Object)document);
        int pos = document.getText().indexOf(text2);
        Assert.assertTrue((String)text2, (pos >= 0 ? 1 : 0) != 0);
        return PsiTreeUtil.getParentOfType(this.getFile().findElementAt(pos), elementClass);
    }

    @NotNull
    public List<IntentionAction> getAllQuickFixes() {
        List<HighlightInfo> infos = this.doHighlighting();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (HighlightInfo info : infos) {
            if (info.quickFixActionRanges == null) continue;
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                actions.add(pair.getFirst().getAction());
            }
        }
        ArrayList<IntentionAction> arrayList = actions;
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public List<Crumb> getBreadcrumbsAtCaret() {
        FileBreadcrumbsCollector breadcrumbsCollector = FileBreadcrumbsCollector.findBreadcrumbsCollector(this.myProject, this.myFile);
        ArrayList<Crumb> arrayList = ContainerUtil.newArrayList(breadcrumbsCollector.computeCrumbs(this.myFile, this.myEditor.getDocument(), this.myEditor.getCaretModel().getOffset(), true));
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/EditorTestFixture";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/EditorTestFixture";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "completeBasicAllCarets";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllQuickFixes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreadcrumbsAtCaret";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performEditorAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertPreferredCompletionItems";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

