/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestFixture;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class BaseFixture
implements IdeaTestFixture {
    private boolean myInitialized;
    private boolean myDisposed;
    private final Disposable myTestRootDisposable = Disposer.newDisposable();
    private List<Throwable> mySuppressedExceptions;

    @Override
    public void setUp() throws Exception {
        Assert.assertFalse((String)"setUp() already has been called", (boolean)this.myInitialized);
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        this.myInitialized = true;
    }

    @Override
    public void tearDown() throws Exception {
        if (!this.myInitialized) {
            return;
        }
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        new RunAll(() -> UsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS), () -> this.disposeRootDisposable()).run(ObjectUtils.notNull(this.mySuppressedExceptions, ContainerUtil.emptyList()));
        this.myDisposed = true;
        this.resetClassFields(this.getClass());
    }

    protected void disposeRootDisposable() {
        EdtTestUtil.runInEdtAndWait(() -> {
            if (!Disposer.isDisposed(this.myTestRootDisposable)) {
                Disposer.dispose(this.myTestRootDisposable);
            }
        });
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields(this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass != BaseFixture.class) {
            this.resetClassFields(aClass.getSuperclass());
        }
    }

    @NotNull
    public final Disposable getTestRootDisposable() {
        Disposable disposable2 = this.myTestRootDisposable;
        if (disposable2 == null) {
            BaseFixture.$$$reportNull$$$0(0);
        }
        return disposable2;
    }

    protected void addSuppressedException(@NotNull Throwable e) {
        List<Throwable> list2;
        if (e == null) {
            BaseFixture.$$$reportNull$$$0(1);
        }
        if ((list2 = this.mySuppressedExceptions) == null) {
            this.mySuppressedExceptions = list2 = new SmartList<Throwable>();
        }
        list2.add(e);
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/BaseFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/BaseFixture";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSuppressedException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

