/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class TempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private Path myTempDir;

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        if (dataDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(0);
        }
        if (targetDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile2 = this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
        if (virtualFile2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(2);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir, @NotNull VirtualFileFilter filter2) {
        if (dataDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(3);
        }
        if (targetDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(4);
        }
        if (filter2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(5);
        }
        this.createTempDirectory();
        VirtualFile virtualFile2 = WriteAction.computeAndWait(() -> {
            try {
                VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myTempDir.toString());
                Assert.assertNotNull((Object)tempDir);
                if (!targetDir.isEmpty()) {
                    Assert.assertFalse((String)"nested directories not implemented", (boolean)targetDir.contains("/"));
                    VirtualFile child2 = tempDir.findChild(targetDir);
                    if (child2 == null) {
                        child2 = tempDir.createChildDirectory(this, targetDir);
                    }
                    tempDir = child2;
                }
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                Assert.assertNotNull((String)(dataDir + " not found"), (Object)from);
                VfsUtil.copyDirectory(null, from, tempDir, filter2);
                return tempDir;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (virtualFile2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(6);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string = this.createTempDirectory().toString();
        if (string == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public Path createTempFile(@NotNull String path2) throws IOException {
        String prefix;
        if (path2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(8);
        }
        if ((prefix = StringUtil.getPackageName(path2)).length() < 3) {
            prefix = prefix + "___";
        }
        String suffix = "." + StringUtil.getShortName(path2);
        Path file2 = FileUtil.createTempFile(new File(this.getTempDirPath()), prefix, suffix, true).toPath();
        VfsRootAccess.allowRootAccess(this.getTestRootDisposable(), file2.toString());
        return file2;
    }

    @Override
    public VirtualFile getFile(@NotNull String path2) {
        if (path2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(9);
        }
        String fullPath = this.myTempDir.toString() + '/' + path2;
        VfsRootAccess.allowRootAccess(this.getTestRootDisposable(), fullPath);
        return WriteAction.computeAndWait(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath));
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name) {
        Path file2;
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(10);
        }
        try {
            file2 = TempDirTestFixtureImpl.createEmptyTempFile(this.createTempDirectory(), name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VfsRootAccess.allowRootAccess(this.getTestRootDisposable(), file2.toString());
        VirtualFile virtualFile2 = WriteAction.computeAndWait(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName(file2.toString())));
        if (virtualFile2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(11);
        }
        return virtualFile2;
    }

    @NotNull
    public static Path createEmptyTempFile(@NotNull Path parent, @NotNull String name) throws IOException {
        if (parent == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(12);
        }
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(13);
        }
        Path file2 = TempDirTestFixtureImpl.resolvePath(parent, name);
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        Files.newByteChannel(file2, StandardOpenOption.CREATE, StandardOpenOption.WRITE).close();
        Path path2 = file2;
        if (path2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(14);
        }
        return path2;
    }

    @NotNull
    private static Path resolvePath(@NotNull Path parent, @NotNull String name) {
        if (parent == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(15);
        }
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(16);
        }
        Path path2 = parent.resolve(name.startsWith("/") ? name.substring(1) : name).normalize();
        if (path2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(17);
        }
        return path2;
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String name) throws IOException {
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(18);
        }
        String path2 = TempDirTestFixtureImpl.resolvePath(this.createTempDirectory(), name).toString();
        VfsRootAccess.allowRootAccess(this.getTestRootDisposable(), path2);
        VirtualFile virtualFile2 = VfsUtil.createDirectories(path2);
        if (virtualFile2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(19);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name, @NotNull String text2) throws IOException {
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(21);
        }
        VirtualFile file2 = this.createFile(name);
        WriteAction.runAndWait(() -> VfsUtil.saveText(file2, text2));
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(22);
        }
        return virtualFile2;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.myTempDir == null) {
            return;
        }
        try {
            VirtualFile virtualFile2;
            if (this.deleteOnTearDown() && (virtualFile2 = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName(this.myTempDir.toString()))) != null) {
                WriteAction.runAndWait(() -> virtualFile2.delete(this));
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected boolean deleteOnTearDown() {
        return true;
    }

    @Nullable
    protected Path getTempHome() {
        return null;
    }

    @NotNull
    private Path createTempDirectory() {
        if (this.myTempDir == null) {
            this.myTempDir = this.doCreateTempDirectory();
        }
        Path path2 = this.myTempDir;
        if (path2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(23);
        }
        return path2;
    }

    @NotNull
    protected Path doCreateTempDirectory() {
        Path path2;
        try {
            Path tempHome = this.getTempHome();
            if (tempHome != null && !Files.isDirectory(tempHome, new LinkOption[0])) {
                Files.createDirectory(tempHome, new FileAttribute[0]);
            }
            path2 = Files.createTempDirectory(tempHome == null ? Paths.get(FileUtil.getTempDirectory(), new String[0]) : tempHome, "unitTest", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create temp dir", e);
        }
        if (path2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(24);
        }
        return path2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDir";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirPath";
                break;
            }
            case 11: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTempFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateDir";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateTempDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyAll";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 10: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyTempFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

