/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LexerTestCase;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.DeleteRange;
import com.intellij.testFramework.propertyBased.InsertString;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.junit.Assert;

public class CheckHighlighterConsistency
extends ActionOnFile {
    @NotNull
    public static final Function<PsiFile, Generator<? extends MadTestingAction>> randomEditsWithHighlighterChecks = file2 -> {
        FileEditorManager.getInstance(file2.getProject()).openFile(file2.getVirtualFile(), true);
        return Generator.sampledFrom((Object[])new ActionOnFile[]{new CheckHighlighterConsistency((PsiFile)file2), new InsertString((PsiFile)file2), new DeleteRange((PsiFile)file2)});
    };

    public CheckHighlighterConsistency(@NotNull PsiFile file2) {
        if (file2 == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(0);
        }
        super(file2);
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(1);
        }
        env.logMessage(this.toString());
        Editor editor = FileEditorManager.getInstance(this.getProject()).getSelectedTextEditor();
        assert (editor.getDocument() == this.getDocument());
        CheckHighlighterConsistency.performCheck(editor);
    }

    public static void performCheck(@NotNull Editor editor) {
        if (editor == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(2);
        }
        LexerEditorHighlighter highlighter = (LexerEditorHighlighter)((EditorEx)editor).getHighlighter();
        CharSequence text2 = editor.getDocument().getImmutableCharSequence();
        String incremental = CheckHighlighterConsistency.dumpHighlighterTokens(highlighter, text2);
        highlighter.setText("");
        highlighter.setText(text2);
        String full = CheckHighlighterConsistency.dumpHighlighterTokens(highlighter, text2);
        if (!full.equals(incremental)) {
            Assert.assertEquals((Object)("Full lexer highlighter:\n" + full), (Object)("Incremental lexer highlighter:\n" + incremental));
        }
    }

    @NotNull
    private static String dumpHighlighterTokens(LexerEditorHighlighter highlighter, CharSequence text2) {
        StringBuilder tokens = new StringBuilder();
        HighlighterIterator iterator2 = highlighter.createIterator(0);
        while (!iterator2.atEnd()) {
            tokens.append(iterator2.getStart()).append(" ").append(LexerTestCase.printSingleToken(text2, iterator2.getTokenType(), iterator2.getStart(), iterator2.getEnd()));
            iterator2.advance();
        }
        String string = tokens.toString();
        if (string == null) {
            CheckHighlighterConsistency.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/propertyBased/CheckHighlighterConsistency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/propertyBased/CheckHighlighterConsistency";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpHighlighterTokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performCheck";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

