/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.fixtures.TestLookupElementPresentation;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.CompletionPolicy;
import com.intellij.testFramework.propertyBased.InvokeIntention;
import com.intellij.testFramework.propertyBased.MadTestingUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;

public class InvokeCompletion
extends ActionOnFile {
    private static final Logger LOG = Logger.getInstance(InvokeCompletion.class);
    private final CompletionPolicy myPolicy;

    public InvokeCompletion(@NotNull PsiFile file2, @NotNull CompletionPolicy policy) {
        if (file2 == null) {
            InvokeCompletion.$$$reportNull$$$0(0);
        }
        if (policy == null) {
            InvokeCompletion.$$$reportNull$$$0(1);
        }
        super(file2);
        this.myPolicy = policy;
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            InvokeCompletion.$$$reportNull$$$0(2);
        }
        int offset = this.generateDocOffset(env, "Invoke basic completion at offset %s");
        String selectionCharacters = this.myPolicy.getPossibleSelectionCharacters();
        char c = selectionCharacters.charAt((Integer)env.generateValue(Generator.integers((int)0, (int)(selectionCharacters.length() - 1)), null));
        this.performActionAt(offset, c, env);
    }

    private void performActionAt(int offset, char completionChar, ImperativeCommand.Environment env) {
        Project project2 = this.getProject();
        Editor editor = FileEditorManager.getInstance(project2).openTextEditor(new OpenFileDescriptor(project2, this.getVirtualFile(), 0), true);
        assert (editor != null);
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        editor.getCaretModel().moveToOffset(offset);
        CharSequence textBefore = editor.getDocument().getImmutableCharSequence();
        MadTestingUtil.restrictChangesToDocument(editor.getDocument(), () -> {
            Disposable raiseCompletionLimit = Disposer.newDisposable();
            Registry.get("ide.completion.variant.limit").setValue(100000, raiseCompletionLimit);
            try {
                PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
                Editor caretEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, this.getFile());
                this.performCompletion(caretEditor, Objects.requireNonNull(PsiUtilBase.getPsiFileInEditor(caretEditor, project2)), completionChar, env);
                PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
            }
            catch (Throwable e) {
                LOG.debug("Text before completion:\n" + textBefore);
                env.logMessage("Error happened, the file's text before invoking printed to the debug log, search for 'Text before completion' there");
                throw e;
            }
            finally {
                Disposer.dispose(raiseCompletionLimit);
                LookupManager.getInstance(project2).hideActiveLookup();
                UIUtil.dispatchAllInvocationEvents();
            }
        });
    }

    private void performCompletion(@NotNull Editor editor, @NotNull PsiFile file2, char completionChar, ImperativeCommand.Environment env) {
        if (editor == null) {
            InvokeCompletion.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            InvokeCompletion.$$$reportNull$$$0(4);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        PsiElement leaf = file2.findElementAt(TargetElementUtil.adjustOffset(file2, this.getDocument(), caretOffset));
        PsiReference ref = TargetElementUtil.findReference(editor);
        String expectedVariant = leaf == null || leaf instanceof PsiPlainText ? null : this.myPolicy.getExpectedVariant(editor, file2, leaf, ref);
        boolean prefixEqualsExpected = this.isPrefixEqualToExpectedVariant(caretOffset, leaf, ref, expectedVariant);
        boolean shouldCheckDuplicates = this.myPolicy.shouldCheckDuplicates(editor, file2, file2.findElementAt(caretOffset));
        long stampBefore = this.getDocument().getModificationStamp();
        new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(this.getProject(), editor);
        String notFound = ". Please either fix completion so that the variant is suggested, or, if absolutely needed, tweak CompletionPolicy to exclude it.";
        LookupEx lookup2 = LookupManager.getActiveLookup(editor);
        if (lookup2 == null) {
            if (editor.getCaretModel().getOffset() != caretOffset || this.getDocument().getModificationStamp() != stampBefore) {
                env.logMessage("Completion item was auto-inserted");
                return;
            }
            env.logMessage("No lookup");
            if (expectedVariant == null || prefixEqualsExpected || !this.checkAnnotatorErrorsAtCaret(editor, file2, env, expectedVariant)) {
                return;
            }
            TestCase.fail((String)("No lookup, but expected '" + expectedVariant + "' among completion variants" + notFound));
        }
        List<LookupElement> items = lookup2.getItems();
        if (expectedVariant != null) {
            LookupElement sameItem = (LookupElement)((Object)ContainerUtil.find(items, e -> e.getAllLookupStrings().stream().anyMatch(s -> Comparing.equal(s, expectedVariant, e.isCaseSensitive()))));
            if (sameItem == null && !this.checkAnnotatorErrorsAtCaret(editor, file2, env, expectedVariant)) {
                return;
            }
            TestCase.assertNotNull((String)("No variant '" + expectedVariant + "' among " + items + notFound), (Object)sameItem);
        }
        if (shouldCheckDuplicates) {
            InvokeCompletion.checkNoDuplicates(items);
        }
        LookupElement item = (LookupElement)env.generateValue(Generator.sampledFrom(items), null);
        env.logMessage("Select '" + item + "' with '" + StringUtil.escapeStringCharacters(String.valueOf(completionChar)) + "'");
        lookup2.setCurrentItem(item);
        if (LookupEvent.isSpecialCompletionChar(completionChar)) {
            ((LookupImpl)lookup2).finishLookup(completionChar, item);
        } else {
            EditorActionManager.getInstance();
            TypedAction.getInstance().actionPerformed(editor, completionChar, ((EditorImpl)lookup2.getTopLevelEditor()).getDataContext());
        }
    }

    private boolean checkAnnotatorErrorsAtCaret(@NotNull Editor editor, @NotNull PsiFile file2, ImperativeCommand.Environment env, String expectedVariant) {
        int caretOffset;
        List<HighlightInfo> infos;
        boolean hasErrors;
        if (editor == null) {
            InvokeCompletion.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            InvokeCompletion.$$$reportNull$$$0(6);
        }
        if (hasErrors = ContainerUtil.exists(infos = InvokeIntention.highlightErrors(this.getProject(), editor), arg_0 -> InvokeCompletion.lambda$checkAnnotatorErrorsAtCaret$3(caretOffset = editor.getCaretModel().getOffset(), arg_0))) {
            env.logMessage("Found syntax errors at the completion point, skipping expected completion check for '" + expectedVariant + "'");
            return false;
        }
        return true;
    }

    private boolean isPrefixEqualToExpectedVariant(int caretOffset, PsiElement leaf, PsiReference ref, String expectedVariant) {
        if (expectedVariant == null) {
            return false;
        }
        int expectedEnd = ref != null ? ref.getRangeInElement().getEndOffset() + ref.getElement().getTextRange().getStartOffset() : (leaf != null ? leaf.getTextRange().getEndOffset() : 0);
        return expectedEnd == caretOffset && this.getFile().getText().substring(0, caretOffset).endsWith(expectedVariant);
    }

    private static void checkNoDuplicates(List<LookupElement> items) {
        HashSet<List<Object>> presentations = new HashSet<List<Object>>();
        for (LookupElement item : items) {
            List<Object> info;
            TestLookupElementPresentation p = TestLookupElementPresentation.renderReal(item);
            if (InvokeCompletion.seemsTruncated(p.getItemText()) || InvokeCompletion.seemsTruncated(p.getTailText()) || InvokeCompletion.seemsTruncated(p.getTypeText()) || presentations.add(info = Arrays.asList(TestLookupElementPresentation.unwrapIcon(p.getIcon()), p.getItemText(), p.getItemTextForeground(), p.isItemTextBold(), p.isItemTextUnderlined(), p.getTailFragments(), p.getTypeText(), TestLookupElementPresentation.unwrapIcon(p.getTypeIcon()), p.isTypeGrayed(), p.isStrikeout()))) continue;
            TestCase.fail((String)("Duplicate suggestions: " + p));
        }
    }

    private static boolean seemsTruncated(String text2) {
        return text2 != null && text2.contains("...");
    }

    private static /* synthetic */ boolean lambda$checkAnnotatorErrorsAtCaret$3(int caretOffset, HighlightInfo i) {
        return i.getStartOffset() <= caretOffset && caretOffset <= i.getEndOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/propertyBased/InvokeCompletion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performCommand";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "performCompletion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotatorErrorsAtCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

