/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testIntegration.GotoTestOrCodeHandler;
import com.intellij.testIntegration.TestFinderHelper;
import org.jetbrains.annotations.NotNull;

public class GotoTestOrCodeAction
extends BaseCodeInsightAction {
    @Override
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new GotoTestOrCodeHandler();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        boolean useShortName;
        if (e == null) {
            GotoTestOrCodeAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(false);
        if (TestFinderHelper.getFinders().size() == 0) {
            return;
        }
        Project project2 = e.getProject();
        Editor editor = e.getData(CommonDataKeys.EDITOR);
        if (editor == null || project2 == null) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor, project2);
        if (psiFile == null) {
            return;
        }
        PsiElement element2 = GotoTestOrCodeHandler.getSelectedElement(editor, psiFile);
        if (TestFinderHelper.findSourceElement(element2) == null) {
            return;
        }
        presentation.setEnabledAndVisible(true);
        boolean bl = useShortName = "MainMenu".equals(e.getPlace()) || ActionPlaces.isPopupPlace(e.getPlace());
        if (TestFinderHelper.isTest(element2)) {
            presentation.setText(useShortName ? ActionsBundle.messagePointer("action.GotoTestSubject.MainMenu.text", new Object[0]) : ActionsBundle.messagePointer("action.GotoTestSubject.text", new Object[0]));
            presentation.setDescription(ActionsBundle.messagePointer("action.GotoTestSubject.description", new Object[0]));
        } else {
            presentation.setText(useShortName ? ActionsBundle.messagePointer("action.GotoTest.MainMenu.text", new Object[0]) : ActionsBundle.messagePointer("action.GotoTest.text", new Object[0]));
            presentation.setDescription(ActionsBundle.messagePointer("action.GotoTest.description", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/testIntegration/GotoTestOrCodeAction", "update"));
    }
}

