/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.testIntegration.TestFinder;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFinderHelper {
    public static PsiElement findSourceElement(@NotNull PsiElement from) {
        if (from == null) {
            TestFinderHelper.$$$reportNull$$$0(0);
        }
        for (TestFinder each : TestFinderHelper.getFinders()) {
            PsiElement result2 = each.findSourceElement(from);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static Collection<PsiElement> findTestsForClass(@NotNull PsiElement element2) {
        if (element2 == null) {
            TestFinderHelper.$$$reportNull$$$0(1);
        }
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (TestFinder each : TestFinderHelper.getFinders()) {
            result2.addAll(each.findTestsForClass(element2));
        }
        return result2;
    }

    public static Collection<PsiElement> findClassesForTest(@NotNull PsiElement element2) {
        if (element2 == null) {
            TestFinderHelper.$$$reportNull$$$0(2);
        }
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (TestFinder each : TestFinderHelper.getFinders()) {
            result2.addAll(each.findClassesForTest(element2));
        }
        return result2;
    }

    public static boolean isTest(PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        for (TestFinder each : TestFinderHelper.getFinders()) {
            if (!each.isTest(element2)) continue;
            return true;
        }
        return false;
    }

    public static List<TestFinder> getFinders() {
        return TestFinder.EP_NAME.getExtensionList();
    }

    public static Integer calcTestNameProximity(String className, String testName) {
        int posProximity = testName.indexOf(className);
        int sizeProximity = testName.length() - className.length();
        return posProximity + sizeProximity;
    }

    public static List<PsiElement> getSortedElements(List<? extends Pair<? extends PsiNamedElement, Integer>> elementsWithWeights, boolean weightsAscending) {
        return TestFinderHelper.getSortedElements(elementsWithWeights, weightsAscending, null);
    }

    public static List<PsiElement> getSortedElements(List<? extends Pair<? extends PsiNamedElement, Integer>> elementsWithWeights, boolean weightsAscending, @Nullable Comparator<? super PsiElement> sameNameComparator) {
        Collections.sort(elementsWithWeights, (o1, o2) -> {
            int result2;
            int n = result2 = weightsAscending ? ((Integer)o1.second).compareTo((Integer)o2.second) : ((Integer)o2.second).compareTo((Integer)o1.second);
            if (result2 == 0) {
                result2 = Comparing.compare(((PsiNamedElement)o1.first).getName(), ((PsiNamedElement)o2.first).getName());
            }
            if (result2 == 0 && sameNameComparator != null) {
                result2 = sameNameComparator.compare((PsiElement)o1.first, (PsiElement)o2.first);
            }
            return result2;
        });
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elementsWithWeights.size());
        for (Pair<? extends PsiNamedElement, Integer> pair : elementsWithWeights) {
            result2.add((PsiElement)pair.first);
        }
        return result2;
    }

    public static List<Pair<String, Integer>> collectPossibleClassNamesWithWeights(String testName) {
        String[] words = NameUtilCore.splitNameIntoWords(testName);
        ArrayList<Pair<String, Integer>> result2 = new ArrayList<Pair<String, Integer>>();
        for (int from = 0; from < words.length; ++from) {
            for (int to = from; to < words.length; ++to) {
                result2.add(new Pair<String, Integer>(StringUtil.join(words, from, to + 1, ""), words.length - from + to));
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testIntegration/TestFinderHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findTestsForClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findClassesForTest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

