/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolManager;
import com.intellij.tools.ToolsGroup;
import java.util.List;

public abstract class BaseToolKeymapExtension
implements KeymapExtension {
    @Override
    public KeymapGroup createGroup(Condition<AnAction> filtered2, Project project2) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Group rootGroup = new Group(this.getRootGroupName(), this.getRootGroupId(), AllIcons.Nodes.KeymapTools);
        List groups = ToolManager.getInstance().getGroups();
        for (ToolsGroup toolsGroup : groups) {
            String groupName = toolsGroup.getName();
            Group group = new Group(groupName, this.getGroupIdPrefix() + groupName, null);
            List<? extends Tool> tools = this.getToolsIdsByGroupName(groupName);
            for (Tool tool : tools) {
                if (filtered2 != null && !filtered2.value(actionManager.getActionOrStub(tool.getActionId()))) continue;
                group.addGroup(new Group(tool.getName(), tool.getActionId(), null));
            }
            rootGroup.addGroup(group);
        }
        return rootGroup;
    }

    protected abstract String getGroupIdPrefix();

    protected abstract String getActionIdPrefix();

    protected abstract List<? extends Tool> getToolsIdsByGroupName(String var1);

    protected abstract String getRootGroupName();

    protected abstract String getRootGroupId();
}

