/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.tools.BaseToolsPanel;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsBundle;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ToolSelectDialog
extends DialogWrapper {
    private final BaseToolsPanel myToolsPanel;

    public ToolSelectDialog(@Nullable Project project2, @Nullable String actionIdToSelect, BaseToolsPanel toolsPanel) {
        super(project2);
        this.myToolsPanel = toolsPanel;
        this.myToolsPanel.reset();
        this.init();
        this.pack();
        if (actionIdToSelect != null) {
            this.myToolsPanel.selectTool(actionIdToSelect);
        }
        this.setTitle(ToolsBundle.message("tools.dialog.title", new Object[0]));
    }

    @Override
    protected void doOKAction() {
        this.myToolsPanel.apply();
        super.doOKAction();
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.myToolsPanel;
    }

    @Nullable
    public Tool getSelectedTool() {
        return this.myToolsPanel.getSingleSelectedTool();
    }

    public boolean isModified() {
        return this.myToolsPanel.isModified();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "com.intellij.tools.ToolSelectDialog.dimensionServiceKey";
    }
}

