/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AddEditRemovePanel<T>
extends PanelWithButtons
implements ComponentWithEmptyText {
    private JBTable myTable;
    private final TableModel myModel;
    private List<T> myData;
    private AbstractTableModel myTableModel;
    private final String myLabel;

    public AddEditRemovePanel(TableModel<T> model, List<T> data2) {
        this(model, data2, null);
    }

    public AddEditRemovePanel(TableModel<T> model, List<T> data2, @Nullable String label2) {
        this.myModel = model;
        this.myData = data2;
        this.myLabel = label2;
        this.initTable();
        this.initPanel();
    }

    @Nullable
    protected abstract T addItem();

    protected abstract boolean removeItem(T var1);

    @Nullable
    protected abstract T editItem(T var1);

    public boolean isUpDownSupported() {
        return false;
    }

    @Override
    protected void initPanel() {
        this.setLayout(new BorderLayout());
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTable).setAddAction(new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton button2) {
                AddEditRemovePanel.this.doAdd();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton button2) {
                AddEditRemovePanel.this.doRemove();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton button2) {
                if (AddEditRemovePanel.this.myTable.isEditing()) {
                    AddEditRemovePanel.this.myTable.getCellEditor().stopCellEditing();
                    return;
                }
                AddEditRemovePanel.this.doEdit();
            }
        });
        if (this.isUpDownSupported()) {
            decorator.setMoveUpAction(new AnActionButtonRunnable(){

                @Override
                public void run(AnActionButton button2) {
                    AddEditRemovePanel.this.doUp();
                }
            }).setMoveDownAction(new AnActionButtonRunnable(){

                @Override
                public void run(AnActionButton button2) {
                    AddEditRemovePanel.this.doDown();
                }
            });
        } else {
            decorator.disableUpAction().disableDownAction();
        }
        JPanel panel2 = decorator.createPanel();
        this.add((Component)panel2, "Center");
        String label2 = this.getLabelText();
        if (label2 != null) {
            UIUtil.addBorder(panel2, IdeBorderFactory.createTitledBorder(label2, false, JBUI.insetsTop(8)).setShowLine(false));
        }
    }

    @Override
    protected String getLabelText() {
        return this.myLabel;
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTable.getEmptyText();
        if (statusText == null) {
            AddEditRemovePanel.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    @Override
    protected JComponent createMainComponent() {
        this.initTable();
        return ScrollPaneFactory.createScrollPane(this.myTable);
    }

    private void initTable() {
        this.myTableModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return AddEditRemovePanel.this.myModel.getColumnCount();
            }

            @Override
            public int getRowCount() {
                return AddEditRemovePanel.this.myData != null ? AddEditRemovePanel.this.myData.size() : 0;
            }

            public Class getColumnClass(int columnIndex) {
                return AddEditRemovePanel.this.myModel.getColumnClass(columnIndex);
            }

            @Override
            public String getColumnName(int column) {
                return AddEditRemovePanel.this.myModel.getColumnName(column);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return AddEditRemovePanel.this.myModel.getField(AddEditRemovePanel.this.myData.get(rowIndex), columnIndex);
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                AddEditRemovePanel.this.myModel.setValue(aValue, AddEditRemovePanel.this.myData.get(rowIndex), columnIndex);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return AddEditRemovePanel.this.myModel.isEditable(columnIndex);
            }
        };
        this.myTable = this.createTable();
        this.myTable.setModel(this.myTableModel);
        this.myTable.setShowColumns(false);
        this.myTable.setSelectionMode(2);
        this.myTable.setStriped(true);
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent event) {
                AddEditRemovePanel.this.doEdit();
                return true;
            }
        }.installOn(this.myTable);
    }

    protected JBTable createTable() {
        return new JBTable();
    }

    @Override
    protected JButton[] createButtons() {
        return new JButton[0];
    }

    protected void doAdd() {
        T o = this.addItem();
        if (o == null) {
            return;
        }
        this.myData.add(o);
        int index = this.myData.size() - 1;
        this.myTableModel.fireTableRowsInserted(index, index);
        this.myTable.setRowSelectionInterval(index, index);
    }

    protected void doEdit() {
        int selected2 = this.myTable.getSelectedRow();
        if (selected2 >= 0) {
            T o = this.editItem(this.myData.get(selected2));
            if (o != null) {
                this.myData.set(selected2, o);
            }
            this.myTableModel.fireTableRowsUpdated(selected2, selected2);
        }
    }

    protected void doRemove() {
        int[] selected2;
        if (this.myTable.isEditing()) {
            this.myTable.getCellEditor().stopCellEditing();
        }
        if ((selected2 = this.myTable.getSelectedRows()) == null || selected2.length == 0) {
            return;
        }
        Arrays.sort(selected2);
        for (int i = selected2.length - 1; i >= 0; --i) {
            int idx = selected2[i];
            if (!this.removeItem(this.myData.get(idx))) continue;
            this.myData.remove(idx);
        }
        this.myTableModel.fireTableDataChanged();
        int selection = selected2[0];
        if (selection >= this.myData.size()) {
            selection = this.myData.size() - 1;
        }
        if (selection >= 0) {
            this.myTable.setRowSelectionInterval(selection, selection);
        }
    }

    protected void doUp() {
        TableUtil.moveSelectedItemsUp(this.myTable);
    }

    protected void doDown() {
        TableUtil.moveSelectedItemsDown(this.myTable);
    }

    public void setData(List<T> data2) {
        this.myData = data2;
        this.myTableModel.fireTableDataChanged();
    }

    public List<T> getData() {
        return this.myData;
    }

    public void setRenderer(int index, TableCellRenderer renderer) {
        this.myTable.getColumn(this.myModel.getColumnName(index)).setCellRenderer(renderer);
    }

    public void setSelected(Object o) {
        for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
            if (!this.myData.get(i).equals(o)) continue;
            this.myTable.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    public JBTable getTable() {
        return this.myTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AddEditRemovePanel", "getEmptyText"));
    }

    public static abstract class TableModel<T> {
        public abstract int getColumnCount();

        @Nullable
        public abstract String getColumnName(int var1);

        public abstract Object getField(T var1, int var2);

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public boolean isEditable(int column) {
            return false;
        }

        public void setValue(Object aValue, T data2, int columnIndex) {
        }
    }
}

