/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.application.Topics;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.PopupLocationTracker;
import com.intellij.ide.ui.ScreenAreaConsumer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.impl.ShadowBorderPainter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.WeakFocusStackManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.jcef.HwFacadeJPanel;
import com.intellij.ui.jcef.HwFacadeNonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BalloonImpl
implements Balloon,
IdeTooltip.Ui,
ScreenAreaConsumer {
    private static final Logger LOG = Logger.getInstance(BalloonImpl.class);
    public static final Key<Boolean> FORCED_NO_SHADOW = Key.create("BALLOON_FORCED_NO_SHADOW");
    private static final JBValue DIALOG_ARC = new JBValue.Float(6.0f);
    public static final JBValue ARC = new JBValue.Float(3.0f);
    private static final JBValue DIALOG_TOPBOTTOM_POINTER_WIDTH = new JBValue.Float(24.0f);
    public static final JBValue DIALOG_POINTER_WIDTH = new JBValue.Float(17.0f);
    private static final JBValue TOPBOTTOM_POINTER_WIDTH = new JBValue.Float(14.0f);
    private static final JBValue POINTER_WIDTH = new JBValue.Float(11.0f);
    private static final JBValue DIALOG_TOPBOTTOM_POINTER_LENGTH = new JBValue.Float(16.0f);
    private static final JBValue DIALOG_POINTER_LENGTH = new JBValue.Float(14.0f);
    private static final JBValue TOPBOTTOM_POINTER_LENGTH = new JBValue.Float(10.0f);
    public static final JBValue POINTER_LENGTH = new JBValue.Float(8.0f);
    private static final JBValue BORDER_STROKE_WIDTH = new JBValue.Float(1.0f);
    private final Alarm myFadeoutAlarm;
    private long myFadeoutRequestMillis;
    private int myFadeoutRequestDelay;
    private boolean mySmartFadeout;
    private boolean mySmartFadeoutPaused;
    private int mySmartFadeoutDelay;
    private MyComponent myComp;
    private JLayeredPane myLayeredPane;
    private AbstractPosition myPosition;
    private Point myTargetPoint;
    private final boolean myHideOnFrameResize;
    private final boolean myHideOnLinkClick;
    private final Color myBorderColor;
    private final Insets myBorderInsets;
    private Color myFillColor;
    private Color myPointerColor;
    private final Insets myContainerInsets;
    private boolean myLastMoveWasInsideBalloon;
    private Rectangle myForcedBounds;
    private ActionProvider myActionProvider;
    private List<ActionButton> myActionButtons;
    private final AWTEventListener myAwtActivityListener;
    private final long myFadeoutTime;
    private Dimension myDefaultPrefSize;
    private final ActionListener myClickHandler;
    private final boolean myCloseOnClick;
    private final int myShadowSize;
    private ShadowBorderProvider myShadowBorderProvider;
    private final Collection<JBPopupListener> myListeners;
    private boolean myVisible;
    private PositionTracker<Balloon> myTracker;
    private final int myAnimationCycle;
    private boolean myFadedIn;
    private boolean myFadedOut;
    private final int myCalloutShift;
    private final int myPositionChangeXShift;
    private final int myPositionChangeYShift;
    private boolean myDialogMode;
    private IdeFocusManager myFocusManager;
    private final String myTitle;
    private JLabel myTitleLabel;
    private boolean myAnimationEnabled;
    private final boolean myShadow;
    private final Balloon.Layer myLayer;
    private final boolean myBlockClicks;
    private RelativePoint myPrevMousePoint;
    private final ComponentAdapter myComponentListener;
    private Animator myAnimator;
    private boolean myShowPointer;
    private boolean myDisposed;
    private final JComponent myContent;
    private boolean myHideOnMouse;
    private Runnable myHideListener;
    private final boolean myHideOnKey;
    private final boolean myHideOnAction;
    private final boolean myHideOnCloseClick;
    private final boolean myRequestFocus;
    private Component myOriginalFocusOwner;
    private final boolean myEnableButtons;
    private final Dimension myPointerSize;
    private final int myCornerToPointerDistance;
    public static final AbstractPosition BELOW = new Below();
    public static final AbstractPosition ABOVE = new Above();
    public static final AbstractPosition AT_RIGHT = new AtRight();
    public static final AbstractPosition AT_LEFT = new AtLeft();

    private boolean isWithinChildWindow(@NotNull MouseEvent event) {
        Container child2;
        Window owner;
        if (event == null) {
            BalloonImpl.$$$reportNull$$$0(0);
        }
        if ((owner = ComponentUtil.getWindow(this.myContent)) != null && (child2 = ComponentUtil.getWindow(event.getComponent())) != owner) {
            while (child2 != null) {
                if (child2 == owner) {
                    return true;
                }
                child2 = child2.getParent();
            }
        }
        return false;
    }

    public void setFillColor(Color fillColor) {
        this.myFillColor = fillColor;
    }

    public Color getPointerColor() {
        return this.myPointerColor;
    }

    public void setPointerColor(Color pointerColor) {
        this.myPointerColor = pointerColor;
    }

    private boolean isInsideBalloon(@NotNull MouseEvent me) {
        if (me == null) {
            BalloonImpl.$$$reportNull$$$0(1);
        }
        return this.isInside(new RelativePoint(me));
    }

    @Override
    public boolean isInside(@NotNull RelativePoint target2) {
        if (target2 == null) {
            BalloonImpl.$$$reportNull$$$0(2);
        }
        if (this.myComp == null) {
            return false;
        }
        Component cmp = target2.getOriginalComponent();
        if (!cmp.isShowing()) {
            return true;
        }
        if (cmp instanceof MenuElement) {
            return false;
        }
        if (this.myActionButtons != null) {
            for (ActionButton button2 : this.myActionButtons) {
                if (cmp != button2) continue;
                return true;
            }
        }
        if (UIUtil.isDescendingFrom(cmp, this.myComp)) {
            return true;
        }
        if (this.myComp == null || !this.myComp.isShowing()) {
            return false;
        }
        Point point = target2.getScreenPoint();
        SwingUtilities.convertPointFromScreen(point, this.myComp);
        return this.myComp.contains(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMovingForward(@NotNull RelativePoint target2) {
        if (target2 == null) {
            BalloonImpl.$$$reportNull$$$0(3);
        }
        try {
            if (this.myComp == null || !this.myComp.isShowing()) {
                boolean bl = false;
                return bl;
            }
            if (this.myPrevMousePoint == null) {
                boolean bl = true;
                return bl;
            }
            if (this.myPrevMousePoint.getComponent() != target2.getComponent()) {
                boolean bl = false;
                return bl;
            }
            Rectangle rectangleOnScreen = new Rectangle(this.myComp.getLocationOnScreen(), this.myComp.getSize());
            boolean bl = ScreenUtil.isMovementTowards(this.myPrevMousePoint.getScreenPoint(), target2.getScreenPoint(), rectangleOnScreen);
            return bl;
        }
        finally {
            this.myPrevMousePoint = target2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public BalloonImpl(@NotNull JComponent content2, @NotNull Color borderColor, Insets borderInsets, @NotNull Color fillColor, boolean hideOnMouse, boolean hideOnKey, boolean hideOnAction, boolean hideOnCloseClick, boolean showPointer, boolean enableButtons, long fadeoutTime, boolean hideOnFrameResize, boolean hideOnLinkClick, ActionListener clickHandler, boolean closeOnClick, int animationCycle, int calloutShift, int positionChangeXShift, int positionChangeYShift, boolean dialogMode, String title, Insets contentInsets, boolean shadow, boolean smallVariant, boolean blockClicks, Balloon.Layer layer, boolean requestFocus, Dimension pointerSize, int n) {
        void cornerToPointerDistance;
        if (content2 == null) {
            BalloonImpl.$$$reportNull$$$0(4);
        }
        if (borderColor == null) {
            BalloonImpl.$$$reportNull$$$0(5);
        }
        if (fillColor == null) {
            BalloonImpl.$$$reportNull$$$0(6);
        }
        this.myFadeoutAlarm = new Alarm(this);
        this.myAwtActivityListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                if (BalloonImpl.this.mySmartFadeoutDelay > 0) {
                    BalloonImpl.this.startFadeoutTimer(BalloonImpl.this.mySmartFadeoutDelay);
                    BalloonImpl.this.mySmartFadeoutDelay = 0;
                }
                int id2 = e.getID();
                if (e instanceof MouseEvent) {
                    boolean forcedExit;
                    MouseEvent me = (MouseEvent)e;
                    boolean insideBalloon = BalloonImpl.this.isInsideBalloon(me);
                    boolean bl = forcedExit = id2 == 505 && me.getButton() != 0 && !BalloonImpl.this.myBlockClicks;
                    if (BalloonImpl.this.myHideOnMouse && (id2 == 501 || forcedExit)) {
                        if (!(insideBalloon && !forcedExit || BalloonImpl.this.isWithinChildWindow(me))) {
                            if (BalloonImpl.this.myHideListener == null) {
                                BalloonImpl.this.hide();
                                if (forcedExit) {
                                    int[] ids;
                                    for (int id_ : ids = new int[]{504, 501, 502, 500}) {
                                        IdeEventQueue.getInstance().dispatchEvent(new MouseEvent(me.getComponent(), id_, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton()));
                                    }
                                }
                            } else {
                                BalloonImpl.this.myHideListener.run();
                            }
                        }
                        return;
                    }
                    if (BalloonImpl.this.myClickHandler != null && id2 == 500 && !(me.getComponent() instanceof CloseButton) && insideBalloon) {
                        BalloonImpl.this.myClickHandler.actionPerformed(new ActionEvent(me, 1001, "click", me.getModifiersEx()));
                        if (BalloonImpl.this.myCloseOnClick) {
                            BalloonImpl.this.hide();
                            return;
                        }
                    }
                    if (BalloonImpl.this.myEnableButtons && id2 == 503) {
                        boolean moveChanged = insideBalloon != BalloonImpl.this.myLastMoveWasInsideBalloon;
                        BalloonImpl.this.myLastMoveWasInsideBalloon = insideBalloon;
                        if (moveChanged) {
                            if (insideBalloon && !BalloonImpl.this.myFadeoutAlarm.isEmpty()) {
                                BalloonImpl.this.myFadeoutAlarm.cancelAllRequests();
                                BalloonImpl.this.myFadeoutRequestDelay = (int)((long)BalloonImpl.this.myFadeoutRequestDelay - (System.currentTimeMillis() - BalloonImpl.this.myFadeoutRequestMillis));
                            }
                            if (!insideBalloon && BalloonImpl.this.myFadeoutRequestDelay > 0) {
                                BalloonImpl.this.startFadeoutTimer(BalloonImpl.this.myFadeoutRequestDelay);
                            }
                            BalloonImpl.this.myComp.repaintButton();
                        }
                    }
                    if (BalloonImpl.this.myHideOnCloseClick && UIUtil.isCloseClick(me)) {
                        if (BalloonImpl.this.isInsideBalloon(me)) {
                            BalloonImpl.this.hide();
                            me.consume();
                        }
                        return;
                    }
                }
                if ((BalloonImpl.this.myHideOnKey || BalloonImpl.this.myHideListener != null) && e instanceof KeyEvent && id2 == 401) {
                    KeyEvent ke = (KeyEvent)e;
                    if (BalloonImpl.this.myHideListener != null) {
                        if (ke.getKeyCode() == 27) {
                            BalloonImpl.this.myHideListener.run();
                        }
                        return;
                    }
                    if (ke.getKeyCode() != 16 && ke.getKeyCode() != 17 && ke.getKeyCode() != 18 && ke.getKeyCode() != 157) {
                        boolean doHide = false;
                        if (ke.getKeyCode() == 27 && SwingUtilities.isDescendingFrom(ke.getComponent(), BalloonImpl.this.myComp)) {
                            doHide = true;
                        }
                        if (BalloonImpl.this.myHideOnKey && !SwingUtilities.isDescendingFrom(ke.getComponent(), BalloonImpl.this.myComp)) {
                            doHide = true;
                        }
                        if (doHide) {
                            BalloonImpl.this.hide();
                        }
                    }
                }
            }
        };
        this.myListeners = new CopyOnWriteArraySet<JBPopupListener>();
        this.myAnimationEnabled = true;
        this.myComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (BalloonImpl.this.myHideOnFrameResize) {
                    BalloonImpl.this.hide();
                }
            }
        };
        this.myBorderColor = borderColor;
        this.myBorderInsets = borderInsets != null ? borderInsets : JBInsets.create(5, 8);
        this.myFillColor = fillColor;
        this.myContent = content2;
        this.myHideOnMouse = hideOnMouse;
        this.myHideOnKey = hideOnKey;
        this.myHideOnAction = hideOnAction;
        this.myHideOnCloseClick = hideOnCloseClick;
        this.myShowPointer = showPointer;
        this.myEnableButtons = enableButtons;
        this.myHideOnFrameResize = hideOnFrameResize;
        this.myHideOnLinkClick = hideOnLinkClick;
        this.myClickHandler = clickHandler;
        this.myCloseOnClick = closeOnClick;
        this.myCalloutShift = calloutShift;
        this.myPositionChangeXShift = positionChangeXShift;
        this.myPositionChangeYShift = positionChangeYShift;
        this.myDialogMode = dialogMode;
        this.myTitle = title;
        this.myLayer = layer != null ? layer : Balloon.Layer.normal;
        this.myBlockClicks = blockClicks;
        this.myRequestFocus = requestFocus;
        MnemonicHelper.init(content2);
        if (!this.myDialogMode) {
            for (Component component2 : UIUtil.uiTraverser(this.myContent)) {
                JCheckBox checkBox2;
                if (component2 instanceof JLabel) {
                    JLabel label2 = (JLabel)component2;
                    if (label2.getDisplayedMnemonic() == 0 && label2.getDisplayedMnemonicIndex() < 0) continue;
                    this.myDialogMode = true;
                    break;
                }
                if (!(component2 instanceof JCheckBox) || (checkBox2 = (JCheckBox)component2).getMnemonic() < 0 && checkBox2.getDisplayedMnemonicIndex() < 0) continue;
                this.myDialogMode = true;
                break;
            }
        }
        this.myShadow = shadow;
        this.myShadowSize = Registry.intValue("ide.balloon.shadow.size");
        this.myContainerInsets = contentInsets;
        this.myFadeoutTime = fadeoutTime;
        this.myAnimationCycle = animationCycle;
        this.myPointerSize = pointerSize;
        this.myCornerToPointerDistance = cornerToPointerDistance;
        if (smallVariant) {
            for (Component component2 : UIUtil.uiTraverser(this.myContent)) {
                UIUtil.applyStyle(UIUtil.ComponentStyle.SMALL, component2);
            }
        }
    }

    @Override
    public void show(RelativePoint target2, Balloon.Position position) {
        this.show(target2, BalloonImpl.getAbstractPositionFor(position));
    }

    public int getLayer() {
        Integer result2 = JLayeredPane.DEFAULT_LAYER;
        switch (this.myLayer) {
            case normal: {
                result2 = JLayeredPane.POPUP_LAYER;
                break;
            }
            case top: {
                result2 = JLayeredPane.DRAG_LAYER;
            }
        }
        return result2;
    }

    private static AbstractPosition getAbstractPositionFor(@NotNull Balloon.Position position) {
        if (position == null) {
            BalloonImpl.$$$reportNull$$$0(7);
        }
        switch (position) {
            case atLeft: {
                return AT_LEFT;
            }
            case atRight: {
                return AT_RIGHT;
            }
            case above: {
                return ABOVE;
            }
        }
        return BELOW;
    }

    @Override
    public void show(PositionTracker<Balloon> tracker, Balloon.Position position) {
        this.show(tracker, BalloonImpl.getAbstractPositionFor(position));
    }

    private Insets getInsetsCopy() {
        return JBUI.insets(this.myBorderInsets);
    }

    private void show(RelativePoint target2, AbstractPosition position) {
        this.show(new PositionTracker.Static<Balloon>(target2), position);
    }

    private void show(PositionTracker<Balloon> tracker, AbstractPosition position) {
        JEditorPane editorPane;
        Rectangle rec;
        boolean mnemonicsFix;
        assert (!this.myDisposed) : "Balloon is already disposed";
        if (this.isVisible()) {
            return;
        }
        Component comp = tracker.getComponent();
        if (!comp.isShowing()) {
            return;
        }
        this.myTracker = tracker;
        this.myTracker.init(this);
        JRootPane root = Objects.requireNonNull(UIUtil.getRootPane(comp));
        this.myVisible = true;
        this.myLayeredPane = root.getLayeredPane();
        this.myPosition = position;
        UIUtil.setFutureRootPane(this.myContent, root);
        this.myFocusManager = IdeFocusManager.findInstanceByComponent(this.myLayeredPane);
        final Ref originalFocusOwner = new Ref();
        Ref<ActionCallback> proxyFocusRequest = new Ref<ActionCallback>(ActionCallback.DONE);
        boolean bl = mnemonicsFix = this.myDialogMode && SystemInfo.isMac && Registry.is("ide.mac.inplaceDialogMnemonicsFix");
        if (mnemonicsFix) {
            proxyFocusRequest.set(new ActionCallback());
            this.myFocusManager.doWhenFocusSettlesDown(new ExpirableRunnable(){

                @Override
                public boolean isExpired() {
                    return BalloonImpl.this.isDisposed();
                }

                @Override
                public void run() {
                    IdeEventQueue.getInstance().disableInputMethods(BalloonImpl.this);
                    originalFocusOwner.set(BalloonImpl.this.myFocusManager.getFocusOwner());
                }
            });
        }
        this.myLayeredPane.addComponentListener(this.myComponentListener);
        this.myTargetPoint = this.myPosition.getShiftedPoint(this.myTracker.recalculateLocation(this).getPoint(this.myLayeredPane), this.myCalloutShift);
        if (this.myDisposed) {
            return;
        }
        int positionChangeFix = 0;
        if (this.myShowPointer && !this.myPosition.isOkToHavePointer(this.myTargetPoint, rec = this.getRecForPosition(this.myPosition, true), this.getPointerLength(this.myPosition), this.getPointerWidth(this.myPosition), this.getArc())) {
            rec = this.getRecForPosition(this.myPosition, false);
            Rectangle lp = new Rectangle(new Point(this.myContainerInsets.left, this.myContainerInsets.top), this.myLayeredPane.getSize());
            lp.width -= this.myContainerInsets.right;
            lp.height -= this.myContainerInsets.bottom;
            if (!lp.contains(rec) || !PopupLocationTracker.canRectangleBeUsed(this.myLayeredPane, rec, this)) {
                Rectangle2D currentSquare = lp.createIntersection(rec);
                double maxSquare = currentSquare.getWidth() * currentSquare.getHeight();
                AbstractPosition targetPosition = this.myPosition;
                for (AbstractPosition eachPosition : this.myPosition.getOtherPositions()) {
                    Rectangle2D eachIntersection = lp.createIntersection(this.getRecForPosition(eachPosition, false));
                    double eachSquare = eachIntersection.getWidth() * eachIntersection.getHeight();
                    if (!(maxSquare < eachSquare)) continue;
                    maxSquare = eachSquare;
                    targetPosition = eachPosition;
                }
                this.myPosition = targetPosition;
                positionChangeFix = this.myPosition.getChangeShift(position, this.myPositionChangeXShift, this.myPositionChangeYShift);
            }
        }
        if (this.myPosition != position) {
            this.myTargetPoint = this.myPosition.getShiftedPoint(this.myTracker.recalculateLocation(this).getPoint(this.myLayeredPane), this.myCalloutShift > 0 ? this.myCalloutShift + positionChangeFix : positionChangeFix);
            position = this.myPosition;
        }
        this.createComponent();
        Rectangle r = this.getRecForPosition(this.myPosition, false);
        Point location2 = r.getLocation();
        SwingUtilities.convertPointToScreen(location2, this.myLayeredPane);
        r.setLocation(location2);
        if (!PopupLocationTracker.canRectangleBeUsed(this.myLayeredPane, r, this)) {
            for (AbstractPosition eachPosition : this.myPosition.getOtherPositions()) {
                r = this.getRecForPosition(eachPosition, false);
                location2 = r.getLocation();
                SwingUtilities.convertPointToScreen(location2, this.myLayeredPane);
                r.setLocation(location2);
                if (!PopupLocationTracker.canRectangleBeUsed(this.myLayeredPane, r, this)) continue;
                this.myPosition = eachPosition;
                positionChangeFix = this.myPosition.getChangeShift(position, this.myPositionChangeXShift, this.myPositionChangeYShift);
                this.myTargetPoint = this.myPosition.getShiftedPoint(this.myTracker.recalculateLocation(this).getPoint(this.myLayeredPane), this.myCalloutShift > 0 ? this.myCalloutShift + positionChangeFix : positionChangeFix);
                this.myPosition.updateBounds(this);
                break;
            }
        }
        this.myComp.validate();
        Rectangle rec2 = this.myComp.getContentBounds();
        if (this.myShowPointer && !this.myPosition.isOkToHavePointer(this.myTargetPoint, rec2, this.getPointerLength(this.myPosition), this.getPointerWidth(this.myPosition), this.getArc())) {
            this.myShowPointer = false;
            this.myComp.removeAll();
            this.myLayeredPane.remove(this.myComp);
            this.createComponent();
            Dimension availSpace = this.myLayeredPane.getSize();
            Dimension reqSpace = this.myComp.getSize();
            if (!new Rectangle(availSpace).contains(new Rectangle(reqSpace))) {
                LOG.warn("Not enough space to show: required [" + reqSpace.width + " x " + reqSpace.height + "], available [" + availSpace.width + " x " + availSpace.height + "]");
                this.myComp.removeAll();
                this.myLayeredPane.remove(this.myComp);
                this.myLayeredPane = null;
                this.hide();
                return;
            }
        }
        for (JBPopupListener each : this.myListeners) {
            each.beforeShown(new LightweightWindowEvent(this));
        }
        if (this.isAnimationEnabled()) {
            this.runAnimation(true, this.myLayeredPane, null);
        }
        this.myLayeredPane.revalidate();
        this.myLayeredPane.repaint();
        if (this.myRequestFocus) {
            this.myFocusManager.doWhenFocusSettlesDown(new ExpirableRunnable(){

                @Override
                public boolean isExpired() {
                    return BalloonImpl.this.isDisposed();
                }

                @Override
                public void run() {
                    BalloonImpl.this.myOriginalFocusOwner = BalloonImpl.this.myFocusManager.getFocusOwner();
                    AccessibleContextUtil.setParent((Component)BalloonImpl.this.myContent, BalloonImpl.this.myOriginalFocusOwner);
                    BalloonImpl.this.myFocusManager.requestFocus(BalloonImpl.this.getContentToFocus(), true);
                }
            });
        }
        if (mnemonicsFix) {
            proxyFocusRequest.get().doWhenDone(() -> this.myFocusManager.requestFocus((Component)originalFocusOwner.get(), true));
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myAwtActivityListener, 56L);
        if (ApplicationManager.getApplication() != null) {
            ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(AnActionListener.TOPIC, new AnActionListener(){

                @Override
                public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                    if (action2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (dataContext == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    if (event == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    if (BalloonImpl.this.myHideOnAction && !(action2 instanceof HintManagerImpl.ActionToIgnore)) {
                        BalloonImpl.this.hide();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "action";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataContext";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ui/BalloonImpl$5";
                    objectArray[2] = "beforeActionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (this.myHideOnLinkClick && (editorPane = UIUtil.uiTraverser(this.myContent).traverse().filter(JEditorPane.class).first()) != null) {
            editorPane.addHyperlinkListener(new HyperlinkAdapter(){

                @Override
                protected void hyperlinkActivated(HyperlinkEvent e) {
                    BalloonImpl.this.hide();
                }
            });
        }
    }

    @NotNull
    private Component getContentToFocus() {
        Component child2;
        JViewport viewport;
        Component focusComponent = this.myContent;
        FocusTraversalPolicy policy = this.myContent.getFocusTraversalPolicy();
        if (policy instanceof SortingFocusTraversalPolicy && ((SortingFocusTraversalPolicy)policy).getImplicitDownCycleTraversal()) {
            focusComponent = policy.getDefaultComponent(this.myContent);
        }
        while (focusComponent instanceof JScrollPane && (viewport = ((JScrollPane)focusComponent).getViewport()) != null && (child2 = viewport.getView()) != null) {
            focusComponent = child2;
        }
        JComponent jComponent = focusComponent;
        if (jComponent == null) {
            BalloonImpl.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    private Rectangle getRecForPosition(AbstractPosition position, boolean adjust) {
        Dimension size = this.getContentSizeFor(position);
        Rectangle rec = new Rectangle(new Point(0, 0), size);
        position.setRecToRelativePosition(rec, this.myTargetPoint);
        if (adjust) {
            rec = this.myPosition.getUpdatedBounds(this, rec.getSize());
        }
        return rec;
    }

    private Dimension getContentSizeFor(AbstractPosition position) {
        Dimension size = this.myContent.getPreferredSize();
        if (this.myShadowBorderProvider == null) {
            JBInsets.addTo(size, position.createBorder(this).getBorderInsets());
            JBInsets.addTo(size, this.getShadowBorderInsets());
        }
        return size;
    }

    private void disposeButton(ActionButton button2) {
        if (button2 != null && button2.getParent() != null) {
            Container parent = button2.getParent();
            parent.remove(button2);
            ((JComponent)parent).revalidate();
            parent.repaint();
        }
    }

    public JComponent getContent() {
        return this.myContent;
    }

    public JComponent getComponent() {
        return this.myComp;
    }

    private void createComponent() {
        this.myComp = new MyComponent(this.myContent, this, this.myShadowBorderProvider != null ? null : (this.myShowPointer ? this.myPosition.createBorder(this) : this.getPointlessBorder()));
        if (this.myActionProvider == null) {
            final Consumer<MouseEvent> listener2 = event -> SwingUtilities.invokeLater(() -> this.hide());
            this.myActionProvider = new ActionProvider(){
                private ActionButton myCloseButton;

                @Override
                @NotNull
                public List<ActionButton> createActions() {
                    this.myCloseButton = new CloseButton(listener2);
                    List<ActionButton> list2 = Collections.singletonList(this.myCloseButton);
                    if (list2 == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                @Override
                public void layout(@NotNull Rectangle lpBounds) {
                    if (lpBounds == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    if (!this.myCloseButton.isVisible()) {
                        return;
                    }
                    Icon icon2 = BalloonImpl.this.getCloseButton();
                    int iconWidth = icon2.getIconWidth();
                    int iconHeight = icon2.getIconHeight();
                    Insets borderInsets = BalloonImpl.this.getShadowBorderInsets();
                    this.myCloseButton.setBounds(lpBounds.x + lpBounds.width - iconWidth - borderInsets.right - JBUIScale.scale(8), lpBounds.y + borderInsets.top + JBUIScale.scale(6), iconWidth, iconHeight);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ui/BalloonImpl$7";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "lpBounds";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createActions";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ui/BalloonImpl$7";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "layout";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        this.myComp.clear();
        this.myComp.myAlpha = this.isAnimationEnabled() ? 0.0f : -1.0f;
        this.myComp.setBorder(new EmptyBorder(this.getShadowBorderInsets()));
        this.myLayeredPane.add(this.myComp);
        this.myLayeredPane.setLayer(this.myComp, this.getLayer(), 0);
        this.myPosition.updateBounds(this);
        PopupLocationTracker.register(this);
        if (this.myBlockClicks) {
            this.myComp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    e.consume();
                }
            });
        }
    }

    @Override
    @NotNull
    public Rectangle getConsumedScreenBounds() {
        Rectangle bounds2 = this.myComp.getBounds();
        Point location2 = bounds2.getLocation();
        SwingUtilities.convertPointToScreen(location2, this.myLayeredPane);
        bounds2.setLocation(location2);
        Rectangle rectangle = bounds2;
        if (rectangle == null) {
            BalloonImpl.$$$reportNull$$$0(9);
        }
        return rectangle;
    }

    @Override
    public Window getUnderlyingWindow() {
        return ComponentUtil.getWindow(this.myLayeredPane);
    }

    @NotNull
    private EmptyBorder getPointlessBorder() {
        return new EmptyBorder(this.myBorderInsets);
    }

    @Override
    public void revalidate() {
        this.revalidate(this.myTracker);
    }

    @Override
    public void revalidate(@NotNull PositionTracker<Balloon> tracker) {
        if (tracker == null) {
            BalloonImpl.$$$reportNull$$$0(10);
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        RelativePoint newPosition = tracker.recalculateLocation(this);
        if (newPosition != null) {
            this.myTargetPoint = this.myPosition.getShiftedPoint(newPosition.getPoint(this.myLayeredPane), this.myCalloutShift);
            this.myPosition.updateBounds(this);
        }
    }

    public void setShadowBorderProvider(@NotNull ShadowBorderProvider provider) {
        if (provider == null) {
            BalloonImpl.$$$reportNull$$$0(11);
        }
        this.myShadowBorderProvider = provider;
    }

    private int getShadowBorderSize() {
        return this.hasShadow() ? this.myShadowSize : 0;
    }

    @NotNull
    public Insets getShadowBorderInsets() {
        if (this.myShadowBorderProvider != null) {
            Insets insets = this.myShadowBorderProvider.getInsets();
            if (insets == null) {
                BalloonImpl.$$$reportNull$$$0(12);
            }
            return insets;
        }
        JBInsets jBInsets = JBUI.insets(this.getShadowBorderSize());
        if (jBInsets == null) {
            BalloonImpl.$$$reportNull$$$0(13);
        }
        return jBInsets;
    }

    public boolean hasShadow() {
        return this.myShadowBorderProvider != null || this.myShadow && Registry.is("ide.balloon.shadowEnabled");
    }

    @Override
    public void show(JLayeredPane pane2) {
        this.show(pane2, null);
    }

    @Override
    public void showInCenterOf(JComponent component2) {
        Dimension size = component2.getSize();
        this.show(new RelativePoint(component2, new Point(size.width / 2, size.height / 2)), Balloon.Position.above);
    }

    public void show(JLayeredPane pane2, @Nullable Rectangle bounds2) {
        if (bounds2 != null) {
            this.myForcedBounds = bounds2;
        }
        this.show(new RelativePoint(pane2, new Point(0, 0)), Balloon.Position.above);
    }

    private void runAnimation(boolean forward, final JLayeredPane layeredPane, final @Nullable Runnable onDone) {
        if (this.myAnimator != null) {
            Disposer.dispose(this.myAnimator);
        }
        this.myAnimator = new Animator("Balloon", 8, this.isAnimationEnabled() ? this.myAnimationCycle : 0, false, forward){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                if (BalloonImpl.this.myComp == null || BalloonImpl.this.myComp.getParent() == null || !BalloonImpl.this.isAnimationEnabled()) {
                    return;
                }
                BalloonImpl.this.myComp.setAlpha((float)frame / (float)totalFrames);
            }

            @Override
            protected void paintCycleEnd() {
                if (BalloonImpl.this.myComp == null || BalloonImpl.this.myComp.getParent() == null) {
                    return;
                }
                if (this.isForward()) {
                    BalloonImpl.this.myComp.clear();
                    BalloonImpl.this.myComp.repaint();
                    BalloonImpl.this.myFadedIn = true;
                    if (!BalloonImpl.this.myFadeoutAlarm.isDisposed()) {
                        BalloonImpl.this.startFadeoutTimer((int)BalloonImpl.this.myFadeoutTime);
                    }
                } else {
                    layeredPane.remove(BalloonImpl.this.myComp);
                    layeredPane.revalidate();
                    layeredPane.repaint();
                }
                Disposer.dispose(this);
            }

            @Override
            public void dispose() {
                super.dispose();
                BalloonImpl.this.myAnimator = null;
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        this.myAnimator.resume();
    }

    void runWithSmartFadeoutPause(@NotNull Runnable handler2) {
        if (handler2 == null) {
            BalloonImpl.$$$reportNull$$$0(14);
        }
        if (this.mySmartFadeout) {
            this.mySmartFadeoutPaused = true;
            handler2.run();
            if (this.mySmartFadeoutPaused) {
                this.mySmartFadeoutPaused = false;
            } else {
                this.setAnimationEnabled(true);
                this.hide();
            }
        } else {
            handler2.run();
        }
    }

    public void startSmartFadeoutTimer(int delay) {
        this.mySmartFadeout = true;
        this.mySmartFadeoutDelay = delay;
        Topics.subscribe(FrameStateListener.TOPIC, (Disposable)this, (Object)new FrameStateListener(){

            @Override
            public void onFrameDeactivated() {
                if (!BalloonImpl.this.myFadeoutAlarm.isEmpty()) {
                    BalloonImpl.this.myFadeoutAlarm.cancelAllRequests();
                    BalloonImpl.this.mySmartFadeoutDelay = BalloonImpl.this.myFadeoutRequestDelay - (int)(System.currentTimeMillis() - BalloonImpl.this.myFadeoutRequestMillis);
                    if (BalloonImpl.this.mySmartFadeoutDelay <= 0) {
                        BalloonImpl.this.mySmartFadeoutDelay = 1;
                    }
                }
            }
        });
    }

    public void startFadeoutTimer(int fadeoutDelay) {
        if (fadeoutDelay > 0) {
            this.myFadeoutAlarm.cancelAllRequests();
            this.myFadeoutRequestMillis = System.currentTimeMillis();
            this.myFadeoutRequestDelay = fadeoutDelay;
            this.myFadeoutAlarm.addRequest(() -> {
                if (this.mySmartFadeout) {
                    this.setAnimationEnabled(true);
                }
                this.hide();
            }, fadeoutDelay, (ModalityState)null);
        }
    }

    private int getArc() {
        return this.myDialogMode ? DIALOG_ARC.get() : ARC.get();
    }

    private int getPointerWidth(AbstractPosition position) {
        if (this.myPointerSize == null || this.myPointerSize.width <= 0) {
            if (this.myDialogMode) {
                return position.isTopBottomPointer() ? DIALOG_TOPBOTTOM_POINTER_WIDTH.get() : DIALOG_POINTER_WIDTH.get();
            }
            return position.isTopBottomPointer() ? TOPBOTTOM_POINTER_WIDTH.get() : POINTER_WIDTH.get();
        }
        return this.myPointerSize.width;
    }

    public static int getNormalInset() {
        return 3;
    }

    private int getPointerLength(AbstractPosition position) {
        return this.myPointerSize == null || this.myPointerSize.height <= 0 ? BalloonImpl.getPointerLength(position, this.myDialogMode) : this.myPointerSize.height;
    }

    private static int getPointerLength(AbstractPosition position, boolean dialogMode) {
        if (dialogMode) {
            return position.isTopBottomPointer() ? DIALOG_TOPBOTTOM_POINTER_LENGTH.get() : DIALOG_POINTER_LENGTH.get();
        }
        return position.isTopBottomPointer() ? TOPBOTTOM_POINTER_LENGTH.get() : POINTER_LENGTH.get();
    }

    public static int getPointerLength(@NotNull Balloon.Position position, boolean dialogMode) {
        if (position == null) {
            BalloonImpl.$$$reportNull$$$0(15);
        }
        return BalloonImpl.getPointerLength(BalloonImpl.getAbstractPositionFor(position), dialogMode);
    }

    @Override
    public void hide() {
        this.hide(false);
    }

    @Override
    public void hide(boolean ok) {
        this.hideAndDispose(ok);
    }

    @Override
    public void dispose() {
        this.hideAndDispose(false);
    }

    private void hideAndDispose(boolean ok) {
        if (this.myDisposed) {
            return;
        }
        if (this.mySmartFadeoutPaused) {
            this.mySmartFadeoutPaused = false;
            return;
        }
        this.myDisposed = true;
        this.hideComboBoxPopups();
        Runnable disposeRunnable = () -> {
            this.myFadedOut = true;
            if (this.myRequestFocus && this.myOriginalFocusOwner != null) {
                this.myFocusManager.requestFocus(this.myOriginalFocusOwner, false);
            }
            for (JBPopupListener each : this.myListeners) {
                each.onClosed(new LightweightWindowEvent(this, ok));
            }
            Disposer.dispose(this);
            this.onDisposed();
        };
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAwtActivityListener);
        if (this.myLayeredPane != null) {
            this.myLayeredPane.removeComponentListener(this.myComponentListener);
            if (this.isAnimationEnabled()) {
                this.runAnimation(false, this.myLayeredPane, disposeRunnable);
            } else {
                if (this.myAnimator != null) {
                    Disposer.dispose(this.myAnimator);
                }
                if (this.myComp != null) {
                    this.myLayeredPane.remove(this.myComp);
                    this.myLayeredPane.revalidate();
                    this.myLayeredPane.repaint();
                }
                disposeRunnable.run();
            }
        } else {
            disposeRunnable.run();
        }
        this.myVisible = false;
        this.myTracker = null;
    }

    private void hideComboBoxPopups() {
        List<JComboBox> comboBoxes = UIUtil.findComponentsOfType(this.myComp, JComboBox.class);
        for (JComboBox box : comboBoxes) {
            box.hidePopup();
        }
    }

    private void onDisposed() {
    }

    @Override
    public void addListener(@NotNull JBPopupListener listener2) {
        if (listener2 == null) {
            BalloonImpl.$$$reportNull$$$0(16);
        }
        this.myListeners.add(listener2);
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setHideOnClickOutside(boolean hideOnMouse) {
        this.myHideOnMouse = hideOnMouse;
    }

    public void setHideListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            BalloonImpl.$$$reportNull$$$0(17);
        }
        this.myHideListener = listener2;
        this.myHideOnMouse = true;
    }

    public void setShowPointer(boolean show2) {
        this.myShowPointer = show2;
    }

    public Icon getCloseButton() {
        return AllIcons.Ide.Notification.Close;
    }

    @Override
    public void setBounds(Rectangle bounds2) {
        this.myForcedBounds = bounds2;
        if (this.myPosition != null) {
            this.myPosition.updateBounds(this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myComp != null) {
            return this.myComp.getPreferredSize();
        }
        if (this.myDefaultPrefSize == null) {
            EmptyBorder border = this.myShadowBorderProvider == null ? this.getPointlessBorder() : null;
            MyComponent c = new MyComponent(this.myContent, this, border);
            c.setBorder(new EmptyBorder(this.getShadowBorderInsets()));
            this.myDefaultPrefSize = c.getPreferredSize();
        }
        return this.myDefaultPrefSize;
    }

    @NotNull
    private static RoundRectangle2D.Double getPointlessShape(BalloonImpl balloon, Rectangle bounds2) {
        return new RoundRectangle2D.Double(bounds2.x, bounds2.y, bounds2.width - JBUIScale.scale(1), bounds2.height - JBUIScale.scale(1), balloon.getArc(), balloon.getArc());
    }

    @Override
    public boolean wasFadedIn() {
        return this.myFadedIn;
    }

    @Override
    public boolean wasFadedOut() {
        return this.myFadedOut;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public void setTitle(String title) {
        this.myTitleLabel.setText(title);
    }

    public void setActionProvider(@NotNull ActionProvider actionProvider) {
        if (actionProvider == null) {
            BalloonImpl.$$$reportNull$$$0(18);
        }
        this.myActionProvider = actionProvider;
    }

    @Override
    public RelativePoint getShowingPoint() {
        Point p = this.myPosition.getShiftedPoint(this.myTargetPoint, this.myCalloutShift * -1);
        return new RelativePoint(this.myLayeredPane, p);
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
        this.myAnimationEnabled = enabled;
    }

    public boolean isAnimationEnabled() {
        return this.myAnimationEnabled && this.myAnimationCycle > 0 && !RemoteDesktopService.isRemoteSession();
    }

    public boolean isBlockClicks() {
        return this.myBlockClicks;
    }

    public boolean isClickProcessor() {
        return this.myClickHandler != null || !this.myCloseOnClick || this.isBlockClicks();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "borderColor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillColor";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/BalloonImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/BalloonImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentToFocus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumedScreenBounds";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowBorderInsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isWithinChildWindow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInsideBalloon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInside";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMovingForward";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAbstractPositionFor";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "revalidate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setShadowBorderProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runWithSmartFadeoutPause";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPointerLength";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setHideListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setActionProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Shaper {
        private final GeneralPath myPath = new GeneralPath();
        Rectangle myBounds;
        @JdkConstants.TabPlacement
        private final int myTargetSide;
        private final BalloonImpl myBalloon;

        Shaper(BalloonImpl balloon, Rectangle bounds2, Point targetPoint, @JdkConstants.TabPlacement int targetSide) {
            this.myBalloon = balloon;
            this.myBounds = bounds2;
            this.myTargetSide = targetSide;
            this.start(targetPoint);
        }

        private void start(Point start2) {
            this.myPath.moveTo(start2.x, start2.y);
        }

        @NotNull
        Shaper roundUpRight() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y - this.myBalloon.getArc(), this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(0);
            }
            return shaper;
        }

        @NotNull
        Shaper roundRightDown() {
            this.myPath.quadTo(this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(1);
            }
            return shaper;
        }

        @NotNull
        Shaper roundLeftUp() {
            this.myPath.quadTo(this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(2);
            }
            return shaper;
        }

        @NotNull
        Shaper roundLeftDown() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y + this.myBalloon.getArc(), this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(3);
            }
            return shaper;
        }

        public Point getCurrent() {
            return new Point((int)this.myPath.getCurrentPoint().getX(), (int)this.myPath.getCurrentPoint().getY());
        }

        public Shaper line(int deltaX, int deltaY) {
            this.myPath.lineTo(this.getCurrent().x + deltaX, this.getCurrent().y + deltaY);
            return this;
        }

        public Shaper lineTo(int x, int y) {
            this.myPath.lineTo(x, y);
            return this;
        }

        private int getTargetDelta(@JdkConstants.TabPlacement int effectiveSide) {
            return effectiveSide == this.myTargetSide ? this.myBalloon.getPointerLength(this.myBalloon.myPosition) : 0;
        }

        @NotNull
        Shaper toRightCurve() {
            this.myPath.lineTo((int)this.myBounds.getMaxX() - this.myBalloon.getArc() - this.getTargetDelta(4) - JBUIScale.scale(1), this.getCurrent().y);
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(4);
            }
            return shaper;
        }

        @NotNull
        Shaper toBottomCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getMaxY() - this.myBalloon.getArc() - this.getTargetDelta(3) - JBUIScale.scale(1));
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(5);
            }
            return shaper;
        }

        @NotNull
        Shaper toLeftCurve() {
            this.myPath.lineTo((int)this.myBounds.getX() + this.myBalloon.getArc() + this.getTargetDelta(2), this.getCurrent().y);
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(6);
            }
            return shaper;
        }

        @NotNull
        Shaper toTopCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getY() + this.myBalloon.getArc() + this.getTargetDelta(1));
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(7);
            }
            return shaper;
        }

        public void close() {
            this.myPath.closePath();
        }

        public Shape getShape() {
            return this.myPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ui/BalloonImpl$Shaper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roundUpRight";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roundRightDown";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roundLeftUp";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roundLeftDown";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toRightCurve";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toBottomCurve";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toLeftCurve";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toTopCurve";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class MyComponent
    extends HwFacadeJPanel
    implements ComponentWithMnemonics {
        private BufferedImage myImage;
        private float myAlpha;
        private final BalloonImpl myBalloon;
        private final JComponent myContent;
        private ShadowBorderPainter.Shadow myShadow;

        private MyComponent(JComponent content2, BalloonImpl balloon, EmptyBorder shapeBorder) {
            this.setOpaque(false);
            this.setLayout(null);
            this.putClientProperty(UIUtil.TEXT_COPY_ROOT, Boolean.TRUE);
            this.myBalloon = balloon;
            if (!ScreenReader.isActive()) {
                this.setFocusCycleRoot(true);
            }
            this.putClientProperty("Balloon.property", BalloonImpl.this);
            this.myContent = new JPanel(new BorderLayout(2, 2));
            Wrapper contentWrapper = new Wrapper(content2);
            if (BalloonImpl.this.myTitle != null) {
                BalloonImpl.this.myTitleLabel = new JLabel(BalloonImpl.this.myTitle, 0);
                BalloonImpl.this.myTitleLabel.setForeground(UIUtil.getListBackground());
                BalloonImpl.this.myTitleLabel.setBorder(JBUI.Borders.empty(0, 4));
                this.myContent.add((Component)BalloonImpl.this.myTitleLabel, "North");
                contentWrapper.setBorder(JBUI.Borders.empty(1));
            }
            this.myContent.add((Component)contentWrapper, "Center");
            this.myContent.setBorder(shapeBorder);
            this.myContent.setOpaque(false);
            this.add(this.myContent);
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container aContainer, Component aComponent) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside(MyComponent.this);
                }

                @Override
                public Component getComponentBefore(Container aContainer, Component aComponent) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside(MyComponent.this);
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside(MyComponent.this);
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside(MyComponent.this);
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside(MyComponent.this);
                }
            });
        }

        @NotNull
        Rectangle getContentBounds() {
            Rectangle bounds2 = this.getBounds();
            JBInsets.removeFrom(bounds2, this.getInsets());
            Rectangle rectangle = bounds2;
            if (rectangle == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        public void clear() {
            this.myImage = null;
            this.myAlpha = -1.0f;
        }

        @Override
        public void doLayout() {
            Rectangle bounds2 = new Rectangle(this.getWidth(), this.getHeight());
            JBInsets.removeFrom(bounds2, this.getInsets());
            this.myContent.setBounds(bounds2);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.addInsets(this.myContent.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.addInsets(this.myContent.getMinimumSize());
        }

        private Dimension addInsets(Dimension size) {
            JBInsets.addTo(size, this.getInsets());
            return size;
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (this.myImage == null || this.myAlpha == -1.0f) {
                super.paintChildren(g);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintChildrenImpl(Graphics g) {
            BufferedImage image = ImageUtil.createImage(g, this.getWidth(), this.getHeight(), 1);
            UIUtil.useSafely(image.createGraphics(), imageGraphics -> {
                imageGraphics.setPaint(new Color(BalloonImpl.this.myFillColor.getRGB()));
                imageGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintChildren((Graphics)imageGraphics);
            });
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                if (JreHiDpiUtil.isJreHiDPI(g2d)) {
                    float s = 1.0f / JBUIScale.sysScale(g2d);
                    g2d.scale(s, s);
                }
                StartupUiUtil.drawImage((Graphics)g2d, this.makeColorTransparent(image, BalloonImpl.this.myFillColor), 0, 0, null);
            }
            finally {
                g2d.dispose();
            }
        }

        private Image makeColorTransparent(Image image, Color color) {
            final int markerRGB = color.getRGB() | 0xFF000000;
            RGBImageFilter filter2 = new RGBImageFilter(){

                @Override
                public int filterRGB(int x, int y, int rgb) {
                    if ((rgb | 0xFF000000) == markerRGB) {
                        return 0xFFFFFF & rgb;
                    }
                    return rgb;
                }
            };
            return ImageUtil.filter(image, filter2);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Point pointTarget = SwingUtilities.convertPoint(BalloonImpl.this.myLayeredPane, this.myBalloon.myTargetPoint, this);
            Rectangle shapeBounds = this.myContent.getBounds();
            int shadowSize = this.myBalloon.getShadowBorderSize();
            if (shadowSize > 0 && this.myShadow == null && BalloonImpl.this.myShadowBorderProvider == null) {
                this.initComponentImage(pointTarget, shapeBounds);
                this.myShadow = ShadowBorderPainter.createShadow(this.myImage, 0, 0, false, shadowSize / 2);
            }
            if (this.myImage == null && this.myAlpha != -1.0f) {
                this.initComponentImage(pointTarget, shapeBounds);
            }
            if (this.myImage != null && this.myAlpha != -1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, this.myAlpha));
            }
            if (BalloonImpl.this.myShadowBorderProvider != null) {
                BalloonImpl.this.myShadowBorderProvider.paintShadow(this, g);
            }
            if (this.myImage != null && this.myAlpha != -1.0f) {
                this.paintShadow(g);
                StartupUiUtil.drawImage((Graphics)g2d, (Image)this.myImage, 0, 0, null);
            } else {
                this.paintShadow(g);
                this.myBalloon.myPosition.paintComponent(this.myBalloon, shapeBounds, (Graphics2D)g, pointTarget);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintShadow(Graphics graphics) {
            if (this.myShadow != null) {
                Graphics2D g2d = (Graphics2D)graphics;
                try {
                    if (JreHiDpiUtil.isJreHiDPI(g2d)) {
                        g2d = (Graphics2D)graphics.create();
                        float s = 1.0f / JBUIScale.sysScale(this);
                        g2d.scale(s, s);
                    }
                    StartupUiUtil.drawImage((Graphics)g2d, this.myShadow.getImage(), this.myShadow.getX(), this.myShadow.getY(), null);
                }
                finally {
                    if (g2d != graphics) {
                        g2d.dispose();
                    }
                }
            }
        }

        @Override
        public boolean contains(int x, int y) {
            Point pointTarget = SwingUtilities.convertPoint(BalloonImpl.this.myLayeredPane, this.myBalloon.myTargetPoint, this);
            Rectangle bounds2 = this.myContent.getBounds();
            Shape shape = BalloonImpl.this.myShowPointer ? this.myBalloon.myPosition.getPointingShape(bounds2, pointTarget, this.myBalloon) : BalloonImpl.getPointlessShape(this.myBalloon, bounds2);
            return shape.contains(x, y);
        }

        private void initComponentImage(Point pointTarget, Rectangle shapeBounds) {
            if (this.myImage != null) {
                return;
            }
            this.myImage = UIUtil.createImage(BalloonImpl.this.myComp, this.getWidth(), this.getHeight(), 2);
            UIUtil.useSafely(this.myImage.getGraphics(), imageGraphics -> {
                this.myBalloon.myPosition.paintComponent(this.myBalloon, shapeBounds, (Graphics2D)imageGraphics, pointTarget);
                this.paintChildrenImpl((Graphics)imageGraphics);
            });
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (!ScreenUtil.isStandardAddRemoveNotify(this)) {
                return;
            }
            List buttons = BalloonImpl.this.myActionButtons;
            BalloonImpl.this.myActionButtons = null;
            if (buttons != null) {
                SwingUtilities.invokeLater(() -> {
                    for (ActionButton button2 : buttons) {
                        BalloonImpl.this.disposeButton(button2);
                    }
                });
            }
        }

        public void setAlpha(float alpha) {
            this.myAlpha = alpha;
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }

        void _setBounds(@NotNull Rectangle bounds2) {
            Rectangle currentBounds;
            if (bounds2 == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            if (!(currentBounds = this.getBounds()).equals(bounds2)) {
                this.invalidateShadowImage();
            }
            this.setBounds(bounds2);
            if (this.getParent() != null) {
                if (BalloonImpl.this.myActionButtons == null) {
                    BalloonImpl.this.myActionButtons = BalloonImpl.this.myActionProvider.createActions();
                }
                for (ActionButton button2 : BalloonImpl.this.myActionButtons) {
                    if (button2.getParent() != null) continue;
                    BalloonImpl.this.myLayeredPane.add(button2);
                    BalloonImpl.this.myLayeredPane.setLayer(button2, JLayeredPane.DRAG_LAYER);
                }
            }
            if (this.isVisible()) {
                Rectangle lpBounds = SwingUtilities.convertRectangle(this.getParent(), bounds2, BalloonImpl.this.myLayeredPane);
                lpBounds = BalloonImpl.this.myPosition.getPointlessContentRec(lpBounds, this.myBalloon.myShadowBorderProvider == null ? this.myBalloon.getPointerLength(BalloonImpl.this.myPosition) : 0);
                BalloonImpl.this.myActionProvider.layout(lpBounds);
            }
            if (this.isVisible()) {
                this.revalidate();
                this.repaint();
            }
        }

        private void invalidateShadowImage() {
            this.myImage = null;
            this.myShadow = null;
        }

        void repaintButton() {
            if (BalloonImpl.this.myActionButtons != null) {
                for (ActionButton button2 : BalloonImpl.this.myActionButtons) {
                    button2.repaint();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$MyComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentBounds";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$MyComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "_setBounds";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class CloseButton
    extends ActionButton {
        private CloseButton(Consumer<? super MouseEvent> listener2) {
            if (listener2 == null) {
                CloseButton.$$$reportNull$$$0(0);
            }
            super(BalloonImpl.this.getCloseButton(), null, null, listener2);
            this.setVisible(BalloonImpl.this.myEnableButtons);
        }

        @Override
        protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon2) {
            if (g == null) {
                CloseButton.$$$reportNull$$$0(1);
            }
            if (icon2 == null) {
                CloseButton.$$$reportNull$$$0(2);
            }
            if (BalloonImpl.this.myEnableButtons) {
                boolean pressed = this.myButton.isPressedByMouse();
                icon2.paintIcon(this, g, pressed ? JBUIScale.scale(1) : 0, pressed ? JBUIScale.scale(1) : 0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/BalloonImpl$CloseButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ActionButton
    extends HwFacadeNonOpaquePanel
    implements IdeGlassPane.TopComponent {
        private final Icon myIcon;
        private final Icon myHoverIcon;
        private final Consumer<? super MouseEvent> myListener;
        protected final BaseButtonBehavior myButton;

        public ActionButton(@Nullable Icon icon2, @Nullable Icon hoverIcon, @NotNull String hint, Consumer<? super MouseEvent> listener2) {
            if (icon2 == null) {
                ActionButton.$$$reportNull$$$0(0);
            }
            if (listener2 == null) {
                ActionButton.$$$reportNull$$$0(1);
            }
            this.myIcon = icon2;
            this.myHoverIcon = hoverIcon;
            this.myListener = listener2;
            this.setToolTipText(hint);
            this.myButton = new BaseButtonBehavior(this, TimedDeadzone.NULL){

                @Override
                protected void execute(MouseEvent e) {
                    ActionButton.this.myListener.consume(e);
                }
            };
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon.getIconWidth(), this.myIcon.getIconHeight());
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.hasPaint()) {
                this.paintIcon(g, this.myHoverIcon != null && this.myButton.isHovered() ? this.myHoverIcon : this.myIcon);
            }
        }

        boolean hasPaint() {
            return this.getWidth() > 0 && BalloonImpl.this.myLastMoveWasInsideBalloon;
        }

        protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon2) {
            if (g == null) {
                ActionButton.$$$reportNull$$$0(2);
            }
            if (icon2 == null) {
                ActionButton.$$$reportNull$$$0(3);
            }
            icon2.paintIcon(this, g, 0, 0);
        }

        @Override
        public boolean canBePreprocessed(@NotNull MouseEvent e) {
            if (e == null) {
                ActionButton.$$$reportNull$$$0(4);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/BalloonImpl$ActionButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBePreprocessed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ActionProvider {
        @NotNull
        public List<ActionButton> createActions();

        public void layout(@NotNull Rectangle var1);
    }

    private static class AtLeft
    extends AbstractPosition {
        private AtLeft() {
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, int shift) {
            if (targetPoint == null) {
                AtLeft.$$$reportNull$$$0(0);
            }
            return new Point(targetPoint.x - shift, targetPoint.y);
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, @NotNull Insets shift) {
            if (targetPoint == null) {
                AtLeft.$$$reportNull$$$0(1);
            }
            if (shift == null) {
                AtLeft.$$$reportNull$$$0(2);
            }
            Point point = this.getShiftedPoint(targetPoint, -shift.left);
            if (point == null) {
                AtLeft.$$$reportNull$$$0(3);
            }
            return point;
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == AT_RIGHT ? -xShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return targetPoint.x - (int)rectangle.getMaxX();
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds2, int pointerLength) {
            return new Rectangle(bounds2.x, bounds2.y, bounds2.width - pointerLength, bounds2.height);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.right += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x - rec.width, targetPoint.y - rec.height / 2);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance2) {
            if (distance2 > 0) {
                return new Point(targetPoint.x - balloonSize.width, targetPoint.y - distance2);
            }
            Point center = StartupUiUtil.getCenterPoint(new Rectangle(targetPoint, JBUI.emptySize()), balloonSize);
            return new Point(targetPoint.x - balloonSize.width, center.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(JBUIScale.scale(normalInset), pointerLength, JBUIScale.scale(normalInset), JBUIScale.scale(normalInset));
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds2, Point pointTarget, BalloonImpl balloon) {
            pointTarget = new Point(Math.max((int)bounds2.getMaxX(), pointTarget.x), pointTarget.y);
            Shaper shaper = new Shaper(balloon, bounds2, pointTarget, 4);
            shaper.lineTo((int)bounds2.getMaxX() - shaper.getTargetDelta(4) - JBUIScale.scale(1), pointTarget.y + balloon.getPointerWidth(this) / 2);
            shaper.toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().lineTo(shaper.getCurrent().x, pointTarget.y - balloon.getPointerWidth(this) / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shift";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$AtLeft";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$AtLeft";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShiftedPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getShiftedPoint";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AtRight
    extends AbstractPosition {
        private AtRight() {
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, int shift) {
            if (targetPoint == null) {
                AtRight.$$$reportNull$$$0(0);
            }
            return new Point(targetPoint.x + shift, targetPoint.y);
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, @NotNull Insets shift) {
            if (targetPoint == null) {
                AtRight.$$$reportNull$$$0(1);
            }
            if (shift == null) {
                AtRight.$$$reportNull$$$0(2);
            }
            Point point = this.getShiftedPoint(targetPoint, -shift.left);
            if (point == null) {
                AtRight.$$$reportNull$$$0(3);
            }
            return point;
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == AT_LEFT ? xShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return rectangle.x - targetPoint.x;
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds2, int pointerLength) {
            return new Rectangle(bounds2.x + pointerLength, bounds2.y, bounds2.width - pointerLength, bounds2.height);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.left += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x, targetPoint.y - rec.height / 2);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance2) {
            if (distance2 > 0) {
                return new Point(targetPoint.x, targetPoint.y - distance2);
            }
            Point center = StartupUiUtil.getCenterPoint(new Rectangle(targetPoint, JBUI.emptySize()), balloonSize);
            return new Point(targetPoint.x, center.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(JBUIScale.scale(normalInset), pointerLength, JBUIScale.scale(normalInset), JBUIScale.scale(normalInset));
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds2, Point pointTarget, BalloonImpl balloon) {
            pointTarget = new Point(Math.min(bounds2.x, pointTarget.y), pointTarget.y);
            Shaper shaper = new Shaper(balloon, bounds2, pointTarget, 2);
            shaper.line(balloon.getPointerLength(this), -balloon.getPointerWidth(this) / 2).toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().lineTo(shaper.getCurrent().x, pointTarget.y + balloon.getPointerWidth(this) / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shift";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$AtRight";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$AtRight";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShiftedPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getShiftedPoint";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Above
    extends AbstractPosition {
        private Above() {
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, int shift) {
            if (targetPoint == null) {
                Above.$$$reportNull$$$0(0);
            }
            return new Point(targetPoint.x, targetPoint.y - shift);
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, @NotNull Insets shift) {
            if (targetPoint == null) {
                Above.$$$reportNull$$$0(1);
            }
            if (shift == null) {
                Above.$$$reportNull$$$0(2);
            }
            Point point = this.getShiftedPoint(targetPoint, -shift.top);
            if (point == null) {
                Above.$$$reportNull$$$0(3);
            }
            return point;
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == BELOW ? -yShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return targetPoint.y - (int)rectangle.getMaxY();
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds2, int pointerLength) {
            return new Rectangle(bounds2.x, bounds2.y, bounds2.width, bounds2.height - pointerLength);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.bottom += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x - rec.width / 2, targetPoint.y - rec.height);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance2) {
            if (distance2 > 0) {
                return new Point(targetPoint.x - distance2, targetPoint.y - balloonSize.height);
            }
            Point center = StartupUiUtil.getCenterPoint(new Rectangle(targetPoint, JBUI.emptySize()), balloonSize);
            return new Point(center.x, targetPoint.y - balloonSize.height);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return JBUI.insets(normalInset, normalInset, normalInset, normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds2, Point pointTarget, BalloonImpl balloon) {
            pointTarget = new Point(pointTarget.x, Math.max((int)bounds2.getMaxY(), pointTarget.y));
            Shaper shaper = new Shaper(balloon, bounds2, pointTarget, 3);
            shaper.line(-balloon.getPointerWidth(this) / 2, -balloon.getPointerLength(this) + JBUIScale.scale(1));
            shaper.toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().line(0, 2).roundLeftDown().lineTo(pointTarget.x + balloon.getPointerWidth(this) / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shift";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$Above";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$Above";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShiftedPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getShiftedPoint";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Below
    extends AbstractPosition {
        private Below() {
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, int shift) {
            if (targetPoint == null) {
                Below.$$$reportNull$$$0(0);
            }
            return new Point(targetPoint.x, targetPoint.y + shift);
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, @NotNull Insets shift) {
            if (targetPoint == null) {
                Below.$$$reportNull$$$0(1);
            }
            if (shift == null) {
                Below.$$$reportNull$$$0(2);
            }
            Point point = this.getShiftedPoint(targetPoint, -shift.top);
            if (point == null) {
                Below.$$$reportNull$$$0(3);
            }
            return point;
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == ABOVE ? yShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return rectangle.y - targetPoint.y;
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds2, int pointerLength) {
            return new Rectangle(bounds2.x, bounds2.y + pointerLength, bounds2.width, bounds2.height - pointerLength);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.top += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(new Point(targetPoint.x - rec.width / 2, targetPoint.y));
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance2) {
            if (distance2 > 0) {
                return new Point(targetPoint.x - distance2, targetPoint.y);
            }
            Point center = StartupUiUtil.getCenterPoint(new Rectangle(targetPoint, JBUI.emptySize()), balloonSize);
            return new Point(center.x, targetPoint.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(pointerLength, JBUIScale.scale(normalInset), JBUIScale.scale(normalInset), JBUIScale.scale(normalInset));
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds2, Point pointTarget, BalloonImpl balloon) {
            pointTarget = new Point(pointTarget.x, Math.min(bounds2.y, pointTarget.y));
            Shaper shaper = new Shaper(balloon, bounds2, pointTarget, 1);
            shaper.line(balloon.getPointerWidth(this) / 2, balloon.getPointerLength(this)).toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().lineTo(pointTarget.x - balloon.getPointerWidth(this) / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y);
            shaper.close();
            return shaper.getShape();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shift";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$Below";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$Below";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShiftedPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getShiftedPoint";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class AbstractPosition {
        private AbstractPosition() {
        }

        abstract EmptyBorder createBorder(BalloonImpl var1);

        abstract void setRecToRelativePosition(Rectangle var1, Point var2);

        abstract int getChangeShift(AbstractPosition var1, int var2, int var3);

        public void updateBounds(@NotNull BalloonImpl balloon) {
            if (balloon == null) {
                AbstractPosition.$$$reportNull$$$0(0);
            }
            if (balloon.myLayeredPane == null || balloon.myComp == null) {
                return;
            }
            Rectangle bounds2 = this.getUpdatedBounds(balloon, balloon.myComp.getPreferredSize());
            if (balloon.myShadowBorderProvider == null) {
                bounds2 = new Rectangle(this.getShiftedPoint(bounds2.getLocation(), balloon.getShadowBorderInsets()), bounds2.getSize());
            }
            balloon.myComp._setBounds(bounds2);
        }

        @NotNull
        Rectangle getUpdatedBounds(BalloonImpl balloon, Dimension preferredSize) {
            Dimension layeredPaneSize = balloon.myLayeredPane.getSize();
            Point point = balloon.myTargetPoint;
            Rectangle bounds2 = balloon.myForcedBounds;
            if (bounds2 == null) {
                int distance2 = this.getDistance(balloon, preferredSize);
                Point location2 = balloon.myShowPointer ? this.getLocation(layeredPaneSize, point, preferredSize, distance2) : new Point(point.x - preferredSize.width / 2, point.y - preferredSize.height / 2);
                bounds2 = new Rectangle(location2.x, location2.y, preferredSize.width, preferredSize.height);
                ScreenUtil.moveToFit(bounds2, new Rectangle(0, 0, layeredPaneSize.width, layeredPaneSize.height), balloon.myContainerInsets);
            }
            Rectangle rectangle = bounds2;
            if (rectangle == null) {
                AbstractPosition.$$$reportNull$$$0(1);
            }
            return rectangle;
        }

        private int getDistance(@NotNull BalloonImpl balloon, @NotNull Dimension size) {
            if (balloon == null) {
                AbstractPosition.$$$reportNull$$$0(2);
            }
            if (size == null) {
                AbstractPosition.$$$reportNull$$$0(3);
            }
            if (balloon.myCornerToPointerDistance < 0) {
                return -1;
            }
            int indent = balloon.getArc() + balloon.getPointerWidth(this) / 2;
            if (balloon.myCornerToPointerDistance < indent) {
                return indent;
            }
            int limit = this == ABOVE || this == BELOW ? size.width - indent : size.height - indent;
            return Math.min(balloon.myCornerToPointerDistance, limit);
        }

        abstract Point getLocation(Dimension var1, Point var2, Dimension var3, int var4);

        void paintComponent(BalloonImpl balloon, Rectangle bounds2, Graphics2D g, Point pointTarget) {
            GraphicsConfig cfg = new GraphicsConfig(g);
            cfg.setAntialiasing(true);
            if (balloon.myShadowBorderProvider != null) {
                balloon.myShadowBorderProvider.paintBorder(bounds2, g);
                if (balloon.myShowPointer) {
                    Balloon.Position position = this == ABOVE ? Balloon.Position.above : (this == BELOW ? Balloon.Position.below : (this == AT_LEFT ? Balloon.Position.atLeft : Balloon.Position.atRight));
                    balloon.myShadowBorderProvider.paintPointingShape(bounds2, pointTarget, position, g);
                }
                cfg.restore();
                return;
            }
            Shape shape = balloon.myShowPointer ? this.getPointingShape(bounds2, pointTarget, balloon) : BalloonImpl.getPointlessShape(balloon, bounds2);
            g.setPaint(balloon.myFillColor);
            g.fill(shape);
            if (balloon.myShowPointer && balloon.myPointerColor != null) {
                Rectangle balloonShape = this.getPointlessContentRec(bounds2, BalloonImpl.getPointerLength(this, balloon.myDialogMode) + 1);
                Area area = new Area(shape);
                area.subtract(new Area(balloonShape));
                g.setColor(balloon.myPointerColor);
                g.fill(area);
            }
            g.setColor(balloon.myBorderColor);
            if (balloon.myTitleLabel != null) {
                Rectangle titleBounds = balloon.myTitleLabel.getBounds();
                Insets inset = this.getTitleInsets(BalloonImpl.getNormalInset() - 1, balloon.getPointerLength(this) + 50);
                Insets borderInsets = balloon.getShadowBorderInsets();
                inset.top += borderInsets.top;
                inset.bottom += borderInsets.bottom;
                inset.left += borderInsets.left;
                inset.right += borderInsets.right;
                titleBounds.x -= inset.left + JBUIScale.scale(1);
                titleBounds.width += inset.left + inset.right + JBUIScale.scale(50);
                titleBounds.y -= inset.top + JBUIScale.scale(1);
                titleBounds.height += inset.top + inset.bottom + JBUIScale.scale(1);
                Area area = new Area(shape);
                area.intersect(new Area(titleBounds));
                Color fgColor = UIManager.getColor("Label.foreground");
                fgColor = ColorUtil.toAlpha(fgColor, 140);
                g.setColor(fgColor);
                g.fill(area);
                g.setColor(balloon.myBorderColor);
                g.draw(area);
            }
            g.setStroke(new BasicStroke(BORDER_STROKE_WIDTH.get()));
            g.draw(shape);
            cfg.restore();
        }

        protected abstract Insets getTitleInsets(int var1, int var2);

        protected abstract Shape getPointingShape(Rectangle var1, Point var2, BalloonImpl var3);

        boolean isOkToHavePointer(@NotNull Point targetPoint, @NotNull Rectangle bounds2, int pointerLength, int pointerWidth, int arc) {
            UnfairTextRange pointerRange;
            UnfairTextRange balloonRange;
            if (targetPoint == null) {
                AbstractPosition.$$$reportNull$$$0(4);
            }
            if (bounds2 == null) {
                AbstractPosition.$$$reportNull$$$0(5);
            }
            if (bounds2.x < targetPoint.x && bounds2.x + bounds2.width > targetPoint.x && bounds2.y < targetPoint.y && bounds2.y + bounds2.height > targetPoint.y) {
                return false;
            }
            Rectangle pointless = this.getPointlessContentRec(bounds2, pointerLength);
            int distance2 = this.getDistanceToTarget(pointless, targetPoint);
            if (distance2 < pointerLength - 1 || distance2 > 2 * pointerLength) {
                return false;
            }
            if (this.isTopBottomPointer()) {
                balloonRange = new UnfairTextRange(bounds2.x + arc - 1, bounds2.x + bounds2.width - arc * 2 + 1);
                pointerRange = new UnfairTextRange(targetPoint.x - pointerWidth / 2, targetPoint.x + pointerWidth / 2);
            } else {
                balloonRange = new UnfairTextRange(bounds2.y + arc - 1, bounds2.y + bounds2.height - arc * 2 + 1);
                pointerRange = new UnfairTextRange(targetPoint.y - pointerWidth / 2, targetPoint.y + pointerWidth / 2);
            }
            return balloonRange.contains(pointerRange);
        }

        protected abstract int getDistanceToTarget(Rectangle var1, Point var2);

        boolean isTopBottomPointer() {
            return this instanceof Below || this instanceof Above;
        }

        protected abstract Rectangle getPointlessContentRec(Rectangle var1, int var2);

        @NotNull
        Set<AbstractPosition> getOtherPositions() {
            LinkedHashSet<AbstractPosition> all = new LinkedHashSet<AbstractPosition>();
            all.add(BELOW);
            all.add(ABOVE);
            all.add(AT_RIGHT);
            all.add(AT_LEFT);
            all.remove(this);
            LinkedHashSet<AbstractPosition> linkedHashSet = all;
            if (linkedHashSet == null) {
                AbstractPosition.$$$reportNull$$$0(6);
            }
            return linkedHashSet;
        }

        @NotNull
        public abstract Point getShiftedPoint(@NotNull Point var1, int var2);

        @NotNull
        public abstract Point getShiftedPoint(@NotNull Point var1, @NotNull Insets var2);

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "balloon";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$AbstractPosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$AbstractPosition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpdatedBounds";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOtherPositions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateBounds";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDistance";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isOkToHavePointer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ShadowBorderProvider {
        @NotNull
        public Insets getInsets();

        public void paintShadow(@NotNull JComponent var1, @NotNull Graphics var2);

        public void paintBorder(@NotNull Rectangle var1, @NotNull Graphics2D var2);

        public void paintPointingShape(@NotNull Rectangle var1, @NotNull Point var2, @NotNull Balloon.Position var3, @NotNull Graphics2D var4);
    }
}

