/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Couple;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class BooleanTableCellRenderer
extends JCheckBox
implements TableCellRenderer {
    private final JPanel myPanel = new JPanel();

    public BooleanTableCellRenderer() {
        this(0);
    }

    public BooleanTableCellRenderer(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.setVerticalAlignment(0);
        this.setBorder(null);
        this.setOpaque(true);
        this.myPanel.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSel, boolean hasFocus, int row, int column) {
        Couple<Color> colors = UIUtil.getCellColors(table, isSel, row, column);
        if (value2 == null) {
            this.myPanel.setBackground((Color)colors.getSecond());
            return this.myPanel;
        }
        this.setForeground((Color)colors.getFirst());
        this.setBackground((Color)colors.getSecond());
        if (value2 instanceof String) {
            this.setSelected(Boolean.parseBoolean((String)value2));
        } else {
            this.setSelected((Boolean)value2);
        }
        this.setEnabled(table.isCellEditable(row, column));
        return this;
    }
}

