/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import sun.awt.AWTAccessor;

public class CellRendererPanel
extends JPanel {
    private boolean mySelected;

    public CellRendererPanel() {
        super(null);
        super.setOpaque(false);
        super.setFont(null);
    }

    public final boolean isSelected() {
        return this.mySelected;
    }

    public final void setSelected(boolean isSelected) {
        this.mySelected = isSelected;
    }

    public void setForcedBackground(Color bg) {
        super.setBackground(bg);
        if (bg != null && !this.mySelected) {
            this.setSelected(true);
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public final boolean isOpaque() {
        return false;
    }

    @Override
    public final void setOpaque(boolean isOpaque) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.mySelected) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int count = this.getComponentCount();
            if (count == 1) {
                Rectangle bounds2 = new Rectangle(this.getWidth(), this.getHeight());
                JBInsets.removeFrom(bounds2, this.getInsets());
                JComponent child2 = (JComponent)this.getComponent(0);
                CellRendererPanel.reshapeImpl(child2, bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                CellRendererPanel.invalidateLayout(child2);
                child2.doLayout();
            } else {
                CellRendererPanel.invalidateLayout(this);
                super.doLayout();
                for (int i = 0; i < count; ++i) {
                    Component c = this.getComponent(i);
                    c.doLayout();
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getComponentCount() != 1 || super.getBorder() != null) {
            return super.getPreferredSize();
        }
        return this.getComponent(0).getPreferredSize();
    }

    protected final Dimension super_getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        CellRendererPanel.reshapeImpl(this, x, y, w, h);
    }

    static void reshapeImpl(JComponent component2, int x, int y, int w, int h) {
        AWTAccessor.getComponentAccessor().setLocation(component2, x, y);
        AWTAccessor.getComponentAccessor().setSize(component2, w, h);
    }

    @Override
    public void invalidate() {
    }

    public void forceInvalidate() {
        super.invalidate();
    }

    private static void invalidateLayout(JComponent component2) {
        LayoutManager layout = component2.getLayout();
        if (layout instanceof LayoutManager2) {
            ((LayoutManager2)layout).invalidateLayout(component2);
        }
    }

    @Override
    public void validate() {
        this.doLayout();
    }

    protected final void super_validate() {
        super.validate();
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }
}

