/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckBoxList<T>
extends JBList<JCheckBox> {
    private static final int RESET_ROLLOVER = -1;
    private final CellRenderer myCellRenderer;
    private CheckBoxListListener checkBoxListListener;
    private final BidirectionalMap<T, JCheckBox> myItemMap = new BidirectionalMap();
    private int rollOverIndex = -1;

    public CheckBoxList(CheckBoxListListener checkBoxListListener) {
        this(new DefaultListModel<JCheckBox>(), checkBoxListListener);
    }

    public CheckBoxList(DefaultListModel<JCheckBox> dataModel, CheckBoxListListener checkBoxListListener) {
        this(dataModel);
        this.setCheckBoxListListener(checkBoxListListener);
    }

    public CheckBoxList() {
        this(new DefaultListModel());
    }

    public CheckBoxList(DefaultListModel dataModel) {
        this.setModel(dataModel);
        this.myCellRenderer = new CellRenderer();
        this.setCellRenderer(this.myCellRenderer);
        this.setSelectionMode(0);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply(CheckBoxList.this);
                if (supply != null && supply.isPopupActive()) {
                    return;
                }
                if (e.getKeyChar() == ' ') {
                    Boolean value2 = null;
                    for (int index : CheckBoxList.this.getSelectedIndices()) {
                        JCheckBox checkbox;
                        if (index < 0 || !(checkbox = CheckBoxList.this.getCheckBoxAt(index)).isEnabled()) continue;
                        value2 = value2 != null ? value2 : !checkbox.isSelected();
                        CheckBoxList.this.setSelected(checkbox, index, value2);
                    }
                }
            }
        });
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int index;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (CheckBoxList.this.isEnabled() && (index = CheckBoxList.this.locationToIndex(e.getPoint())) != -1) {
                    JCheckBox checkBox2 = CheckBoxList.this.getCheckBoxAt(index);
                    Rectangle bounds2 = CheckBoxList.this.getCellBounds(index, index);
                    if (bounds2 == null) {
                        return false;
                    }
                    Point p = CheckBoxList.this.findPointRelativeToCheckBox(e.getX() - bounds2.x, e.getY() - bounds2.y, checkBox2, index);
                    if (p != null) {
                        Dimension dim = CheckBoxList.getCheckBoxDimension(checkBox2);
                        if (p.x >= 0 && p.x < dim.width && p.y >= 0 && p.y < dim.height) {
                            if (checkBox2.isEnabled()) {
                                CheckBoxList.this.setSelected(checkBox2, index, !checkBox2.isSelected());
                            }
                            return true;
                        }
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CheckBoxList$2", "onClick"));
            }
        }.installOn(this);
        if (UIUtil.isUnderWin10LookAndFeel()) {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point point = e.getPoint();
                    int index = CheckBoxList.this.locationToIndex(point);
                    CheckBoxList.this.fireRollOverUpdated(index);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    CheckBoxList.this.fireRollOverUpdated(-1);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.setPressed(e, true);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.setPressed(e, false);
                }

                private void setPressed(MouseEvent e, boolean pressed) {
                    Point point = e.getPoint();
                    int index = CheckBoxList.this.locationToIndex(point);
                    if (index >= 0 && index < CheckBoxList.this.getModel().getSize()) {
                        JCheckBox cb = (JCheckBox)CheckBoxList.this.getModel().getElementAt(index);
                        cb.getModel().setPressed(pressed);
                        UIUtil.repaintViewport(CheckBoxList.this);
                    }
                }
            });
        }
    }

    private void fireRollOverUpdated(int newIndex) {
        if (this.rollOverIndex >= 0 && this.rollOverIndex < this.getModel().getSize()) {
            JCheckBox oldRollover = (JCheckBox)this.getModel().getElementAt(this.rollOverIndex);
            oldRollover.getModel().setRollover(false);
        }
        this.rollOverIndex = newIndex;
        if (this.rollOverIndex >= 0) {
            JCheckBox newRollover = (JCheckBox)this.getModel().getElementAt(this.rollOverIndex);
            newRollover.getModel().setRollover(true);
        }
        UIUtil.repaintViewport(this);
    }

    @NotNull
    private static Dimension getCheckBoxDimension(@NotNull JCheckBox checkBox2) {
        if (checkBox2 == null) {
            CheckBoxList.$$$reportNull$$$0(0);
        }
        Icon icon2 = null;
        BasicRadioButtonUI ui = ObjectUtils.tryCast(checkBox2.getUI(), BasicRadioButtonUI.class);
        if (ui != null) {
            icon2 = ui.getDefaultIcon();
        }
        if (icon2 == null) {
            icon2 = JBUI.scale(EmptyIcon.create(20));
        }
        Insets margin = checkBox2.getMargin();
        return new Dimension(margin.left + icon2.getIconWidth(), margin.top + icon2.getIconHeight());
    }

    @Nullable
    protected Point findPointRelativeToCheckBox(int x, int y, @NotNull JCheckBox checkBox2, int index) {
        if (checkBox2 == null) {
            CheckBoxList.$$$reportNull$$$0(1);
        }
        int cx = x - ((CellRenderer)this.myCellRenderer).getBorderInsets().left;
        int cy = y - ((CellRenderer)this.myCellRenderer).getBorderInsets().top;
        return cx >= 0 && cy >= 0 ? new Point(cx, cy) : null;
    }

    @Nullable
    protected Point findPointRelativeToCheckBoxWithAdjustedRendering(int x, int y, @NotNull JCheckBox checkBox2, int index) {
        Point checkBoxLocation;
        Container c;
        Component found2;
        if (checkBox2 == null) {
            CheckBoxList.$$$reportNull$$$0(2);
        }
        boolean selected2 = this.isSelectedIndex(index);
        boolean hasFocus = this.hasFocus();
        Component component2 = this.myCellRenderer.getListCellRendererComponent((JList)this, checkBox2, index, selected2, hasFocus);
        Rectangle bounds2 = this.getCellBounds(index, index);
        bounds2.x = 0;
        bounds2.y = 0;
        component2.setBounds(bounds2);
        if (component2 instanceof Container && (found2 = (c = (Container)component2).findComponentAt(x, y)) == checkBox2 && (checkBoxLocation = CheckBoxList.getChildLocationRelativeToAncestor(component2, checkBox2)) != null) {
            return new Point(x - checkBoxLocation.x, y - checkBoxLocation.y);
        }
        return null;
    }

    @Nullable
    private static Point getChildLocationRelativeToAncestor(@NotNull Component ancestor, @NotNull Component child2) {
        if (ancestor == null) {
            CheckBoxList.$$$reportNull$$$0(3);
        }
        if (child2 == null) {
            CheckBoxList.$$$reportNull$$$0(4);
        }
        int dx = 0;
        int dy = 0;
        Component c = child2;
        while (c != null && c != ancestor) {
            Point p = c.getLocation();
            dx += p.x;
            dy += p.y;
            c = child2.getParent();
        }
        return c == ancestor ? new Point(dx, dy) : null;
    }

    @NotNull
    private JCheckBox getCheckBoxAt(int index) {
        JCheckBox jCheckBox = (JCheckBox)this.getModel().getElementAt(index);
        if (jCheckBox == null) {
            CheckBoxList.$$$reportNull$$$0(5);
        }
        return jCheckBox;
    }

    public void setStringItems(Map<String, Boolean> items) {
        this.clear();
        for (Map.Entry<String, Boolean> entry : items.entrySet()) {
            this.addItem(entry.getKey(), entry.getKey(), entry.getValue());
        }
    }

    public void setItems(List<? extends T> items, @Nullable Function<? super T, String> converter) {
        this.clear();
        for (T item : items) {
            String text2 = converter != null ? converter.fun(item) : item.toString();
            this.addItem(item, text2, false);
        }
    }

    public void addItem(T item, String text2, boolean selected2) {
        JCheckBox checkBox2 = new JCheckBox(text2, selected2);
        checkBox2.setOpaque(true);
        this.myItemMap.put(item, checkBox2);
        ((DefaultListModel)this.getModel()).addElement(checkBox2);
    }

    public void updateItem(@NotNull T oldItem, @NotNull T newItem, @NotNull String newText) {
        if (oldItem == null) {
            CheckBoxList.$$$reportNull$$$0(6);
        }
        if (newItem == null) {
            CheckBoxList.$$$reportNull$$$0(7);
        }
        if (newText == null) {
            CheckBoxList.$$$reportNull$$$0(8);
        }
        JCheckBox checkBox2 = this.myItemMap.remove(oldItem);
        this.myItemMap.put(newItem, checkBox2);
        checkBox2.setText(newText);
        DefaultListModel model = (DefaultListModel)this.getModel();
        int ind = model.indexOf(checkBox2);
        if (ind >= 0) {
            model.set(ind, checkBox2);
        }
    }

    @Nullable
    public T getItemAt(int index) {
        JCheckBox checkBox2 = (JCheckBox)this.getModel().getElementAt(index);
        List<T> value2 = this.myItemMap.getKeysByValue(checkBox2);
        return value2 == null || value2.isEmpty() ? null : (T)value2.get(0);
    }

    public void clear() {
        ((DefaultListModel)this.getModel()).clear();
        this.myItemMap.clear();
    }

    public boolean isItemSelected(int index) {
        return ((JCheckBox)this.getModel().getElementAt(index)).isSelected();
    }

    public boolean isItemSelected(T item) {
        JCheckBox checkBox2 = this.myItemMap.get(item);
        return checkBox2 != null && checkBox2.isSelected();
    }

    public void setItemSelected(T item, boolean selected2) {
        JCheckBox checkBox2 = this.myItemMap.get(item);
        if (checkBox2 != null) {
            checkBox2.setSelected(selected2);
        }
    }

    private void setSelected(JCheckBox checkbox, int index, boolean value2) {
        checkbox.setSelected(value2);
        this.repaint();
        ListModel model = this.getModel();
        if (model instanceof DefaultListModel) {
            ((DefaultListModel)model).setElementAt(this.getModel().getElementAt(index), index);
        }
        if (this.checkBoxListListener != null) {
            this.checkBoxListListener.checkBoxSelectionChanged(index, value2);
        }
    }

    public void setCheckBoxListListener(CheckBoxListListener checkBoxListListener) {
        this.checkBoxListListener = checkBoxListListener;
    }

    protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox2, int index, boolean selected2, boolean hasFocus) {
        return rootComponent;
    }

    @Nls
    @Nullable
    protected String getSecondaryText(int index) {
        return null;
    }

    protected boolean isEnabled(int index) {
        return true;
    }

    protected Color getBackground(boolean isSelected) {
        return isSelected ? this.getSelectionBackground() : this.getBackground();
    }

    protected Color getForeground(boolean isSelected) {
        return isSelected ? this.getSelectionForeground() : this.getForeground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/CheckBoxList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldItem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/CheckBoxList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckBoxAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxDimension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findPointRelativeToCheckBox";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPointRelativeToCheckBoxWithAdjustedRendering";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildLocationRelativeToAncestor";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CellRenderer
    implements ListCellRenderer<JCheckBox> {
        private final Border mySelectedBorder = UIManager.getBorder("List.focusCellHighlightBorder");
        private final Border myBorder;
        private final Insets myBorderInsets = this.mySelectedBorder.getBorderInsets(new JCheckBox());

        private CellRenderer() {
            this.myBorder = new EmptyBorder(this.myBorderInsets);
        }

        @Override
        public Component getListCellRendererComponent(JList list2, JCheckBox checkbox, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent rootComponent;
            Color textColor = CheckBoxList.this.getForeground(isSelected);
            Color backgroundColor = CheckBoxList.this.getBackground(isSelected);
            Font font = CheckBoxList.this.getFont();
            checkbox.setBackground(backgroundColor);
            checkbox.setForeground(textColor);
            checkbox.setEnabled(CheckBoxList.this.isEnabled() && CheckBoxList.this.isEnabled(index));
            checkbox.setFont(font);
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(false);
            checkbox.setOpaque(true);
            String auxText = CheckBoxList.this.getSecondaryText(index);
            if (auxText != null) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.add((Component)checkbox, "Before");
                JLabel infoLabel = new JLabel(auxText, 4);
                infoLabel.setBorder(JBUI.Borders.emptyRight(checkbox.getInsets().left));
                infoLabel.setFont(UIUtil.getFont(UIUtil.FontSize.SMALL, font));
                panel2.add((Component)infoLabel, "Center");
                panel2.setBackground(backgroundColor);
                infoLabel.setForeground(isSelected ? textColor : JBColor.GRAY);
                infoLabel.setBackground(backgroundColor);
                rootComponent = panel2;
            } else {
                rootComponent = checkbox;
            }
            rootComponent.setBorder(isSelected ? this.mySelectedBorder : this.myBorder);
            boolean isRollOver = checkbox.getModel().isRollover();
            rootComponent = CheckBoxList.this.adjustRendering(rootComponent, checkbox, index, isSelected, cellHasFocus);
            checkbox.getModel().setRollover(isRollOver);
            return rootComponent;
        }

        @NotNull
        private Insets getBorderInsets() {
            Insets insets = this.myBorderInsets;
            if (insets == null) {
                CellRenderer.$$$reportNull$$$0(0);
            }
            return insets;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/CheckBoxList$CellRenderer", "getBorderInsets"));
        }
    }
}

