/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.accessibility.AccessibleContext;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxTreeBase
extends Tree {
    private final CheckboxTreeHelper myHelper;
    private final EventDispatcher<CheckboxTreeListener> myEventDispatcher = EventDispatcher.create(CheckboxTreeListener.class);

    public CheckboxTreeBase() {
        this(new CheckboxTreeCellRendererBase(), null);
    }

    public CheckboxTreeBase(CheckboxTreeCellRendererBase cellRenderer, CheckedTreeNode root) {
        this(cellRenderer, root, CheckboxTreeHelper.DEFAULT_POLICY);
    }

    public CheckboxTreeBase(CheckboxTreeCellRendererBase cellRenderer, @Nullable CheckedTreeNode root, CheckPolicy checkPolicy) {
        this.myHelper = new CheckboxTreeHelper(checkPolicy, this.myEventDispatcher);
        if (root != null) {
            this.setModel(new DefaultTreeModel(root));
            this.setSelectionRow(0);
        }
        this.myEventDispatcher.addListener(new CheckboxTreeListener(){

            @Override
            public void mouseDoubleClicked(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                CheckboxTreeBase.this.onDoubleClick(node);
            }

            @Override
            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                CheckboxTreeBase.this.onNodeStateChanged(node);
            }

            @Override
            public void beforeNodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                CheckboxTreeBase.this.nodeStateWillChange(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/ui/CheckboxTreeBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseDoubleClicked";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "nodeStateChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeNodeStateChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myHelper.initTree(this, this, cellRenderer);
    }

    @Deprecated
    protected boolean toggleNode(CheckedTreeNode node) {
        this.setNodeState(node, !node.isChecked());
        return node.isChecked();
    }

    @Deprecated
    protected void checkNode(CheckedTreeNode node, boolean checked) {
        this.setNodeState(node, checked);
    }

    public void setNodeState(@NotNull CheckedTreeNode node, boolean checked) {
        if (node == null) {
            CheckboxTreeBase.$$$reportNull$$$0(0);
        }
        this.myHelper.setNodeState(this, node, checked);
    }

    public void addCheckboxTreeListener(@NotNull CheckboxTreeListener listener2) {
        if (listener2 == null) {
            CheckboxTreeBase.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher.addListener(listener2);
    }

    protected void onDoubleClick(CheckedTreeNode node) {
    }

    public <T> T[] getCheckedNodes(Class<? extends T> nodeType, @Nullable Tree.NodeFilter<? super T> filter2) {
        return CheckboxTreeHelper.getCheckedNodes(nodeType, filter2, this.getModel());
    }

    @Override
    public int getToggleClickCount() {
        return -1;
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
    }

    protected void nodeStateWillChange(CheckedTreeNode node) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/CheckboxTreeBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setNodeState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addCheckboxTreeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CheckPolicy {
        final boolean checkChildrenWithCheckedParent;
        final boolean uncheckChildrenWithUncheckedParent;
        final boolean checkParentWithCheckedChild;
        final boolean uncheckParentWithUncheckedChild;

        public CheckPolicy(boolean checkChildrenWithCheckedParent, boolean uncheckChildrenWithUncheckedParent, boolean checkParentWithCheckedChild, boolean uncheckParentWithUncheckedChild) {
            this.checkChildrenWithCheckedParent = checkChildrenWithCheckedParent;
            this.uncheckChildrenWithUncheckedParent = uncheckChildrenWithUncheckedParent;
            this.checkParentWithCheckedChild = checkParentWithCheckedChild;
            this.uncheckParentWithUncheckedChild = uncheckParentWithUncheckedChild;
        }
    }

    @Deprecated
    public static enum NodeState {
        FULL,
        CLEAR,
        PARTIAL;

    }

    public static class CheckboxTreeCellRendererBase
    extends JPanel
    implements TreeCellRenderer {
        private final ColoredTreeCellRenderer myTextRenderer;
        public final ThreeStateCheckBox myCheckbox;
        private final boolean myUsePartialStatusForParentNodes;
        protected boolean myIgnoreInheritance;

        public CheckboxTreeCellRendererBase(boolean opaque) {
            this(opaque, true);
        }

        public CheckboxTreeCellRendererBase(boolean opaque, boolean usePartialStatusForParentNodes) {
            super(new BorderLayout());
            this.myUsePartialStatusForParentNodes = usePartialStatusForParentNodes;
            this.myCheckbox = new ThreeStateCheckBox();
            this.myCheckbox.setSelected(false);
            this.myCheckbox.setThirdStateEnabled(false);
            this.myTextRenderer = new ColoredTreeCellRenderer(){

                @Override
                public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (tree == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/CheckboxTreeBase$CheckboxTreeCellRendererBase$1", "customizeCellRenderer"));
                }
            };
            this.myTextRenderer.setOpaque(opaque);
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)this.myTextRenderer, "Center");
        }

        public CheckboxTreeCellRendererBase() {
            this(true);
        }

        @Override
        public final Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.invalidate();
            if (value2 instanceof CheckedTreeNode) {
                CheckedTreeNode node = (CheckedTreeNode)value2;
                ThreeStateCheckBox.State state = this.getNodeStatus(node);
                this.myCheckbox.setVisible(true);
                this.myCheckbox.setEnabled(node.isEnabled());
                this.myCheckbox.setSelected(state != ThreeStateCheckBox.State.NOT_SELECTED);
                this.myCheckbox.setState(state);
                this.myCheckbox.setOpaque(false);
                this.myCheckbox.setBackground(null);
                this.setBackground(null);
                if (UIUtil.isUnderWin10LookAndFeel()) {
                    Object hoverValue = this.getClientProperty("JCheckBox.rollOver.rectangle");
                    this.myCheckbox.getModel().setRollover(hoverValue == value2);
                    Object pressedValue = this.getClientProperty("JCheckBox.pressed.rectangle");
                    this.myCheckbox.getModel().setPressed(pressedValue == value2);
                }
            } else {
                this.myCheckbox.setVisible(false);
            }
            this.myTextRenderer.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus);
            this.customizeRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
            this.revalidate();
            return this;
        }

        private ThreeStateCheckBox.State getNodeStatus(CheckedTreeNode node) {
            if (this.myIgnoreInheritance) {
                return node.isChecked() ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED;
            }
            boolean checked = node.isChecked();
            if (node.getChildCount() == 0 || !this.myUsePartialStatusForParentNodes) {
                return checked ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED;
            }
            ThreeStateCheckBox.State result2 = null;
            for (int i = 0; i < node.getChildCount(); ++i) {
                ThreeStateCheckBox.State childStatus;
                TreeNode child2 = node.getChildAt(i);
                ThreeStateCheckBox.State state = child2 instanceof CheckedTreeNode ? this.getNodeStatus((CheckedTreeNode)child2) : (childStatus = checked ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED);
                if (childStatus == ThreeStateCheckBox.State.DONT_CARE) {
                    return ThreeStateCheckBox.State.DONT_CARE;
                }
                if (result2 == null) {
                    result2 = childStatus;
                    continue;
                }
                if (result2 == childStatus) continue;
                return ThreeStateCheckBox.State.DONT_CARE;
            }
            return result2 == null ? ThreeStateCheckBox.State.NOT_SELECTED : result2;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleContextDelegate(super.getAccessibleContext()){

                    @Override
                    protected Container getDelegateParent() {
                        return this.getParent();
                    }

                    @Override
                    public String getAccessibleName() {
                        return AccessibleContextUtil.combineAccessibleStrings(myTextRenderer.getAccessibleContext().getAccessibleName(), myCheckbox.isSelected() ? "checked" : "not checked");
                    }
                };
            }
            return this.accessibleContext;
        }

        public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof CheckedTreeNode) {
                this.customizeCellRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
            }
        }

        @Deprecated
        public void customizeCellRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        }

        public ColoredTreeCellRenderer getTextRenderer() {
            return this.myTextRenderer;
        }

        public JCheckBox getCheckbox() {
            return this.myCheckbox;
        }
    }
}

