/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class ColorPanel
extends JComponent {
    private static final RelativeFont MONOSPACED_FONT = RelativeFont.SMALL.family("Monospaced");
    private final List<ActionListener> myListeners = new CopyOnWriteArrayList<ActionListener>();
    private final JTextField myTextField = new JBTextField(8);
    private boolean myEditable;
    private ActionEvent myEvent;
    private Color myColor;
    private boolean mySupportTransparency;

    public ColorPanel() {
        this.addImpl(this.myTextField, null, 0);
        this.setEditable(true);
        this.setMinimumSize(JBUI.size(10, 10));
        this.myTextField.addMouseListener(EventHandler.create(MouseListener.class, this, "onPressed", null, "mousePressed"));
        this.myTextField.addKeyListener(EventHandler.create(KeyListener.class, this, "onPressed", "keyCode", "keyPressed"));
        this.myTextField.setEditable(false);
        MONOSPACED_FONT.install(this.myTextField);
        Painter.BACKGROUND.install(this.myTextField, true);
    }

    public void onPressed(int keyCode) {
        if (keyCode == 32) {
            this.onPressed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPressed() {
        Color color;
        if (this.myEditable && this.isEnabled() && (color = ColorChooser.chooseColor(this, UIBundle.message("color.panel.select.color.dialog.description", new Object[0]), this.myColor, this.mySupportTransparency)) != null) {
            this.setSelectedColor(color);
            if (!this.myListeners.isEmpty() && this.myEvent == null) {
                try {
                    this.myEvent = new ActionEvent(this, 1001, "colorPanelChanged");
                    for (ActionListener listener2 : this.myListeners) {
                        listener2.actionPerformed(this.myEvent);
                    }
                }
                finally {
                    this.myEvent = null;
                }
            }
        }
    }

    @Override
    public void doLayout() {
        Rectangle bounds2 = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom(bounds2, this.getInsets());
        this.myTextField.setBounds(bounds2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension size = this.myTextField.getPreferredSize();
        JBInsets.addTo(size, this.getInsets());
        return size;
    }

    @Override
    public String getToolTipText() {
        return this.myTextField.getToolTipText();
    }

    public void removeActionListener(ActionListener actionlistener) {
        this.myListeners.remove(actionlistener);
    }

    public void addActionListener(ActionListener actionlistener) {
        this.myListeners.add(actionlistener);
    }

    @Nullable
    public Color getSelectedColor() {
        return this.myColor;
    }

    public void setSelectedColor(@Nullable Color color) {
        this.myColor = color;
        this.updateSelectedColor();
    }

    private void updateSelectedColor() {
        Color color;
        boolean enabled = this.isEnabled();
        if (enabled && this.myEditable) {
            this.myTextField.setEnabled(true);
            this.myTextField.setToolTipText(UIBundle.message("color.panel.select.color.tooltip.text", new Object[0]));
        } else {
            this.myTextField.setEnabled(false);
            this.myTextField.setToolTipText(null);
        }
        Color color2 = color = enabled ? this.myColor : null;
        if (color != null) {
            this.myTextField.setText(StringUtil.toUpperCase(ColorUtil.toHex(color)));
        } else {
            this.myTextField.setText(null);
            color = this.getBackground();
        }
        this.myTextField.setBackground(color);
        this.myTextField.setSelectedTextColor(color);
        if (color != null) {
            int gray = (int)(0.212656 * (double)color.getRed() + 0.715158 * (double)color.getGreen() + 0.072186 * (double)color.getBlue());
            int delta = gray < 32 ? 96 : (gray < 80 ? 64 : (gray < 128 ? 32 : (gray < 176 ? -32 : (gray < 224 ? -64 : -96))));
            color = new Color(gray += delta, gray, gray);
            this.myTextField.setDisabledTextColor(color);
            this.myTextField.setSelectionColor(color);
            color = new Color(gray += delta, gray, gray);
            this.myTextField.setForeground(color);
        }
    }

    public void setEditable(boolean editable) {
        this.myEditable = editable;
        this.updateSelectedColor();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateSelectedColor();
    }

    public void setSupportTransparency(boolean supportTransparency) {
        this.mySupportTransparency = supportTransparency;
    }

    private static class Painter
    implements Highlighter.HighlightPainter,
    PropertyChangeListener {
        private static final String PROPERTY = "highlighter";
        private static final Painter BACKGROUND = new Painter();

        private Painter() {
        }

        @Override
        public void paint(Graphics g, int p0, int p1, Shape shape, JTextComponent component2) {
            Color color = component2.getBackground();
            if (color != null) {
                g.setColor(color);
                Rectangle bounds2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object source = event.getSource();
            if (source instanceof JTextComponent && PROPERTY.equals(event.getPropertyName())) {
                this.install((JTextComponent)source, false);
            }
        }

        private void install(JTextComponent component2, boolean listener2) {
            try {
                Highlighter highlighter = component2.getHighlighter();
                if (highlighter != null) {
                    highlighter.addHighlight(0, 0, this);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (listener2) {
                component2.addPropertyChangeListener(PROPERTY, this);
            }
        }
    }
}

