/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonActionsPanel
extends JPanel {
    private final ActionToolbarPosition myPosition;
    private final ActionToolbar myToolbar;
    private final Map<Buttons, MyActionButton> myButtons = new HashMap<Buttons, MyActionButton>();
    private final AnActionButton[] myActions;
    private EnumMap<Buttons, ShortcutSet> myCustomShortcuts;

    CommonActionsPanel(ListenerFactory factory, @Nullable JComponent contextComponent, ActionToolbarPosition position, AnActionButton @Nullable [] additionalActions, @Nullable Comparator<AnActionButton> buttonComparator, String addName, String removeName, String moveUpName, String moveDownName, String editName, Icon addIcon, Buttons ... buttons) {
        super(new BorderLayout());
        int i;
        this.myPosition = position;
        Listener listener2 = factory.createListener(this);
        AnActionButton[] actions = new AnActionButton[buttons.length + (additionalActions == null ? 0 : additionalActions.length)];
        for (i = 0; i < buttons.length; ++i) {
            AnActionButton[] button2 = buttons[i];
            String name = null;
            switch (2.$SwitchMap$com$intellij$ui$CommonActionsPanel$Buttons[button2.ordinal()]) {
                case 1: {
                    name = addName;
                    break;
                }
                case 2: {
                    name = editName;
                    break;
                }
                case 3: {
                    name = removeName;
                    break;
                }
                case 4: {
                    name = moveUpName;
                    break;
                }
                case 5: {
                    name = moveDownName;
                }
            }
            MyActionButton b = button2.createButton(listener2, name, button2 == Buttons.ADD && addIcon != null ? addIcon : button2.getIcon());
            actions[i] = b;
            this.myButtons.put((Buttons)button2, b);
        }
        if (additionalActions != null && additionalActions.length > 0) {
            i = buttons.length;
            for (AnActionButton button3 : additionalActions) {
                actions[i++] = button3;
            }
        }
        this.myActions = actions;
        for (AnActionButton action2 : actions) {
            action2.setContextComponent(contextComponent);
        }
        if (buttonComparator != null) {
            Arrays.sort(this.myActions, buttonComparator);
        }
        ArrayList<AnActionButton> toolbarActions = ContainerUtil.newArrayList(this.myActions);
        for (int i2 = 0; i2 < toolbarActions.size(); ++i2) {
            if (!(toolbarActions.get(i2) instanceof AnActionButton.CheckedAnActionButton)) continue;
            toolbarActions.set(i2, (AnActionButton)((AnActionButton.CheckedAnActionButton)toolbarActions.get(i2)).getDelegate());
        }
        ActionManagerEx mgr = (ActionManagerEx)ActionManager.getInstance();
        this.myToolbar = mgr.createActionToolbar("ToolbarDecorator", new DefaultActionGroup(toolbarActions.toArray(AnAction.EMPTY_ARRAY)), position == ActionToolbarPosition.BOTTOM || position == ActionToolbarPosition.TOP);
        this.myToolbar.getComponent().setBorder(null);
        this.add((Component)this.myToolbar.getComponent(), "Center");
    }

    @NotNull
    public ActionToolbar getToolbar() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar == null) {
            CommonActionsPanel.$$$reportNull$$$0(0);
        }
        return actionToolbar;
    }

    public void setToolbarLabel(JComponent label2, ActionToolbarPosition position) {
        this.removeAll();
        this.add((Component)label2, ToolbarDecorator.getPlacement(position));
        if (position == ActionToolbarPosition.LEFT) {
            this.add((Component)this.myToolbar.getComponent(), "East");
        } else if (position == ActionToolbarPosition.RIGHT) {
            this.add((Component)this.myToolbar.getComponent(), "West");
        } else {
            this.add((Component)this.myToolbar.getComponent(), "Center");
        }
    }

    public AnActionButton getAnActionButton(Buttons button2) {
        return this.myButtons.get((Object)button2);
    }

    @Override
    public void addNotify() {
        if (this.getBackground() != null && !this.getBackground().equals(UIUtil.getPanelBackground())) {
            SwingUtilities.updateComponentTreeUI(this.getParent());
        }
        JRootPane pane2 = this.getRootPane();
        for (AnActionButton button2 : this.myActions) {
            ShortcutSet customShortCut;
            ShortcutSet shortcut = button2.getShortcut();
            if (shortcut == null) continue;
            if (button2 instanceof MyActionButton && this.myCustomShortcuts != null && (customShortCut = this.myCustomShortcuts.get((Object)((MyActionButton)button2).myButton)) != null) {
                shortcut = customShortCut;
            }
            if (button2 instanceof AddButton && UIUtil.isDialogRootPane(pane2)) {
                button2.registerCustomShortcutSet(shortcut, pane2);
            } else {
                button2.registerCustomShortcutSet(shortcut, button2.getContextComponent());
            }
            if (!(button2 instanceof RemoveButton)) continue;
            CommonActionsPanel.registerDeleteHook((MyActionButton)button2);
        }
        super.addNotify();
    }

    private static void registerDeleteHook(final MyActionButton removeButton) {
        new AnAction(IdeBundle.messagePointer("action.Anonymous.text.delete.hook", new Object[0])){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                removeButton.actionPerformed(e);
            }

            @Override
            public boolean isDumbAware() {
                return removeButton.isDumbAware();
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                JComponent contextComponent;
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((contextComponent = removeButton.getContextComponent()) instanceof JTable && ((JTable)contextComponent).isEditing()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply(contextComponent);
                if (supply != null && supply.isPopupActive()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                removeButton.update(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/CommonActionsPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet(CustomShortcutSet.fromString("DELETE", "BACK_SPACE"), removeButton.getContextComponent());
    }

    public void setEnabled(Buttons button2, boolean enabled) {
        MyActionButton b = this.myButtons.get((Object)button2);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public void setCustomShortcuts(@NotNull Buttons button2, ShortcutSet ... shortcutSets) {
        if (button2 == null) {
            CommonActionsPanel.$$$reportNull$$$0(1);
        }
        if (shortcutSets != null) {
            if (this.myCustomShortcuts == null) {
                this.myCustomShortcuts = new EnumMap(Buttons.class);
            }
            this.myCustomShortcuts.put(button2, new CompositeShortcutSet(shortcutSets));
        } else if (this.myCustomShortcuts != null) {
            this.myCustomShortcuts.remove((Object)button2);
            if (this.myCustomShortcuts.isEmpty()) {
                this.myCustomShortcuts = null;
            }
        }
    }

    @NotNull
    public ActionToolbarPosition getPosition() {
        ActionToolbarPosition actionToolbarPosition = this.myPosition;
        if (actionToolbarPosition == null) {
            CommonActionsPanel.$$$reportNull$$$0(2);
        }
        return actionToolbarPosition;
    }

    @Contract(value="!null -> !null")
    public static ShortcutSet getCommonShortcut(Buttons button2) {
        switch (button2) {
            case ADD: {
                return CommonShortcuts.getNewForDialogs();
            }
            case EDIT: {
                return CustomShortcutSet.fromString("ENTER");
            }
            case REMOVE: {
                return CustomShortcutSet.fromString(SystemInfo.isMac ? "meta BACK_SPACE" : "alt DELETE");
            }
            case UP: {
                return CommonShortcuts.MOVE_UP;
            }
            case DOWN: {
                return CommonShortcuts.MOVE_DOWN;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/CommonActionsPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/CommonActionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCustomShortcuts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface ListenerFactory {
        public Listener createListener(CommonActionsPanel var1);
    }

    static class DownButton
    extends MyActionButton {
        DownButton(Listener listener2, String name, Icon icon2) {
            super(Buttons.DOWN, listener2, name, icon2);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && max < size - 1;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DownButton.$$$reportNull$$$0(0);
            }
            this.myListener.doDown();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$DownButton", "actionPerformed"));
        }
    }

    static class UpButton
    extends MyActionButton {
        UpButton(Listener listener2, String name, Icon icon2) {
            super(Buttons.UP, listener2, name, icon2);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && min >= 1;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UpButton.$$$reportNull$$$0(0);
            }
            this.myListener.doUp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$UpButton", "actionPerformed"));
        }
    }

    static class EditButton
    extends MyActionButton {
        EditButton(Listener listener2, String name, Icon icon2) {
            super(Buttons.EDIT, listener2, name, icon2);
        }

        @Override
        public void updateButton(@NotNull AnActionEvent e) {
            JComponent c;
            if (e == null) {
                EditButton.$$$reportNull$$$0(0);
            }
            if ((c = this.getContextComponent()) == null || !c.isShowing() || !c.isEnabled()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof KeyEvent && c instanceof JTable && ((JTable)c).isEditing() && !(inputEvent.getComponent() instanceof ActionButtonComponent)) {
                e.getPresentation().setEnabled(false);
                return;
            }
            super.updateButton(e);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && min == max && min >= 0;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditButton.$$$reportNull$$$0(1);
            }
            this.myListener.doEdit();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ui/CommonActionsPanel$EditButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class RemoveButton
    extends MyActionButton {
        RemoveButton(Listener listener2, String name, Icon icon2) {
            super(Buttons.REMOVE, listener2, name, icon2);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveButton.$$$reportNull$$$0(0);
            }
            this.myListener.doRemove();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$RemoveButton", "actionPerformed"));
        }
    }

    static class AddButton
    extends MyActionButton {
        AddButton(Listener listener2, String name, Icon icon2) {
            super(Buttons.ADD, listener2, name, icon2);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return true;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddButton.$$$reportNull$$$0(0);
            }
            this.myListener.doAdd();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$AddButton", "actionPerformed"));
        }
    }

    static abstract class MyActionButton
    extends AnActionButton
    implements DumbAware {
        private final Buttons myButton;
        protected final Listener myListener;

        MyActionButton(Buttons button2, Listener listener2, String name, Icon icon2) {
            super(name, name, icon2);
            this.myButton = button2;
            this.myListener = listener2;
        }

        @Override
        public ShortcutSet getShortcut() {
            return CommonActionsPanel.getCommonShortcut(this.myButton);
        }

        @Override
        public void updateButton(@NotNull AnActionEvent e) {
            if (e == null) {
                MyActionButton.$$$reportNull$$$0(0);
            }
            super.updateButton(e);
            if (!e.getPresentation().isEnabled()) {
                return;
            }
            JComponent c = this.getContextComponent();
            if (c instanceof JTable || c instanceof JList) {
                ListSelectionModel model = c instanceof JTable ? ((JTable)c).getSelectionModel() : ((JList)c).getSelectionModel();
                int size = c instanceof JTable ? ((JTable)c).getRowCount() : ((JList)c).getModel().getSize();
                int min = model.getMinSelectionIndex();
                int max = model.getMaxSelectionIndex();
                e.getPresentation().setEnabled(this.isEnabled() && this.isEnabled(size, min, max));
            }
        }

        protected abstract boolean isEnabled(int var1, int var2, int var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$MyActionButton", "updateButton"));
        }
    }

    public static interface Listener {
        default public void doAdd() {
        }

        default public void doRemove() {
        }

        default public void doUp() {
        }

        default public void doDown() {
        }

        default public void doEdit() {
        }
    }

    public static enum Buttons {
        ADD,
        REMOVE,
        EDIT,
        UP,
        DOWN;

        public static final Buttons[] ALL;
        @NotNull
        private static final Map<Buttons, Supplier<String>> ourPresentableNamesMap;

        public Icon getIcon() {
            switch (this) {
                case ADD: {
                    return IconUtil.getAddIcon();
                }
                case EDIT: {
                    return IconUtil.getEditIcon();
                }
                case REMOVE: {
                    return IconUtil.getRemoveIcon();
                }
                case UP: {
                    return IconUtil.getMoveUpIcon();
                }
                case DOWN: {
                    return IconUtil.getMoveDownIcon();
                }
            }
            return null;
        }

        MyActionButton createButton(Listener listener2, String name, Icon icon2) {
            String buttonName = name == null ? this.getText() : name;
            switch (this) {
                case ADD: {
                    return new AddButton(listener2, buttonName, icon2);
                }
                case REMOVE: {
                    return new RemoveButton(listener2, buttonName, icon2);
                }
                case EDIT: {
                    return new EditButton(listener2, buttonName, icon2);
                }
                case UP: {
                    return new UpButton(listener2, buttonName, icon2);
                }
                case DOWN: {
                    return new DownButton(listener2, buttonName, icon2);
                }
            }
            throw new IllegalStateException("can't reach this");
        }

        public String getText() {
            return ourPresentableNamesMap.get((Object)this).get();
        }

        static {
            ALL = new Buttons[]{ADD, REMOVE, EDIT, UP, DOWN};
            ourPresentableNamesMap = ContainerUtil.newHashMap(new Pair<Buttons, Supplier<String>>(ADD, UIBundle.messagePointer("button.text.add", new Object[0])), new Pair<Buttons, Supplier<String>>(REMOVE, UIBundle.messagePointer("button.text.remove", new Object[0])), new Pair<Buttons, Supplier<String>>(EDIT, UIBundle.messagePointer("button.text.edit", new Object[0])), new Pair<Buttons, Supplier<String>>(UP, UIBundle.messagePointer("button.text.up", new Object[0])), new Pair<Buttons, Supplier<String>>(DOWN, UIBundle.messagePointer("button.text.down", new Object[0])));
        }
    }
}

