/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.CellRendererPane;

public abstract class ComponentTreeWatcher {
    protected final Class[] myControlsToIgnore;
    private final ContainerListener myContainerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            ComponentTreeWatcher.this.register(e.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            ComponentTreeWatcher.this.unregister(e.getChild());
        }
    };

    protected ComponentTreeWatcher(Class[] controlsToIgnore) {
        this.myControlsToIgnore = controlsToIgnore;
    }

    protected boolean shouldBeIgnored(Object object) {
        if (object instanceof CellRendererPane) {
            return true;
        }
        if (object == null) {
            return true;
        }
        for (Class aClass : this.myControlsToIgnore) {
            if (!ReflectionUtil.isAssignable(aClass, object.getClass())) continue;
            return true;
        }
        return false;
    }

    public final void register(Component parentComponent) {
        if (this.shouldBeIgnored(parentComponent)) {
            return;
        }
        if (parentComponent instanceof Container && this.processChildren((Container)parentComponent)) {
            Container container2 = (Container)parentComponent;
            for (int i = 0; i < container2.getComponentCount(); ++i) {
                this.register(container2.getComponent(i));
            }
            container2.addContainerListener(this.myContainerListener);
        }
        this.processComponent(parentComponent);
    }

    protected boolean processChildren(Container container2) {
        return true;
    }

    protected abstract void processComponent(Component var1);

    private void unregister(Component component2) {
        if (component2 instanceof Container && this.processChildren((Container)component2)) {
            Container container2 = (Container)component2;
            for (int i = 0; i < container2.getComponentCount(); ++i) {
                this.unregister(container2.getComponent(i));
            }
            container2.removeContainerListener(this.myContainerListener);
        }
        this.unprocessComponent(component2);
    }

    protected abstract void unprocessComponent(Component var1);
}

