/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentUtil {
    public static <T> T getClientProperty(@NotNull JComponent component2, @NotNull Key<T> key) {
        if (component2 == null) {
            ComponentUtil.$$$reportNull$$$0(0);
        }
        if (key == null) {
            ComponentUtil.$$$reportNull$$$0(1);
        }
        return (T)component2.getClientProperty(key);
    }

    public static <T> void putClientProperty(@NotNull JComponent component2, @NotNull Key<T> key, T value2) {
        if (component2 == null) {
            ComponentUtil.$$$reportNull$$$0(2);
        }
        if (key == null) {
            ComponentUtil.$$$reportNull$$$0(3);
        }
        component2.putClientProperty(key, value2);
    }

    public static boolean isDisableAutoRequestFocus() {
        return Registry.is("suppress.focus.stealing.disable.auto.request.focus", true);
    }

    public static boolean isMinimized(@Nullable Window window) {
        if (!(window instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)window;
        return frame.getExtendedState() == 1;
    }

    @NotNull
    public static Window getActiveWindow() {
        for (Window each : Window.getWindows()) {
            if (!each.isVisible() || !each.isActive()) continue;
            Window window = each;
            if (window == null) {
                ComponentUtil.$$$reportNull$$$0(4);
            }
            return window;
        }
        Frame frame = JOptionPane.getRootFrame();
        if (frame == null) {
            ComponentUtil.$$$reportNull$$$0(5);
        }
        return frame;
    }

    @NotNull
    public static Component findUltimateParent(@NotNull Component c) {
        if (c == null) {
            ComponentUtil.$$$reportNull$$$0(6);
        }
        Component eachParent = c;
        while (true) {
            if (eachParent.getParent() == null) {
                Component component2 = eachParent;
                if (component2 == null) {
                    ComponentUtil.$$$reportNull$$$0(7);
                }
                return component2;
            }
            eachParent = eachParent.getParent();
        }
    }

    @Nullable
    public static Window getWindow(@Nullable Component component2) {
        if (component2 == null) {
            return null;
        }
        return component2 instanceof Window ? (Window)component2 : SwingUtilities.getWindowAncestor(component2);
    }

    @Nullable
    public static Component findParentByCondition(@Nullable Component c, @NotNull Predicate<? super Component> condition2) {
        if (condition2 == null) {
            ComponentUtil.$$$reportNull$$$0(8);
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!condition2.test(eachParent)) continue;
            return eachParent;
        }
        return null;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getParentOfType(@NotNull Class<? extends T> type, Component component2) {
        if (type == null) {
            ComponentUtil.$$$reportNull$$$0(9);
        }
        while (component2 != null) {
            if (type.isInstance(component2)) {
                return (T)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ComponentUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ComponentUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findUltimateParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUltimateParent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

