/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ui.components.JBLabel;
import java.awt.Dimension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextHelpLabel
extends JBLabel {
    private final HelpTooltip tooltip;

    public ContextHelpLabel(@Nls String label2, @Nls String description) {
        super(label2);
        this.tooltip = new HelpTooltip().setDescription(description);
        this.initTooltip();
    }

    private ContextHelpLabel(@NotNull HelpTooltip tooltip) {
        if (tooltip == null) {
            ContextHelpLabel.$$$reportNull$$$0(0);
        }
        super(AllIcons.General.ContextHelp);
        this.tooltip = tooltip;
        this.initTooltip();
    }

    private void initTooltip() {
        this.tooltip.setNeverHideOnTimeout(true).setLocation(HelpTooltip.Alignment.HELP_BUTTON);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tooltip.installOn(this);
    }

    @Override
    public void removeNotify() {
        HelpTooltip.dispose(this);
        super.removeNotify();
    }

    @NotNull
    public static ContextHelpLabel create(@Nls @NotNull String description) {
        if (description == null) {
            ContextHelpLabel.$$$reportNull$$$0(1);
        }
        return new ContextHelpLabel(new HelpTooltip().setDescription(description));
    }

    @NotNull
    public static ContextHelpLabel create(@Nls @NotNull String title, @Nls @NotNull String description) {
        if (title == null) {
            ContextHelpLabel.$$$reportNull$$$0(2);
        }
        if (description == null) {
            ContextHelpLabel.$$$reportNull$$$0(3);
        }
        return new ContextHelpLabel(new HelpTooltip().setDescription(description).setTitle(title));
    }

    @NotNull
    public static ContextHelpLabel createWithLink(@Nls @Nullable String title, @Nls @NotNull String description, @Nls @NotNull String linkText, @NotNull Runnable linkAction) {
        if (description == null) {
            ContextHelpLabel.$$$reportNull$$$0(4);
        }
        if (linkText == null) {
            ContextHelpLabel.$$$reportNull$$$0(5);
        }
        if (linkAction == null) {
            ContextHelpLabel.$$$reportNull$$$0(6);
        }
        return new ContextHelpLabel(new HelpTooltip().setDescription(description).setTitle(title).setLink(linkText, linkAction));
    }

    @Override
    public void setPreferredSize(Dimension size) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkAction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ContextHelpLabel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createWithLink";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

