/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExcludingTraversalPolicy
extends FocusTraversalPolicy {
    private final FocusTraversalPolicy myWrappee;
    private final Set<Component> myExcludes;
    private final Set<String> myRecursionGuard;

    public ExcludingTraversalPolicy(Component ... excludes) {
        this(KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy(), excludes);
    }

    public ExcludingTraversalPolicy(@NotNull FocusTraversalPolicy wrappee, Component ... excludes) {
        if (wrappee == null) {
            ExcludingTraversalPolicy.$$$reportNull$$$0(0);
        }
        this.myExcludes = new THashSet<Component>();
        this.myRecursionGuard = new THashSet<String>();
        this.myWrappee = wrappee;
        Collections.addAll(this.myExcludes, excludes);
    }

    public void exclude(Component c) {
        this.myExcludes.add(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        try {
            if (!this.myRecursionGuard.add("getComponentAfter")) {
                Component component2 = null;
                return component2;
            }
            Component component3 = this.traverse(aContainer, aComponent, param -> this.myWrappee.getComponentAfter((Container)param.first, (Component)param.second));
            return component3;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        try {
            if (!this.myRecursionGuard.add("getComponentBefore")) {
                Component component2 = null;
                return component2;
            }
            Component component3 = this.traverse(aContainer, aComponent, param -> this.myWrappee.getComponentBefore((Container)param.first, (Component)param.second));
            return component3;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }

    private Component traverse(Container aContainer, Component aComponent, Function<? super Pair<Container, Component>, ? extends Component> func) {
        THashSet<Component> loopGuard = new THashSet<Component>();
        do {
            if (loopGuard.add(aComponent)) continue;
            return null;
        } while ((aComponent = func.fun(Pair.create(aContainer, aComponent))) != null && this.myExcludes.contains(aComponent));
        return aComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getFirstComponent(Container aContainer) {
        try {
            if (!this.myRecursionGuard.add("getFirstComponent")) {
                Component component2 = null;
                return component2;
            }
            Component result2 = this.myWrappee.getFirstComponent(aContainer);
            if (result2 == null) {
                Component component3 = null;
                return component3;
            }
            Component component4 = this.myExcludes.contains(result2) ? this.getComponentAfter(aContainer, result2) : result2;
            return component4;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getLastComponent(Container aContainer) {
        try {
            if (!this.myRecursionGuard.add("getLastComponent")) {
                Component component2 = null;
                return component2;
            }
            Component result2 = this.myWrappee.getLastComponent(aContainer);
            if (result2 == null) {
                Component component3 = null;
                return component3;
            }
            Component component4 = this.myExcludes.contains(result2) ? this.getComponentBefore(aContainer, result2) : result2;
            return component4;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }

    @Override
    public Component getDefaultComponent(Container aContainer) {
        try {
            if (!this.myRecursionGuard.add("getDefaultComponent")) {
                Component component2 = null;
                return component2;
            }
            Component component3 = this.getFirstComponent(aContainer);
            return component3;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappee", "com/intellij/ui/ExcludingTraversalPolicy", "<init>"));
    }
}

