/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Expandable;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.components.fields.ExpandableSupport;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class ExpandableEditorSupport
extends ExpandableSupport<EditorTextField> {
    public ExpandableEditorSupport(@NotNull EditorTextField field) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(0);
        }
        super(field, null, null);
        field.addSettingsProvider(editor -> {
            this.initFieldEditor(editor, field.getBackground());
            this.updateFieldFolding(editor);
        });
    }

    public ExpandableEditorSupport(@NotNull EditorTextField field, @NotNull Function<? super String, ? extends List<String>> parser, @NotNull Function<? super List<String>, String> joiner) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(1);
        }
        if (parser == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(2);
        }
        if (joiner == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(3);
        }
        super(field, (? super String text2) -> StringUtil.join((Collection)parser.fun((String)text2), "\n"), (? super String text2) -> (String)joiner.fun(Arrays.asList(StringUtil.splitByLines(text2))));
        field.addSettingsProvider(editor -> {
            this.initFieldEditor(editor, field.getBackground());
            this.updateFieldFolding(editor);
        });
    }

    protected void initPopupEditor(@NotNull EditorEx editor, Color background) {
        if (editor == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(4);
        }
        JLabel label2 = ExpandableSupport.createLabel(this.createCollapseExtension());
        label2.setBorder(JBUI.Borders.empty(5, 3, 5, 7));
        editor.getContentComponent().putClientProperty(Expandable.class, this);
        editor.getScrollPane().setHorizontalScrollBarPolicy(30);
        editor.getScrollPane().setVerticalScrollBarPolicy(20);
        editor.getScrollPane().getVerticalScrollBar().setBackground(background);
        editor.getScrollPane().getVerticalScrollBar().add("JB_SCROLL_BAR_LEADING_COMPONENT", label2);
        editor.getScrollPane().setViewportBorder(JBUI.Borders.empty(4, 6));
        label2.setOpaque(true);
    }

    protected void initFieldEditor(@NotNull EditorEx editor, Color background) {
        if (editor == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(5);
        }
        editor.getContentComponent().putClientProperty(Expandable.class, this);
        ExtendableTextComponent.Extension extension = this.createExpandExtension();
        ExtendableEditorSupport.setupExtension(editor, background, extension);
    }

    protected void updateFieldFolding(@NotNull EditorEx editor) {
        if (editor == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(6);
        }
        FoldingModelEx model = editor.getFoldingModel();
        CharSequence text2 = editor.getDocument().getCharsSequence();
        model.runBatchFoldingOperation(() -> {
            model.clearFoldRegions();
            for (int i = 0; i < text2.length(); ++i) {
                if (text2.charAt(i) != '\n') continue;
                model.createFoldRegion(i, i + 1, " \u23ce ", null, true);
            }
        });
    }

    @Override
    @NotNull
    protected ExpandableSupport.Content prepare(final @NotNull EditorTextField field, @NotNull Function<? super String, String> onShow) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(7);
        }
        if (onShow == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(8);
        }
        final EditorTextField popup2 = this.createPopupEditor(field, onShow.fun(field.getText()));
        Color background = field.getBackground();
        popup2.setBackground(background);
        popup2.setOneLineMode(false);
        popup2.setPreferredSize(new Dimension(field.getWidth(), 5 * field.getHeight()));
        popup2.addSettingsProvider(editor -> {
            this.initPopupEditor(editor, background);
            ExpandableEditorSupport.copyCaretPosition(editor, field.getEditor());
        });
        return new ExpandableSupport.Content(){

            @Override
            @NotNull
            public JComponent getContentComponent() {
                EditorTextField editorTextField = popup2;
                if (editorTextField == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorTextField;
            }

            @Override
            public JComponent getFocusableComponent() {
                return popup2;
            }

            @Override
            public void cancel(@NotNull Function<? super String, String> onHide) {
                if (onHide == null) {
                    1.$$$reportNull$$$0(1);
                }
                field.setText(onHide.fun(popup2.getText()));
                Editor editor = field.getEditor();
                if (editor != null) {
                    ExpandableEditorSupport.copyCaretPosition(editor, popup2.getEditor());
                }
                if (editor instanceof EditorEx) {
                    ExpandableEditorSupport.this.updateFieldFolding((EditorEx)editor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/ExpandableEditorSupport$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "onHide";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/ExpandableEditorSupport$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "cancel";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    protected EditorTextField createPopupEditor(@NotNull EditorTextField field, @NotNull String text2) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(10);
        }
        if (Comparing.equal(text2, field.getText())) {
            return new EditorTextField(field.getDocument(), field.getProject(), field.getFileType());
        }
        return new EditorTextField(text2, field.getProject(), field.getFileType());
    }

    private static void copyCaretPosition(@NotNull Editor destination, Editor source) {
        if (destination == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(11);
        }
        if (source == null) {
            return;
        }
        try {
            destination.getCaretModel().setCaretsAndSelections(source.getCaretModel().getCaretsAndSelections());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joiner";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onShow";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ExpandableEditorSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initPopupEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "initFieldEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFieldFolding";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createPopupEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "copyCaretPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

