/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.FontInfoRenderer;
import com.intellij.util.ui.FontInfo;
import com.intellij.util.ui.JBDimension;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.Nullable;

public final class FontComboBox
extends ComboBox {
    private Model myModel;
    private final JBDimension mySize;

    public FontComboBox() {
        this(false);
    }

    public FontComboBox(boolean withAllStyles) {
        this(withAllStyles, true, false);
    }

    public FontComboBox(boolean withAllStyles, boolean filterNonLatin, boolean noFontItem) {
        super(new Model(withAllStyles, filterNonLatin, noFontItem));
        Dimension size = super.getPreferredSize();
        size.width = size.height * 8;
        this.mySize = JBDimension.create(size, true);
        this.setSwingPopup(false);
        this.setRenderer(new FontInfoRenderer());
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() != -42 || e.getIndex1() != -42) {
                    return;
                }
                ComboPopup popup2 = FontComboBox.this.getPopup();
                if (popup2 != null && popup2.isVisible()) {
                    popup2.hide();
                    popup2.show();
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.mySize.size();
    }

    public boolean isMonospacedOnly() {
        return this.myModel.myMonospacedOnly;
    }

    public void setMonospacedOnly(boolean monospaced) {
        this.myModel.setMonospacedOnly(monospaced);
    }

    public String getFontName() {
        Object item = this.myModel.getSelectedItem();
        return item == null ? null : item.toString();
    }

    public void setFontName(@Nullable String item) {
        this.myModel.setSelectedItem(item);
    }

    public boolean isNoFontSelected() {
        return this.myModel.isNoFontSelected();
    }

    @Override
    public void setModel(ComboBoxModel model) {
        if (!(model instanceof Model)) {
            throw new UnsupportedOperationException();
        }
        this.myModel = (Model)model;
        super.setModel(model);
    }

    private static final class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private final NoFontItem myNoFontItem;
        private volatile List<FontInfo> myAllFonts = Collections.emptyList();
        private volatile List<FontInfo> myMonoFonts = Collections.emptyList();
        private boolean myMonospacedOnly;
        private Object mySelectedItem;

        private Model(boolean withAllStyles, boolean filterNonLatin, boolean noFontItem) {
            this.myNoFontItem = noFontItem ? new NoFontItem() : null;
            Application application = ApplicationManager.getApplication();
            if (application == null || application.isUnitTestMode()) {
                this.setFonts(FontInfo.getAll(withAllStyles), filterNonLatin);
            } else {
                application.executeOnPooledThread(() -> {
                    List<FontInfo> all = FontInfo.getAll(withAllStyles);
                    application.invokeLater(() -> {
                        this.setFonts(all, filterNonLatin);
                        this.onModelToggled();
                    }, application.getAnyModalityState());
                });
            }
        }

        private void setFonts(List<FontInfo> all, boolean filterNonLatin) {
            ArrayList<FontInfo> allFonts = new ArrayList<FontInfo>(all.size());
            ArrayList<FontInfo> monoFonts = new ArrayList<FontInfo>();
            for (FontInfo info : all) {
                if (filterNonLatin && info.getFont().canDisplayUpTo(info.toString()) != -1) continue;
                allFonts.add(info);
                if (!info.isMonospaced()) continue;
                monoFonts.add(info);
            }
            this.myAllFonts = allFonts;
            this.myMonoFonts = monoFonts;
        }

        public void setMonospacedOnly(boolean monospaced) {
            if (this.myMonospacedOnly != monospaced) {
                this.myMonospacedOnly = monospaced;
                this.onModelToggled();
            }
        }

        void onModelToggled() {
            Object item = this.getSelectedItem();
            this.setSelectedItem(null);
            this.setSelectedItem(item);
            this.fireContentsChanged(this, -42, -42);
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public void setSelectedItem(@Nullable Object item) {
            if (item == null && this.myNoFontItem != null) {
                item = this.myNoFontItem;
            } else {
                FontInfo info;
                if (item instanceof FontInfo && (info = this.getInfo(item)) == null) {
                    List<FontInfo> list2 = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
                    Object object = item = list2.isEmpty() ? null : list2.get(0);
                }
                if (item instanceof String && (info = this.getInfo(item)) != null) {
                    item = info;
                }
            }
            if (!Comparing.equal(this.mySelectedItem, item) || item == this.myNoFontItem) {
                this.mySelectedItem = item;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public boolean isNoFontSelected() {
            return this.getSelectedItem() == this.myNoFontItem;
        }

        @Override
        public int getSize() {
            List<FontInfo> list2 = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
            int size = list2.size();
            if (this.mySelectedItem instanceof String) {
                ++size;
            }
            if (this.myNoFontItem != null) {
                ++size;
            }
            return size;
        }

        @Override
        public Object getElementAt(int index) {
            int i = index;
            if (this.myNoFontItem != null) {
                if (index == 0) {
                    return this.myNoFontItem;
                }
                --i;
            }
            List<FontInfo> list2 = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
            return 0 <= i && i < list2.size() ? list2.get(i) : this.mySelectedItem;
        }

        private FontInfo getInfo(Object item) {
            for (FontInfo info : this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts) {
                if (!(item instanceof String ? info.toString().equalsIgnoreCase((String)item) : info.equals(item))) continue;
                return info;
            }
            return null;
        }

        private static final class NoFontItem {
            private NoFontItem() {
            }

            public String toString() {
                return ApplicationBundle.message("settings.editor.font.none", new Object[0]);
            }
        }
    }
}

