/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public final class GuiUtils {
    private static final Insets paddingInsideDialog = JBUI.insets(5);
    private static final CharFilter NOT_MNEMONIC_CHAR_FILTER = ch -> ch != '&' && ch != '\u001b';

    public static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    public static JPanel constructFieldWithBrowseButton(TextFieldWithHistory aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    private static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener, int delta) {
        JPanel result2 = new JPanel(new GridBagLayout());
        result2.add((Component)aComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, JBUI.emptyInsets(), 0, 0));
        FixedSizeButton browseButton = new FixedSizeButton(aComponent.getPreferredSize().height - delta);
        ComponentWithBrowseButton.MyDoClickAction.addTo(browseButton, aComponent);
        result2.add((Component)browseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, JBUI.emptyInsets(), 0, 0));
        browseButton.addActionListener(aActionListener);
        return result2;
    }

    @Deprecated
    public static JPanel constructDirectoryBrowserField(final JTextField field, final String objectName) {
        return GuiUtils.constructFieldWithBrowseButton(field, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle("Select " + objectName);
                VirtualFile file2 = FileChooser.chooseFile(descriptor2, field, null, null);
                if (file2 != null) {
                    field.setText(FileUtil.toSystemDependentName(file2.getPath()));
                    field.postActionEvent();
                }
            }
        });
    }

    @Deprecated
    public static JPanel makeTitledPanel(JComponent aComponent, String aTitle) {
        JPanel result2 = GuiUtils.makePaddedPanel(aComponent, false, true, false, true);
        return GuiUtils.wrapWithBorder(result2, IdeBorderFactory.createTitledBorder(aTitle));
    }

    private static JPanel wrapWithBorder(JComponent aPanel, Border aBorder) {
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)aPanel, "Center");
        wrapper2.setBorder(aBorder);
        return wrapper2;
    }

    @Deprecated
    public static BorderLayout createBorderLayout() {
        return new BorderLayout(GuiUtils.paddingInsideDialog.left, GuiUtils.paddingInsideDialog.top);
    }

    @Deprecated
    public static GridLayout createGridLayout(int aRows, int aColumns) {
        return new GridLayout(aRows, aColumns, GuiUtils.paddingInsideDialog.left, GuiUtils.paddingInsideDialog.top);
    }

    public static Component createVerticalStrut() {
        return Box.createRigidArea(new Dimension(0, GuiUtils.paddingInsideDialog.top));
    }

    private static JPanel makePaddedPanel(JComponent aComponent, boolean aTop, boolean aLeft, boolean aBottom, boolean aRight) {
        return GuiUtils.wrapWithBorder(aComponent, BorderFactory.createEmptyBorder(aTop ? GuiUtils.paddingInsideDialog.top : 0, aLeft ? GuiUtils.paddingInsideDialog.left : 0, aBottom ? GuiUtils.paddingInsideDialog.bottom : 0, aRight ? GuiUtils.paddingInsideDialog.right : 0));
    }

    public static String getTextWithoutMnemonicEscaping(String text2) {
        return StringUtil.strip(text2, NOT_MNEMONIC_CHAR_FILTER);
    }

    public static char getDisplayedMnemonic(String text2) {
        int i = GuiUtils.getDisplayedMnemonicIndex(text2);
        return i == -1 ? (char)'\uffff' : text2.charAt(i + 1);
    }

    public static int getDisplayedMnemonicIndex(String text2) {
        return text2.indexOf("&");
    }

    public static void replaceJSplitPaneWithIDEASplitter(JComponent root) {
        GuiUtils.replaceJSplitPaneWithIDEASplitter(root, false);
    }

    public static void replaceJSplitPaneWithIDEASplitter(JComponent root, boolean useOnePixelDivider) {
        Container parent = root.getParent();
        if (root instanceof JSplitPane) {
            if (parent.getComponents().length != 1 && !(parent instanceof Splitter)) {
                return;
            }
            JSplitPane pane2 = (JSplitPane)root;
            Component component1 = pane2.getTopComponent();
            Component component2 = pane2.getBottomComponent();
            int orientation = pane2.getOrientation();
            boolean vertical = orientation == 0;
            JBSplitter splitter = useOnePixelDivider ? new OnePixelSplitter(vertical) : new JBSplitter(vertical);
            splitter.setFirstComponent((JComponent)component1);
            splitter.setSecondComponent((JComponent)component2);
            splitter.setShowDividerControls(pane2.isOneTouchExpandable());
            splitter.setHonorComponentsMinimumSize(true);
            if (pane2.getDividerLocation() > 0) {
                SwingUtilities.invokeLater(() -> {
                    double proportion = pane2.getOrientation() == 0 ? (double)pane2.getDividerLocation() / (double)(parent.getHeight() - pane2.getDividerSize()) : (double)pane2.getDividerLocation() / (double)(parent.getWidth() - pane2.getDividerSize());
                    if (proportion > 0.0 && proportion < 1.0) {
                        splitter.setProportion((float)proportion);
                    }
                });
            }
            if (parent instanceof Splitter) {
                Splitter psplitter = (Splitter)parent;
                if (psplitter.getFirstComponent() == root) {
                    psplitter.setFirstComponent(splitter);
                } else {
                    psplitter.setSecondComponent(splitter);
                }
            } else {
                parent.remove(0);
                parent.setLayout(new BorderLayout());
                parent.add((Component)splitter, "Center");
            }
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component1, useOnePixelDivider);
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component2, useOnePixelDivider);
        } else {
            Component[] components;
            for (Component component2 : components = root.getComponents()) {
                if (!(component2 instanceof JComponent)) continue;
                GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component2, useOnePixelDivider);
            }
        }
    }

    public static void iterateChildren(Component container2, Consumer<? super Component> consumer, JComponent ... excludeComponents) {
        if (excludeComponents != null && ArrayUtil.find(excludeComponents, container2) != -1) {
            return;
        }
        consumer.consume(container2);
        if (container2 instanceof Container) {
            Component[] components;
            for (Component child2 : components = ((Container)container2).getComponents()) {
                GuiUtils.iterateChildren(child2, consumer, excludeComponents);
            }
        }
    }

    public static void enableChildren(boolean enabled, Component ... components) {
        for (Component component2 : components) {
            GuiUtils.enableChildren(component2, enabled, new JComponent[0]);
        }
    }

    public static void showComponents(boolean visible, Component ... components) {
        for (Component component2 : components) {
            component2.setVisible(visible);
        }
    }

    public static void enableChildren(Component container2, boolean enabled, JComponent ... excludeComponents) {
        GuiUtils.iterateChildren(container2, t -> GuiUtils.enableComponent(t, enabled), excludeComponents);
    }

    private static void enableComponent(Component component2, boolean enabled) {
        if (component2.isEnabled() == enabled) {
            return;
        }
        component2.setEnabled(enabled);
        if (component2 instanceof JPanel) {
            Border border = ((JPanel)component2).getBorder();
            if (border instanceof TitledBorder) {
                Color color = enabled ? component2.getForeground() : UIUtil.getInactiveTextColor();
                ((TitledBorder)border).setTitleColor(color);
            }
        } else if (component2 instanceof JLabel) {
            Color color = UIUtil.getInactiveTextColor();
            String changeColorString = "<font color=#" + GuiUtils.colorToHex(color) + ">";
            JLabel label2 = (JLabel)component2;
            String text2 = label2.getText();
            if (text2 != null && text2.startsWith("<html>")) {
                if (StringUtil.startsWithConcatenation(text2, "<html>", changeColorString) && enabled) {
                    text2 = "<html>" + text2.substring(("<html>" + changeColorString).length());
                } else if (!StringUtil.startsWithConcatenation(text2, "<html>", changeColorString) && !enabled) {
                    text2 = "<html>" + changeColorString + text2.substring("<html>".length());
                }
                label2.setText(text2);
            }
        } else if (component2 instanceof JTable) {
            TableColumnModel columnModel = ((JTable)component2).getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                TableCellRenderer cellRenderer = columnModel.getColumn(0).getCellRenderer();
                if (!(cellRenderer instanceof Component)) continue;
                GuiUtils.enableComponent((Component)((Object)cellRenderer), enabled);
            }
        }
    }

    public static String colorToHex(Color color) {
        return GuiUtils.to2DigitsHex(color.getRed()) + GuiUtils.to2DigitsHex(color.getGreen()) + GuiUtils.to2DigitsHex(color.getBlue());
    }

    private static String to2DigitsHex(int i) {
        String s = Integer.toHexString(i);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public static void runOrInvokeAndWait(@NotNull Runnable runnable2) throws InvocationTargetException, InterruptedException {
        if (runnable2 == null) {
            GuiUtils.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().invokeAndWait(runnable2);
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        Application app;
        if (runnable2 == null) {
            GuiUtils.$$$reportNull$$$0(1);
        }
        if (modalityState == null) {
            GuiUtils.$$$reportNull$$$0(2);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable2.run();
        } else {
            app.invokeLater(runnable2, modalityState);
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition expired) {
        Application app;
        if (runnable2 == null) {
            GuiUtils.$$$reportNull$$$0(3);
        }
        if (modalityState == null) {
            GuiUtils.$$$reportNull$$$0(4);
        }
        if (expired == null) {
            GuiUtils.$$$reportNull$$$0(5);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable2.run();
        } else {
            app.invokeLater(runnable2, modalityState, expired);
        }
    }

    public static JTextField createUndoableTextField() {
        return new JBTextField();
    }

    @NotNull
    public static Dimension getSizeByChars(int charCount, @NotNull JComponent comp) {
        if (comp == null) {
            GuiUtils.$$$reportNull$$$0(6);
        }
        Dimension size = comp.getPreferredSize();
        FontMetrics fontMetrics = comp.getFontMetrics(comp.getFont());
        size.width = fontMetrics.charWidth('a') * charCount;
        Dimension dimension = size;
        if (dimension == null) {
            GuiUtils.$$$reportNull$$$0(7);
        }
        return dimension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/GuiUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/GuiUtils";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSizeByChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runOrInvokeAndWait";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSizeByChars";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

