/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.HighlightableComponent;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class HighlightableCellRenderer
extends HighlightableComponent
implements TreeCellRenderer,
ListCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setText(tree.convertValueToText(value2, selected2, expanded, leaf, row, hasFocus));
        this.setFont(UIUtil.getTreeFont());
        this.setIcon(null);
        if (WideSelectionTreeUI.isWideSelection(tree)) {
            this.setOpaque(false);
            this.myIsSelected = false;
            this.myHasFocus = false;
            this.setDoNotHighlight(selected2 && hasFocus);
            this.setForeground(UIUtil.getTreeForeground(selected2, hasFocus));
        } else {
            this.setOpaque(true);
            this.myIsSelected = selected2;
            this.myHasFocus = hasFocus;
            this.setDoNotHighlight(false);
        }
        this.myHasFocus = hasFocus;
        return this;
    }

    public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText(value2 == null ? "" : value2.toString());
        this.setFont(UIUtil.getListFont());
        this.setIcon(null);
        this.myIsSelected = isSelected;
        this.myHasFocus = cellHasFocus;
        return this;
    }
}

